/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.list;

import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.list.EntityComparator;
import de.uniks.networkparser.list.SimpleSet;
import de.uniks.networkparser.list.SortingDirection;
import java.util.Comparator;

public class SortedSet<V>
extends SimpleSet<V> {
    protected Comparator<V> cpr;

    @Override
    public Comparator<Object> comparator() {
        if (this.cpr == null) {
            this.withComparator(new EntityComparator().withColumn("%values%").withDirection(SortingDirection.ASC));
        }
        return this.cpr;
    }

    @Override
    public boolean isComparator() {
        return true;
    }

    public SortedSet<V> withComparator(Comparator<V> comparator) {
        this.cpr = comparator;
        return this;
    }

    public SortedSet<V> withComparator(String column) {
        this.cpr = new EntityComparator().withColumn(column).withDirection(SortingDirection.ASC);
        return this;
    }

    public <ST extends SimpleSet<V>> ST tailSet(V fromElement, boolean inclusive) {
        int pos;
        if (!this.isComparator()) {
            return null;
        }
        BaseItem newList = this.getNewList(false);
        for (pos = 0; pos < this.size(); ++pos) {
            int compare = this.comparator().compare(this.get(pos), fromElement);
            if (compare == 0) {
                if (!inclusive) break;
                this.copyEntity(newList, pos++);
                break;
            }
            if (compare <= 0) continue;
            this.copyEntity(newList, pos++);
            break;
        }
        while (pos < this.size()) {
            this.copyEntity(newList, pos++);
        }
        return (ST)((SimpleSet)newList);
    }

    public <ST extends SimpleSet<V>> ST headSet(V toElement, boolean inclusive) {
        if (!this.isComparator()) {
            return null;
        }
        BaseItem newList = this.getNewList(false);
        for (int pos = 0; pos < this.size(); ++pos) {
            int compare = this.comparator().compare(this.get(pos), toElement);
            if (compare == 0) {
                if (!inclusive) break;
                this.copyEntity(newList, pos);
                break;
            }
            if (compare <= 0) continue;
            this.copyEntity(newList, pos);
            break;
        }
        return (ST)((SimpleSet)newList);
    }

    public V higher(V toElement) {
        if (!this.isComparator()) {
            return null;
        }
        for (int pos = 0; pos < this.size(); ++pos) {
            Object item = this.get(pos);
            int compare = this.comparator().compare(item, toElement);
            if (compare <= 0) continue;
            return item;
        }
        return null;
    }
}

