/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.list;

import de.uniks.networkparser.list.SimpleEntity;
import de.uniks.networkparser.list.SimpleKeyValueList;
import java.util.ListIterator;
import java.util.Map;

public class SimpleIteratorSet<K, V>
implements ListIterator<Map.Entry<K, V>> {
    private SimpleKeyValueList<K, V> list;
    private SimpleEntity<K, V> currentEntry;
    private int cursor = -1;

    public SimpleIteratorSet(SimpleKeyValueList<K, V> list) {
        this.list = list;
        this.currentEntry = new SimpleEntity();
    }

    public SimpleIteratorSet(Object collection) {
        if (collection instanceof SimpleKeyValueList) {
            this.list = (SimpleKeyValueList)collection;
        } else if (collection instanceof Map) {
            this.list = new SimpleKeyValueList();
            this.list.withMap((Map)collection);
        }
        this.currentEntry = new SimpleEntity();
    }

    @Override
    public boolean hasNext() {
        return this.cursor < this.list.size() - 1;
    }

    public void reset() {
        this.cursor = -1;
    }

    @Override
    public Map.Entry<K, V> next() {
        if (!this.hasNext()) {
            return null;
        }
        ++this.cursor;
        this.currentEntry.setKey(this.list.getKeyByIndex(this.cursor));
        this.currentEntry.setValue(this.list.getValueByIndex(this.cursor));
        return this.currentEntry;
    }

    @Override
    public boolean hasPrevious() {
        return this.cursor > 0;
    }

    @Override
    public Map.Entry<K, V> previous() {
        --this.cursor;
        this.currentEntry.setKey(this.list.getKeyByIndex(this.cursor));
        this.currentEntry.setValue(this.list.getValueByIndex(this.cursor));
        return this.currentEntry;
    }

    @Override
    public int nextIndex() {
        return this.cursor + 1;
    }

    @Override
    public int previousIndex() {
        return this.cursor - 1;
    }

    @Override
    public void remove() {
        this.list.removePos(this.cursor);
    }

    @Override
    public void set(Map.Entry<K, V> e) {
        this.cursor = this.list.getPositionKey(e.getKey(), false);
        this.currentEntry.setKey(e.getKey());
        this.currentEntry.setValue(e.getValue());
    }

    @Override
    public void add(Map.Entry<K, V> e) {
        this.list.add(e.getKey(), e.getValue());
    }
}

