/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.graph;

import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.MapEntity;
import de.uniks.networkparser.buffer.Tokener;
import de.uniks.networkparser.converter.GraphConverter;
import de.uniks.networkparser.graph.Association;
import de.uniks.networkparser.graph.Attribute;
import de.uniks.networkparser.graph.Cardinality;
import de.uniks.networkparser.graph.Clazz;
import de.uniks.networkparser.graph.DataType;
import de.uniks.networkparser.graph.GraphDiff;
import de.uniks.networkparser.graph.GraphEntity;
import de.uniks.networkparser.graph.GraphList;
import de.uniks.networkparser.graph.GraphMember;
import de.uniks.networkparser.graph.GraphPatternChange;
import de.uniks.networkparser.graph.GraphPatternMatch;
import de.uniks.networkparser.interfaces.Condition;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.json.JsonArray;
import de.uniks.networkparser.list.SimpleKeyValueList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class GraphTokener
extends Tokener {
    public static final String CLASS = "classdiagram";
    public static final byte FLAG_CLASS = 1;
    public static final byte FLAG_CARDINALITY = 2;
    public static final byte FLAG_SHOWLINE = 4;
    public static final byte FLAG_ORDERD = 8;
    public static final byte FLAG_UNORDERD = 0;
    public static final String OBJECT = "objectdiagram";

    private String getType(MapEntity map) {
        if (map.isTokenerFlag((byte)1)) {
            return CLASS;
        }
        return OBJECT;
    }

    @Override
    public GraphList encode(Object object, MapEntity map) {
        GraphList newElement = new GraphList();
        newElement.withTyp(this.getType(map));
        Clazz main = this.parse(object, map, newElement, 0);
        GraphDiff diff = newElement.getDiff();
        if (diff != null) {
            diff.withMain(main);
        }
        return newElement;
    }

    private Clazz parse(Object object, MapEntity map, GraphList list, int deep) {
        if (object == null) {
            return null;
        }
        String mainKey = this.getId(object);
        GraphMember element = list.getByObject(mainKey, true);
        if (element != null && element instanceof Clazz) {
            return (Clazz)element;
        }
        SendableEntityCreator prototyp = this.getCreatorClass(object);
        String className = object.getClass().getName();
        className = className.substring(className.lastIndexOf(46) + 1);
        Clazz newElement = new Clazz();
        newElement.withId(mainKey);
        newElement.with(className);
        list.with(newElement);
        if (prototyp != null) {
            for (String property : prototyp.getProperties()) {
                Object value = prototyp.getValue(object, property);
                if (value == null) continue;
                if (value instanceof Collection) {
                    for (Object containee : (Collection)value) {
                        this.parsePropertyValue(object, map, list, deep, newElement, property, containee, Cardinality.MANY);
                    }
                    continue;
                }
                this.parsePropertyValue(object, map, list, deep, newElement, property, value, Cardinality.ONE);
            }
        }
        return newElement;
    }

    private void parsePropertyValue(Object entity, MapEntity map, GraphList list, int deep, Clazz element, String property, Object item, Cardinality cardinality) {
        if (item == null) {
            return;
        }
        map.add();
        if (!map.isPropertyRegard(entity, this.getMap(), property, item) || !map.isConvertable(entity, this.getMap(), property, item)) {
            map.minus();
            return;
        }
        SendableEntityCreator valueCreater = this.getCreatorClass(item);
        if (valueCreater != null) {
            Clazz subId = this.parse(item, map, list, deep + 1);
            Association edge = new Association(element);
            element.with(edge);
            Association target = new Association(subId).with(cardinality).with(property);
            subId.with(target);
            list.with(edge.with(target));
        } else {
            Attribute attribute = element.createAttribute(property, DataType.create(item.getClass()));
            attribute.withValue("" + item);
        }
        map.minus();
    }

    public void highlightModel(JsonArray clazzDiagram, GraphList objectDiagram) {
        GraphList list = new GraphConverter().convertGraphList(CLASS, clazzDiagram);
        this.highlightModel(list, objectDiagram);
    }

    public GraphList highlightModel(GraphList clazzDiagram, GraphList objectDiagram) {
        Clazz node;
        HashMap<String, GraphMember> edges = new HashMap<String, GraphMember>();
        HashMap<String, Clazz> clazzes = new HashMap<String, Clazz>();
        for (GraphMember item : clazzDiagram.getChildren()) {
            clazzes.put(((GraphEntity)item).getName(false), (Clazz)item);
        }
        for (GraphMember item : clazzDiagram.getAssociations(new Condition[0])) {
            node = ((Association)item).getClazz();
            edges.put(node.getName(false) + ":" + ((Association)item).getName(), item);
        }
        for (GraphMember item : objectDiagram.getChildren()) {
            Clazz graphClazz = (Clazz)clazzes.get(((GraphEntity)item).getName(false));
            if (graphClazz == null) continue;
            GraphDiff diff = graphClazz.getDiff();
            diff.addCounter();
        }
        for (GraphMember item : objectDiagram.getAssociations(new Condition[0])) {
            node = ((Association)item).getClazz();
            String signature = node.getName(false) + ":" + ((Association)item).getName();
            Association graphEdge = (Association)edges.get(signature);
            if (graphEdge == null) continue;
            GraphDiff diff = graphEdge.getDiff();
            diff.addCounter();
        }
        return clazzDiagram;
    }

    public GraphPatternMatch diffModel(Object master, Object slave, MapEntity map) {
        if (!map.add(master)) {
            return null;
        }
        GraphPatternMatch result = new GraphPatternMatch();
        if (master == null) {
            if (slave == null) {
                return result;
            }
            result.with(GraphPatternChange.createCreate(slave));
            return result;
        }
        if (master.equals(slave)) {
            return result;
        }
        if (slave == null) {
            result.with(GraphPatternChange.createDelete(master));
            return result;
        }
        SendableEntityCreator masterCreator = this.map.getCreatorClass(master);
        SendableEntityCreator slaveCreator = this.map.getCreatorClass(slave);
        if (masterCreator == null || slaveCreator == null) {
            result.with(GraphPatternChange.createChange(master, slave));
            return result;
        }
        String[] properties = masterCreator.getProperties();
        SimpleKeyValueList<String, Collection> assocMany = new SimpleKeyValueList<String, Collection>();
        SimpleKeyValueList<String, Object> attributes = new SimpleKeyValueList<String, Object>();
        for (String property : properties) {
            Object masterValue = masterCreator.getValue(master, property);
            if (masterValue instanceof Collection) {
                assocMany.add(property, (Collection)masterValue);
                continue;
            }
            attributes.add(property, masterValue);
        }
        SimpleKeyValueList matchMap = new SimpleKeyValueList();
        if (map.isFlag((byte)8)) {
            for (Map.Entry item : attributes) {
                Object value = item.getValue();
                Object slaveValue = slaveCreator.getValue(slave, (String)item.getKey());
                if (value == null) {
                    if (slaveValue == null) continue;
                    if (slaveValue instanceof Collection) {
                        Collection child = (Collection)slaveValue;
                        GraphPatternMatch match = GraphPatternMatch.create((String)item.getKey(), slaveValue);
                        Iterator childIterator = child.iterator();
                        while (childIterator.hasNext()) {
                            match.with(GraphPatternChange.createCreate(childIterator.next()));
                        }
                        if (match.size() <= 0) continue;
                        result.with(match);
                        continue;
                    }
                    result.with(GraphPatternChange.createCreate((String)item.getKey(), slaveValue));
                    continue;
                }
                if (value instanceof String || value instanceof Date || value instanceof Number) {
                    if (value.equals(slaveValue)) continue;
                    result.with(GraphPatternChange.createChange((String)item.getKey(), value, slaveValue));
                    continue;
                }
                matchMap.add(value, slaveValue);
                if (this.map.getCreatorClass(value) != null) {
                    result.with(this.diffModel(value, slaveValue, map));
                    continue;
                }
                if (value.equals(slaveValue)) continue;
                result.with(GraphPatternChange.createChange((String)item.getKey(), value, slaveValue));
            }
            for (Map.Entry item : assocMany) {
                Collection masterCollection = (Collection)item.getValue();
                GraphPatternMatch match = GraphPatternMatch.create((String)item.getKey(), masterCollection);
                Object slaveValue = slaveCreator.getValue(slave, (String)item.getKey());
                if (slaveValue == null || !(slaveValue instanceof Collection)) {
                    if (masterCollection.size() <= 0) continue;
                    Iterator childIterator = masterCollection.iterator();
                    while (childIterator.hasNext()) {
                        match.with(GraphPatternChange.createDelete(childIterator.next()));
                    }
                    result.with(match);
                    continue;
                }
                Iterator masterIterator = masterCollection.iterator();
                Iterator slaveIterator = ((Collection)slaveValue).iterator();
                while (masterIterator.hasNext()) {
                    Object masterChild = masterIterator.next();
                    if (slaveIterator.hasNext()) {
                        Object slaveChild = slaveIterator.next();
                        match.with(this.diffModel(masterChild, slaveChild, map));
                        continue;
                    }
                    match.with(GraphPatternChange.createDelete(masterChild));
                }
                while (slaveIterator.hasNext()) {
                    match.with(GraphPatternChange.createCreate(slaveIterator.next()));
                }
                if (match.size() <= 0) continue;
                result.with(match);
            }
        } else {
            for (String property : properties) {
                Object masterValue = masterCreator.getValue(master, property);
                Object object = slaveCreator.getValue(slave, property);
            }
        }
        return result;
    }

    @Override
    public GraphTokener withMap(IdMap map) {
        super.withMap(map);
        return this;
    }
}

