/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.converter;

import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.graph.Association;
import de.uniks.networkparser.graph.AssociationTypes;
import de.uniks.networkparser.graph.Attribute;
import de.uniks.networkparser.graph.Cardinality;
import de.uniks.networkparser.graph.Clazz;
import de.uniks.networkparser.graph.DataType;
import de.uniks.networkparser.graph.GraphDiff;
import de.uniks.networkparser.graph.GraphEntity;
import de.uniks.networkparser.graph.GraphImage;
import de.uniks.networkparser.graph.GraphLabel;
import de.uniks.networkparser.graph.GraphList;
import de.uniks.networkparser.graph.GraphMember;
import de.uniks.networkparser.graph.GraphPattern;
import de.uniks.networkparser.graph.GraphSimpleSet;
import de.uniks.networkparser.graph.GraphUtil;
import de.uniks.networkparser.graph.Method;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.Condition;
import de.uniks.networkparser.interfaces.Converter;
import de.uniks.networkparser.json.JsonArray;
import de.uniks.networkparser.json.JsonObject;
import de.uniks.networkparser.list.SimpleSet;
import java.util.ArrayList;
import java.util.Collection;

public class GraphConverter
implements Converter {
    public static final String TYP = "typ";
    public static final String ID = "id";
    public static final String NODE = "node";
    public static final String CLAZZ = "clazz";
    public static final String PATTERN = "pattern";
    public static final String SUBGRAPH = "subgraph";
    public static final String ATTRIBUTES = "attributes";
    public static final String METHODS = "methods";
    public static final String NODES = "nodes";
    public static final String EDGES = "edges";
    public static final String SOURCE = "source";
    public static final String TARGET = "target";
    public static final String CARDINALITY = "cardinality";
    public static final String PROPERTY = "property";
    public static final String HEAD = "head";
    public static final String SRC = "src";
    public static final String OPTIONS = "options";
    private static final String STYLE = "style";
    private static final String INFO = "info";
    private static final String COUNTER = "counter";

    public String convert(GraphList root, boolean removePackage) {
        return this.convertToJson(root, removePackage).toString();
    }

    public JsonObject convertToJson(JsonArray list, boolean removePackage) {
        return this.convertToJson("objectdiagram", list, removePackage);
    }

    public GraphList convertGraphList(String typ, JsonArray list) {
        GraphList root = new GraphList().withTyp(typ);
        for (Object item : list) {
            if (!(item instanceof JsonObject)) continue;
            this.parseJsonObject(root, (JsonObject)item);
        }
        return root;
    }

    public JsonObject convertToJson(String typ, JsonArray list, boolean removePackage) {
        GraphList root = this.convertGraphList(typ, list);
        return this.convertToJson(root, removePackage);
    }

    public Clazz parseJsonObject(GraphList root, JsonObject node) {
        String id = node.getString(ID);
        Clazz graphNode = GraphUtil.getByObject(root, id, true);
        if (graphNode == null) {
            graphNode = new Clazz();
            graphNode.withId(id);
            root.with(graphNode);
        }
        if (node.containsKey("class")) {
            graphNode.with(node.getString("class"));
        }
        if (node.containsKey(HEAD)) {
            graphNode.with(new GraphImage().with(node.getString(HEAD)));
        }
        if (node.containsKey("prop")) {
            JsonObject props = node.getJsonObject("prop");
            for (int i = 0; i < props.size(); ++i) {
                Object value = props.getValueByIndex(i);
                if (value instanceof JsonObject) {
                    Clazz newNode = this.parseJsonObject(root, (JsonObject)value);
                    Association assoc = new Association(newNode).with(Cardinality.ONE).with((String)props.getKeyByIndex(i)).with(AssociationTypes.UNDIRECTIONAL);
                    Association assocOther = new Association(graphNode).with(AssociationTypes.EDGE);
                    assoc.with(assocOther);
                    if (!GraphUtil.addAccoc(root, assoc)) continue;
                    graphNode.with(assocOther);
                    newNode.with(assoc);
                    continue;
                }
                if (value instanceof JsonArray) {
                    JsonArray array = (JsonArray)value;
                    StringBuilder sb = new StringBuilder();
                    for (Object entity : array) {
                        if (entity instanceof JsonObject) {
                            Clazz newNode = this.parseJsonObject(root, (JsonObject)entity);
                            Association assoc = new Association(newNode).with(Cardinality.MANY).with((String)props.getKeyByIndex(i)).with(AssociationTypes.UNDIRECTIONAL);
                            Association assocOther = new Association(graphNode).with(Cardinality.ONE).with(AssociationTypes.EDGE);
                            assoc.with(assocOther);
                            if (!GraphUtil.addAccoc(root, assoc)) continue;
                            graphNode.with(assocOther);
                            newNode.with(assoc);
                            continue;
                        }
                        if (sb.length() > 0) {
                            sb.append("," + entity.toString());
                            continue;
                        }
                        sb.append(entity.toString());
                    }
                    if (sb.length() <= 0) continue;
                    Attribute attribute = GraphUtil.createAttribute().with((String)props.getKeyByIndex(i)).with(value.getClass().getName()).withValue(sb.toString());
                    graphNode.with(attribute);
                    continue;
                }
                Attribute attribute = GraphUtil.createAttribute().with((String)props.getKeyByIndex(i));
                if (value == null) continue;
                attribute.with(DataType.create(value.getClass())).withValue(value.toString());
                graphNode.with(attribute);
            }
        }
        return graphNode;
    }

    public JsonObject convertToJson(GraphList root, boolean removePackage) {
        String style;
        String typ = root.getTyp();
        JsonObject jsonRoot = new JsonObject().withValue(TYP, typ).withValue(ID, root.getName());
        if (root.getOptions() != null) {
            jsonRoot.add(OPTIONS, root.getOptions().getJson());
        }
        if ((style = root.getStyle()) != null) {
            jsonRoot.put(STYLE, root.getStyle());
        }
        jsonRoot.put(NODES, this.parseEntities(typ, root, removePackage));
        jsonRoot.withKeyValue(EDGES, this.parseEdges(typ, root.getAssociations(new Condition[0]), removePackage));
        return jsonRoot;
    }

    private Collection<?> parseEdges(String typ, SimpleSet<Association> edges, boolean shortName) {
        JsonArray result = new JsonArray();
        ArrayList<String> ids = new ArrayList<String>();
        for (Association edge : edges) {
            SimpleSet<GraphEntity> edgeNodes = GraphUtil.getNodes(edge);
            for (GraphEntity source : edgeNodes) {
                SimpleSet<GraphEntity> edgeOtherNodes = GraphUtil.getNodes(edge.getOther());
                for (GraphEntity target : edgeOtherNodes) {
                    JsonObject child = this.parseEdge(typ, source, target, edge, shortName, ids);
                    if (child == null) continue;
                    result.add(child);
                }
            }
        }
        if (result.size() < 1) {
            return null;
        }
        return result;
    }

    private JsonObject parseEdge(String typ, GraphEntity source, GraphEntity target, Association edge, boolean shortName, ArrayList<String> ids) {
        if (source instanceof Clazz && target instanceof Clazz) {
            return this.parseEdge(typ, (Clazz)source, (Clazz)target, edge, shortName, ids);
        }
        if (source instanceof GraphPattern && target instanceof GraphPattern) {
            return this.parseEdge(typ, (GraphPattern)source, (GraphPattern)target, edge, shortName, ids);
        }
        return null;
    }

    private JsonObject parseEdge(String typ, Clazz source, Clazz target, Association edge, boolean shortName, ArrayList<String> ids) {
        JsonObject child = new JsonObject().withKeyValue(TYP, (Object)edge.getType());
        if (typ.equals("objectdiagram")) {
            child.put(SOURCE, this.addInfo(edge, true).withValue(ID, source.getId() + " : " + source.getName(shortName)));
            child.put(TARGET, this.addInfo(edge.getOther(), true).withValue(ID, target.getId() + " : " + target.getName(shortName)));
            return child;
        }
        String id = new CharacterBuffer().with(source.getName(false), ":", edge.getName(), "-", target.getName(false), ":", edge.getOther().getName()).toString();
        if (!ids.contains(id)) {
            GraphDiff diff = GraphUtil.getDifference(edge);
            if (diff != null && diff.getCount() > 0) {
                child.put(COUNTER, diff.getCount());
            }
            child.put(SOURCE, this.addInfo(edge, true).withValue(ID, source.getName(shortName)));
            child.put(TARGET, this.addInfo(edge.getOther(), true).withValue(ID, target.getName(shortName)));
            ids.add(id);
            return child;
        }
        return null;
    }

    private JsonObject parseEdge(String typ, GraphPattern source, GraphPattern target, Association edge, boolean shortName, ArrayList<String> ids) {
        JsonObject child = new JsonObject().withKeyValue(TYP, (Object)edge.getType());
        child.put(SOURCE, this.addInfo(edge, false).withValue(ID, source.getId()));
        child.put(TARGET, this.addInfo(edge.getOther(), false).withValue(ID, target.getId()));
        GraphLabel info = edge.getInfo();
        if (info != null) {
            child.put(INFO, info.getName());
            child.put(STYLE, info.getStyle());
        }
        return child;
    }

    private JsonObject addInfo(Association edge, boolean cardinality) {
        if (cardinality) {
            return new JsonObject().withKeyValue(CARDINALITY, (Object)edge.getCardinality()).withValue(PROPERTY, edge.getName());
        }
        return new JsonObject().withValue(PROPERTY, edge.getName());
    }

    public JsonArray parseEntities(String typ, GraphEntity nodes, boolean shortName) {
        JsonArray result = new JsonArray();
        ArrayList<String> ids = new ArrayList<String>();
        GraphSimpleSet children = GraphUtil.getChildren(nodes);
        for (GraphMember entity : children) {
            JsonObject item = this.parseEntity(typ, entity, shortName);
            if (item == null) continue;
            if ("classdiagram".equals(typ) && item.has(ID)) {
                String key = item.getString(ID);
                if (ids.contains(key)) continue;
                ids.add(key);
            }
            result.add(item);
        }
        if (result.size() < 1) {
            return null;
        }
        return result;
    }

    public JsonObject parseEntity(String typ, GraphMember entity, boolean shortName) {
        GraphDiff diff;
        JsonArray items;
        GraphEntity element;
        if (typ == null) {
            typ = "objectdiagram";
            if (entity.getName() == null) {
                typ = "classdiagram";
            }
        }
        JsonObject item = new JsonObject();
        if (entity instanceof Clazz) {
            item.put(TYP, CLAZZ);
            element = (Clazz)entity;
            if (typ == "objectdiagram") {
                item.put(ID, element.getId() + " : " + element.getName(shortName));
            } else {
                item.put(ID, element.getName(shortName));
            }
        } else if (entity instanceof GraphPattern) {
            item.put(TYP, PATTERN);
            String bounds = ((GraphPattern)entity).getBounds();
            if (bounds != null) {
                item.put(STYLE, bounds);
            }
            item.put(ID, entity.getName());
        } else {
            if (entity instanceof GraphList) {
                return this.convertToJson((GraphList)entity, shortName);
            }
            item.put(TYP, NODE);
        }
        if (!(entity instanceof GraphEntity)) {
            return null;
        }
        element = (GraphEntity)entity;
        GraphImage nodeHeader = this.getNodeHeader(element);
        if (nodeHeader != null) {
            item.put(HEAD, new JsonObject().withKeyValue(SRC, (Object)nodeHeader));
        }
        if ((items = this.parseAttributes(typ, element, shortName)).size() > 0) {
            item.put(ATTRIBUTES, items);
        }
        if ((items = this.parseMethods(element, shortName)).size() > 0) {
            item.put(METHODS, items);
        }
        if ((diff = GraphUtil.getDifference(element)) != null && diff.getCount() > 0) {
            item.put(COUNTER, diff.getCount());
        }
        return item;
    }

    public GraphImage getNodeHeader(GraphEntity entity) {
        GraphSimpleSet children = GraphUtil.getChildren(entity);
        for (GraphMember member : children) {
            if (!(member instanceof GraphImage)) continue;
            return (GraphImage)member;
        }
        return null;
    }

    private JsonArray parseAttributes(String typ, GraphEntity list, boolean shortName) {
        JsonArray result = new JsonArray();
        String splitter = "";
        if (typ.equals("objectdiagram")) {
            splitter = "=";
        } else if (typ.equals("classdiagram")) {
            splitter = ":";
        }
        GraphSimpleSet children = GraphUtil.getChildren(list);
        for (GraphMember item : children) {
            if (!(item instanceof Attribute)) continue;
            Attribute attribute = (Attribute)item;
            result.add(attribute.getName() + splitter + attribute.getValue(typ, shortName));
        }
        return result;
    }

    private JsonArray parseMethods(GraphEntity list, boolean shortName) {
        JsonArray result = new JsonArray();
        GraphSimpleSet children = GraphUtil.getChildren(list);
        for (GraphMember item : children) {
            if (!(item instanceof Method)) continue;
            Method method = (Method)item;
            result.add(method.getName(false));
        }
        return result;
    }

    @Override
    public String encode(BaseItem entity) {
        if (entity instanceof GraphList) {
            return this.convert((GraphList)entity, false);
        }
        return null;
    }
}

