/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.bytes;

public abstract class Checksum {
    protected long value;
    protected long length;

    public Checksum() {
        this.reset();
    }

    public void reset() {
        this.value = 0L;
        this.length = 0L;
    }

    public boolean update(int data) {
        ++this.length;
        return true;
    }

    public boolean update(byte b) {
        this.update(b & 0xFF);
        return true;
    }

    public void update(byte[] bytes, int offset, int length) {
        for (int i = offset; i < length + offset; ++i) {
            this.update(bytes[i]);
        }
    }

    public void update(byte[] bytes) {
        this.update(bytes, 0, bytes.length);
    }

    public long getValue() {
        int len = this.getOrder() / 8;
        int max = 1;
        for (int i = 0; i < len; ++i) {
            max *= 256;
        }
        return this.value & (long)(--max);
    }

    public long getLength() {
        return this.length;
    }

    public byte[] getByteArray() {
        int maxlen = 4;
        byte[] test = new byte[maxlen];
        int count = 0;
        for (long value = this.getValue(); value > 0L; value >>= 8) {
            test[maxlen - 1 - count++] = (byte)(value % 256L);
        }
        if (count == 0) {
            return new byte[]{0};
        }
        byte[] result = new byte[count];
        for (int z = 0; z < count; ++z) {
            result[z] = test[maxlen - count + z];
        }
        return result;
    }

    public abstract int getOrder();
}

