package de.thksystems.util.lang;

import org.apache.commons.lang3.ClassUtils;

public final class ExceptionUtils {

	private ExceptionUtils() {
	}

	/**
	 * Returns a {@link String} of the {@link Throwable} like:
	 * 
	 * <pre>
	 * com.bar.FooException: Some problem is there
	 * -> c.d.f.w.a.net.Exception42: My message goes here
	 * -> abc.xyz.GoogleStillExistsException: null
	 * </pre>
	 */
	public static String getMessageList(Throwable t) {
		StringBuffer sb = new StringBuffer();
		Throwable throwable = t;
		int depth = 0;
		while (throwable != null) {
			if (depth++ > 0) {
				sb.append("\n").append("--> ");
			}
			sb.append(ClassUtils.getAbbreviatedName(throwable.getClass(), 25)).append(": ").append(throwable.getMessage());
			throwable = throwable.getCause();
		}
		return sb.toString();
	}

	/**
	 * Returns <code>true</code>, if the given {@link Throwable} or one of its causes {@link Class}es is assignable from the given
	 * {@link Class}.
	 */
	public static boolean isOfTypeOrHasCauseWithType(Throwable t, Class<? extends Throwable> expectedClass) {
		Throwable throwable = t;
		while (throwable != null) {
			if (expectedClass.isAssignableFrom(throwable.getClass())) {
				return true;
			}
			throwable = throwable.getCause();
		}
		return false;
	}
}
