/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.restutils;

import java.util.Collection;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

public final class RESTAssert {
    private static Response.Status DEFAULT_STATUS_CODE = Response.Status.PRECONDITION_FAILED;
    public static final String PATTERN_DATE = "\\d{4}-\\d{2}-\\d{2}";
    public static final String PATTERN_TIME = "[0-2][0-9]:[0-5][0-9]:[0-5][0-9]";
    public static final String PATTERN_DATETIME = "\\d{4}-\\d{2}-\\d{2} [0-2][0-9]:[0-5][0-9]:[0-5][0-9]";
    public static final String PATTERN_ISO = "\\d{4}-\\d{2}-\\d{2}([tT][0-2][0-9]:[0-5][0-9]:[0-5][0-9](\\.\\d{1,3})?)?([zZ]|[+-]\\d{2}:?\\d{2})?";

    public static void changeFailStatus(Response.Status _status) {
        DEFAULT_STATUS_CODE = _status;
    }

    private RESTAssert() {
    }

    public static void assertTrue(boolean condition) {
        RESTAssert.assertTrue(condition, DEFAULT_STATUS_CODE);
    }

    public static void assertTrue(boolean condition, Response.Status status) {
        RESTAssert.assertFalse(!condition, status);
    }

    public static void assertFalse(boolean condition) {
        RESTAssert.assertFalse(condition, DEFAULT_STATUS_CODE);
    }

    public static void assertFalse(boolean condition, Response.Status status) {
        if (condition) {
            RESTAssert.fail(status);
        }
    }

    public static void fail(Response.Status status) {
        throw new WebApplicationException(status);
    }

    public static void fail() {
        RESTAssert.fail(DEFAULT_STATUS_CODE);
    }

    public static void assertNotNull(Object object) {
        RESTAssert.assertNotNull(object, DEFAULT_STATUS_CODE);
    }

    public static void assertNotNull(Object object, Response.Status status) {
        RESTAssert.assertTrue(object != null, status);
    }

    public static void assertNotEmpty(String string) {
        RESTAssert.assertNotEmpty(string, DEFAULT_STATUS_CODE);
    }

    public static void assertNotEmpty(String string, Response.Status status) {
        RESTAssert.assertNotNull(string, status);
        RESTAssert.assertFalse(string.isEmpty(), status);
    }

    public static void assertNotEmpty(Collection<?> collection) {
        RESTAssert.assertNotEmpty(collection, DEFAULT_STATUS_CODE);
    }

    public static void assertNotEmpty(Collection<?> collection, Response.Status status) {
        RESTAssert.assertNotNull(collection, status);
        RESTAssert.assertFalse(collection.isEmpty(), status);
    }

    public static void assertSingleElement(Collection<?> collection) {
        RESTAssert.assertSingleElement(collection, DEFAULT_STATUS_CODE);
    }

    public static void assertSingleElement(Collection<?> collection, Response.Status status) {
        RESTAssert.assertNotNull(collection, status);
        RESTAssert.assertTrue(collection.size() == 1, status);
    }

    public static void assertEquals(Object one, Object two) {
        RESTAssert.assertEquals(one, two, DEFAULT_STATUS_CODE);
    }

    public static void assertEquals(Object one, Object two, Response.Status status) {
        if (one == null && two == null) {
            return;
        }
        RESTAssert.assertNotNull(one, status);
        RESTAssert.assertTrue(one.equals(two), status);
    }

    public static void assertInt(String string) {
        RESTAssert.assertInt(string, DEFAULT_STATUS_CODE);
    }

    public static void assertInt(String string, Response.Status status) {
        RESTAssert.assertNotEmpty(string);
        RESTAssert.assertPattern(string, "[+-]?[0-9]*", status);
    }

    public static void assertPattern(String string, String pattern) {
        RESTAssert.assertPattern(string, pattern, DEFAULT_STATUS_CODE);
    }

    public static void assertPattern(String string, String pattern, Response.Status status) {
        RESTAssert.assertNotNull(string);
        RESTAssert.assertNotNull(pattern);
        RESTAssert.assertTrue(string.matches(pattern), status);
    }
}

