/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.httputils;

import de.taimos.httputils.HTTPRequest;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.util.EntityUtils;

public final class WS {
    private WS() {
    }

    public static HTTPRequest url(String url) {
        return new HTTPRequest(url);
    }

    public static String getResponseAsString(HttpResponse response) {
        try {
            return EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] getResponseAsBytes(HttpResponse response) {
        try {
            return EntityUtils.toByteArray((HttpEntity)response.getEntity());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static int getStatus(HttpResponse response) {
        return response.getStatusLine().getStatusCode();
    }

    public static boolean isStatusOK(HttpResponse response) {
        int code = WS.getStatus(response);
        return code >= 200 && code <= 299;
    }

    public static boolean isStatusRedirect(HttpResponse response) {
        int code = WS.getStatus(response);
        return code >= 300 && code <= 399;
    }

    public static boolean isStatusClientError(HttpResponse response) {
        int code = WS.getStatus(response);
        return code >= 400 && code <= 499;
    }

    public static boolean isStatusServerError(HttpResponse response) {
        int code = WS.getStatus(response);
        return code >= 500 && code <= 599;
    }
}

