/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.postgres.embedded;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import de.softwareforge.testing.postgres.embedded.DatabaseInfo;
import de.softwareforge.testing.postgres.embedded.EmbeddedPostgres;
import de.softwareforge.testing.postgres.embedded.EmbeddedPostgresPreparer;
import de.softwareforge.testing.postgres.embedded.EmbeddedUtil;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DatabaseManager
implements AutoCloseable {
    private static final String PG_DEFAULT_ENCODING = "utf8";
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseManager.class);
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicBoolean started = new AtomicBoolean();
    private final Set<EmbeddedPostgresPreparer<DataSource>> databasePreparers;
    private final Set<EmbeddedPostgresPreparer<EmbeddedPostgres.Builder>> instancePreparers;
    private final boolean multiMode;
    private volatile InstanceProvider instanceProvider = null;
    private volatile EmbeddedPostgres pg = null;

    private DatabaseManager(Set<EmbeddedPostgresPreparer<DataSource>> databasePreparers, Set<EmbeddedPostgresPreparer<EmbeddedPostgres.Builder>> instancePreparers, boolean multiMode) {
        this.databasePreparers = (Set)Preconditions.checkNotNull(databasePreparers, (Object)"databasePreparers is null");
        this.instancePreparers = (Set)Preconditions.checkNotNull(instancePreparers, (Object)"instancePreparers is null");
        this.multiMode = multiMode;
    }

    @Nonnull
    public static Builder<DatabaseManager> multiDatabases() {
        return new DatabaseManagerBuilder(true);
    }

    @Nonnull
    public static Builder<DatabaseManager> singleDatabase() {
        return new DatabaseManagerBuilder(false);
    }

    @Nonnull
    public DatabaseManager start() throws IOException, SQLException {
        if (!this.started.getAndSet(true)) {
            DataSource dataSource;
            EmbeddedPostgres.Builder builder = EmbeddedPostgres.builder();
            for (EmbeddedPostgresPreparer<EmbeddedPostgres.Builder> instancePreparer : this.instancePreparers) {
                instancePreparer.prepare(builder);
            }
            this.pg = builder.build();
            if (this.multiMode) {
                dataSource = this.pg.createTemplateDataSource();
                this.instanceProvider = new InstanceProviderPipeline();
            } else {
                dataSource = this.pg.createDefaultDataSource();
                this.instanceProvider = this.pg::createDefaultDatabaseInfo;
            }
            for (EmbeddedPostgresPreparer<DataSource> databasePreparer : this.databasePreparers) {
                databasePreparer.prepare(dataSource);
            }
            this.instanceProvider.start();
        }
        return this;
    }

    @Override
    public void close() throws Exception {
        Preconditions.checkState((boolean)this.started.get(), (Object)"not yet started!");
        if (!this.closed.getAndSet(true)) {
            if (this.instanceProvider != null) {
                this.instanceProvider.close();
            }
            if (this.pg != null) {
                this.pg.close();
            }
        }
    }

    @Nonnull
    public DatabaseInfo getDatabaseInfo() throws SQLException {
        Preconditions.checkState((boolean)this.started.get(), (Object)"not yet started!");
        DatabaseInfo databaseInfo = this.instanceProvider.get();
        if (databaseInfo.exception().isPresent()) {
            throw databaseInfo.exception().get();
        }
        return databaseInfo;
    }

    @Nonnull
    public EmbeddedPostgres getEmbeddedPostgres() {
        Preconditions.checkState((boolean)this.started.get(), (Object)"not yet started!");
        return this.pg;
    }

    private static void createDatabase(DataSource dataSource, String databaseName) throws SQLException {
        try (Connection c = dataSource.getConnection();
             Statement stmt = c.createStatement();){
            stmt.executeUpdate(String.format("CREATE DATABASE %s OWNER %s ENCODING = '%s'", databaseName, "postgres", PG_DEFAULT_ENCODING));
        }
    }

    private static interface InstanceProvider
    extends Supplier<DatabaseInfo>,
    AutoCloseable {
        default public void start() {
        }

        @Override
        default public void close() {
        }

        @Override
        public DatabaseInfo get();
    }

    public static final class DatabaseManagerBuilder
    extends Builder<DatabaseManager> {
        public DatabaseManagerBuilder(boolean multiMode) {
            super(multiMode);
        }

        @Override
        @Nonnull
        public DatabaseManager build() {
            return new DatabaseManager((Set<EmbeddedPostgresPreparer<DataSource>>)this.databasePreparers.build(), (Set<EmbeddedPostgresPreparer<EmbeddedPostgres.Builder>>)this.instancePreparers.build(), this.multiMode);
        }
    }

    private final class InstanceProviderPipeline
    implements InstanceProvider,
    Runnable {
        private final ExecutorService executor;
        private final SynchronousQueue<DatabaseInfo> nextDatabase = new SynchronousQueue();
        private final AtomicBoolean closed = new AtomicBoolean();

        InstanceProviderPipeline() {
            this.executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("instance-creator-" + DatabaseManager.this.pg.instanceId() + "-%d").build());
        }

        @Override
        public void start() {
            this.executor.submit(this);
        }

        @Override
        public void close() {
            if (!this.closed.getAndSet(true)) {
                this.executor.shutdownNow();
            }
        }

        @Override
        public void run() {
            while (!this.closed.get()) {
                try {
                    String newDbName = EmbeddedUtil.randomLowercase(12);
                    try {
                        DatabaseManager.createDatabase(DatabaseManager.this.pg.createDefaultDataSource(), newDbName);
                        this.nextDatabase.put(DatabaseInfo.builder().dbName(newDbName).port(DatabaseManager.this.pg.getPort()).connectionProperties(DatabaseManager.this.pg.getConnectionProperties()).build());
                    }
                    catch (SQLException e) {
                        if (e.getSQLState().equals("57P01")) continue;
                        LOG.warn("Caught SQL Exception (" + e.getSQLState() + "):", (Throwable)e);
                        this.nextDatabase.put(DatabaseInfo.forException(e));
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                catch (Exception e) {
                    LOG.warn("Caught exception in instance provider loop:", (Throwable)e);
                }
            }
        }

        @Override
        public DatabaseInfo get() {
            try {
                return this.nextDatabase.take();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e);
            }
        }
    }

    public static abstract class Builder<T> {
        protected ImmutableSet.Builder<EmbeddedPostgresPreparer<DataSource>> databasePreparers = ImmutableSet.builder();
        protected ImmutableSet.Builder<EmbeddedPostgresPreparer<EmbeddedPostgres.Builder>> instancePreparers = ImmutableSet.builder();
        protected final boolean multiMode;

        protected Builder(boolean multiMode) {
            this.multiMode = multiMode;
        }

        @Nonnull
        public Builder<T> withDatabasePreparer(@Nonnull EmbeddedPostgresPreparer<DataSource> databasePreparer) {
            this.databasePreparers.add((Object)((EmbeddedPostgresPreparer)Preconditions.checkNotNull(databasePreparer, (Object)"databasePreparer is null")));
            return this;
        }

        @Nonnull
        public Builder<T> withDatabasePreparers(@Nonnull Set<EmbeddedPostgresPreparer<DataSource>> databasePreparers) {
            this.databasePreparers.addAll((Iterable)Preconditions.checkNotNull(databasePreparers, (Object)"databasePreparers is null"));
            return this;
        }

        @Nonnull
        public Builder<T> withInstancePreparer(@Nonnull EmbeddedPostgresPreparer<EmbeddedPostgres.Builder> instancePreparer) {
            this.instancePreparers.add((Object)((EmbeddedPostgresPreparer)Preconditions.checkNotNull(instancePreparer, (Object)"instancePreparer is null")));
            return this;
        }

        @Nonnull
        public Builder<T> withInstancePreparers(@Nonnull Set<EmbeddedPostgresPreparer<EmbeddedPostgres.Builder>> instancePreparers) {
            this.instancePreparers.addAll((Iterable)Preconditions.checkNotNull(instancePreparers, (Object)"instancePreparers is null"));
            return this;
        }

        @Nonnull
        public abstract T build();
    }
}

