package de.softwareforge.testing.postgres.embedded;

import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.sql.SQLException;
import java.util.Optional;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_DatabaseInfo extends DatabaseInfo {

  private final String dbName;

  private final int port;

  private final String user;

  private final ImmutableMap<String, String> connectionProperties;

  private final Optional<SQLException> exception;

  private AutoValue_DatabaseInfo(
      String dbName,
      int port,
      String user,
      ImmutableMap<String, String> connectionProperties,
      Optional<SQLException> exception) {
    this.dbName = dbName;
    this.port = port;
    this.user = user;
    this.connectionProperties = connectionProperties;
    this.exception = exception;
  }

  @Nonnull
  @Override
  public String dbName() {
    return dbName;
  }

  @Override
  public int port() {
    return port;
  }

  @Nonnull
  @Override
  public String user() {
    return user;
  }

  @Nonnull
  @Override
  public ImmutableMap<String, String> connectionProperties() {
    return connectionProperties;
  }

  @Nonnull
  @Override
  Optional<SQLException> exception() {
    return exception;
  }

  @Override
  public String toString() {
    return "DatabaseInfo{"
        + "dbName=" + dbName + ", "
        + "port=" + port + ", "
        + "user=" + user + ", "
        + "connectionProperties=" + connectionProperties + ", "
        + "exception=" + exception
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof DatabaseInfo) {
      DatabaseInfo that = (DatabaseInfo) o;
      return this.dbName.equals(that.dbName())
          && this.port == that.port()
          && this.user.equals(that.user())
          && this.connectionProperties.equals(that.connectionProperties())
          && this.exception.equals(that.exception());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= dbName.hashCode();
    h$ *= 1000003;
    h$ ^= port;
    h$ *= 1000003;
    h$ ^= user.hashCode();
    h$ *= 1000003;
    h$ ^= connectionProperties.hashCode();
    h$ *= 1000003;
    h$ ^= exception.hashCode();
    return h$;
  }

  static final class Builder extends DatabaseInfo.Builder {
    private String dbName;
    private int port;
    private String user;
    private ImmutableMap.Builder<String, String> connectionPropertiesBuilder$;
    private ImmutableMap<String, String> connectionProperties;
    private Optional<SQLException> exception = Optional.empty();
    private byte set$0;
    Builder() {
    }
    @Override
    DatabaseInfo.Builder dbName(String dbName) {
      if (dbName == null) {
        throw new NullPointerException("Null dbName");
      }
      this.dbName = dbName;
      return this;
    }
    @Override
    DatabaseInfo.Builder port(int port) {
      this.port = port;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    DatabaseInfo.Builder user(String user) {
      if (user == null) {
        throw new NullPointerException("Null user");
      }
      this.user = user;
      return this;
    }
    @Override
    DatabaseInfo.Builder connectionProperties(ImmutableMap<String, String> connectionProperties) {
      if (connectionProperties == null) {
        throw new NullPointerException("Null connectionProperties");
      }
      if (connectionPropertiesBuilder$ != null) {
        throw new IllegalStateException("Cannot set connectionProperties after calling connectionPropertiesBuilder()");
      }
      this.connectionProperties = connectionProperties;
      return this;
    }
    @Override
    ImmutableMap.Builder<String, String> connectionPropertiesBuilder() {
      if (connectionPropertiesBuilder$ == null) {
        if (connectionProperties == null) {
          connectionPropertiesBuilder$ = ImmutableMap.builder();
        } else {
          connectionPropertiesBuilder$ = ImmutableMap.builder();
          connectionPropertiesBuilder$.putAll(connectionProperties);
          connectionProperties = null;
        }
      }
      return connectionPropertiesBuilder$;
    }
    @Override
    DatabaseInfo.Builder exception(SQLException exception) {
      this.exception = Optional.of(exception);
      return this;
    }
    @Override
    DatabaseInfo build() {
      if (connectionPropertiesBuilder$ != null) {
        this.connectionProperties = connectionPropertiesBuilder$.buildOrThrow();
      } else if (this.connectionProperties == null) {
        this.connectionProperties = ImmutableMap.of();
      }
      if (set$0 != 1
          || this.dbName == null
          || this.user == null) {
        StringBuilder missing = new StringBuilder();
        if (this.dbName == null) {
          missing.append(" dbName");
        }
        if ((set$0 & 1) == 0) {
          missing.append(" port");
        }
        if (this.user == null) {
          missing.append(" user");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_DatabaseInfo(
          this.dbName,
          this.port,
          this.user,
          this.connectionProperties,
          this.exception);
    }
  }

}
