/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.maven.org.eclipse.aether.resolution;

import de.softwareforge.testing.maven.org.eclipse.aether.$RepositoryException;
import de.softwareforge.testing.maven.org.eclipse.aether.repository.$LocalArtifactResult;
import de.softwareforge.testing.maven.org.eclipse.aether.resolution.$ArtifactResult;
import de.softwareforge.testing.maven.org.eclipse.aether.transfer.;
import java.util.Collections;
import java.util.List;

public class $ArtifactResolutionException
extends $RepositoryException {
    private final transient List<$ArtifactResult> results;

    public $ArtifactResolutionException(List<$ArtifactResult> results) {
        super($ArtifactResolutionException.getMessage(results), $ArtifactResolutionException.getCause(results));
        this.results = results != null ? results : Collections.emptyList();
    }

    public $ArtifactResolutionException(List<$ArtifactResult> results, String message) {
        super(message, $ArtifactResolutionException.getCause(results));
        this.results = results != null ? results : Collections.emptyList();
    }

    public $ArtifactResolutionException(List<$ArtifactResult> results, String message, Throwable cause) {
        super(message, cause);
        this.results = results != null ? results : Collections.emptyList();
    }

    public List<$ArtifactResult> getResults() {
        return this.results;
    }

    public $ArtifactResult getResult() {
        return this.results != null && !this.results.isEmpty() ? this.results.get(0) : null;
    }

    private static String getMessage(List<? extends $ArtifactResult> results) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append("The following artifacts could not be resolved: ");
        String sep = "";
        for ($ArtifactResult $ArtifactResult : results) {
            if ($ArtifactResult.isResolved()) continue;
            buffer.append(sep);
            buffer.append($ArtifactResult.getRequest().getArtifact());
            $LocalArtifactResult localResult = $ArtifactResult.getLocalArtifactResult();
            if (localResult != null) {
                buffer.append(" (");
                if (localResult.getFile() != null) {
                    buffer.append("present");
                    if (!localResult.isAvailable()) {
                        buffer.append(", but unavailable");
                    }
                } else {
                    buffer.append("absent");
                }
                buffer.append(")");
            }
            sep = ", ";
        }
        Throwable cause = $ArtifactResolutionException.getCause(results);
        if (cause != null) {
            buffer.append(": ").append(cause.getMessage());
        }
        return buffer.toString();
    }

    private static Throwable getCause(List<? extends $ArtifactResult> results) {
        for ($ArtifactResult $ArtifactResult : results) {
            if ($ArtifactResult.isResolved()) continue;
            Throwable notFound = null;
            Throwable offline = null;
            for (Throwable throwable : $ArtifactResult.getExceptions()) {
                if (throwable instanceof .ArtifactNotFoundException) {
                    if (notFound == null || notFound instanceof .ArtifactFilteredOutException) {
                        notFound = throwable;
                    }
                    if (offline != null || !(throwable.getCause() instanceof .RepositoryOfflineException)) continue;
                    offline = throwable;
                    continue;
                }
                return throwable;
            }
            if (offline != null) {
                return offline;
            }
            if (notFound == null) continue;
            return notFound;
        }
        return null;
    }
}

