/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.maven.org.eclipse.aether.internal.impl;

import de.softwareforge.testing.maven.javax.inject.;
import de.softwareforge.testing.maven.org.eclipse.aether.$RepositorySystemSession;
import de.softwareforge.testing.maven.org.eclipse.aether.impl.$RemoteRepositoryFilterManager;
import de.softwareforge.testing.maven.org.eclipse.aether.impl.$RepositoryConnectorProvider;
import de.softwareforge.testing.maven.org.eclipse.aether.internal.impl.$PrioritizedComponent;
import de.softwareforge.testing.maven.org.eclipse.aether.internal.impl.$PrioritizedComponents;
import de.softwareforge.testing.maven.org.eclipse.aether.internal.impl.$Utils;
import de.softwareforge.testing.maven.org.eclipse.aether.internal.impl.filter.$FilteringRepositoryConnector;
import de.softwareforge.testing.maven.org.eclipse.aether.repository.$Authentication;
import de.softwareforge.testing.maven.org.eclipse.aether.repository.$Proxy;
import de.softwareforge.testing.maven.org.eclipse.aether.repository.$RemoteRepository;
import de.softwareforge.testing.maven.org.eclipse.aether.spi.connector.$RepositoryConnector;
import de.softwareforge.testing.maven.org.eclipse.aether.spi.connector.$RepositoryConnectorFactory;
import de.softwareforge.testing.maven.org.eclipse.aether.spi.connector.filter.$RemoteRepositoryFilter;
import de.softwareforge.testing.maven.org.eclipse.aether.spi.locator.$Service;
import de.softwareforge.testing.maven.org.eclipse.aether.spi.locator.$ServiceLocator;
import de.softwareforge.testing.maven.org.eclipse.aether.transfer.$NoRepositoryConnectorException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@.Singleton
@.Named
public class $DefaultRepositoryConnectorProvider
implements $RepositoryConnectorProvider,
$Service {
    private static final Logger LOGGER = LoggerFactory.getLogger($DefaultRepositoryConnectorProvider.class);
    private Collection<$RepositoryConnectorFactory> connectorFactories = new ArrayList<$RepositoryConnectorFactory>();
    private $RemoteRepositoryFilterManager remoteRepositoryFilterManager;

    @Deprecated
    public $DefaultRepositoryConnectorProvider() {
    }

    @.Inject
    public $DefaultRepositoryConnectorProvider(Set<$RepositoryConnectorFactory> connectorFactories, $RemoteRepositoryFilterManager remoteRepositoryFilterManager) {
        this.setRepositoryConnectorFactories(connectorFactories);
        this.setRemoteRepositoryFilterManager(remoteRepositoryFilterManager);
    }

    @Override
    public void initService($ServiceLocator locator) {
        this.setRepositoryConnectorFactories(locator.getServices($RepositoryConnectorFactory.class));
        this.setRemoteRepositoryFilterManager(locator.getService($RemoteRepositoryFilterManager.class));
    }

    public $DefaultRepositoryConnectorProvider addRepositoryConnectorFactory($RepositoryConnectorFactory factory) {
        this.connectorFactories.add(Objects.requireNonNull(factory, "repository connector factory cannot be null"));
        return this;
    }

    public $DefaultRepositoryConnectorProvider setRepositoryConnectorFactories(Collection<$RepositoryConnectorFactory> factories) {
        this.connectorFactories = factories == null ? new ArrayList<$RepositoryConnectorFactory>() : factories;
        return this;
    }

    public $DefaultRepositoryConnectorProvider setRemoteRepositoryFilterManager($RemoteRepositoryFilterManager remoteRepositoryFilterManager) {
        this.remoteRepositoryFilterManager = Objects.requireNonNull(remoteRepositoryFilterManager);
        return this;
    }

    @Override
    public $RepositoryConnector newRepositoryConnector($RepositorySystemSession session, $RemoteRepository repository) throws $NoRepositoryConnectorException {
        Objects.requireNonNull(repository, "remote repository cannot be null");
        if (repository.isBlocked()) {
            if (repository.getMirroredRepositories().isEmpty()) {
                throw new $NoRepositoryConnectorException(repository, "Blocked repository: " + repository);
            }
            throw new $NoRepositoryConnectorException(repository, "Blocked mirror for repositories: " + repository.getMirroredRepositories());
        }
        $RemoteRepositoryFilter filter = this.remoteRepositoryFilterManager.getRemoteRepositoryFilter(session);
        $PrioritizedComponents<$RepositoryConnectorFactory> factories = new $PrioritizedComponents<$RepositoryConnectorFactory>(session);
        for ($RepositoryConnectorFactory $RepositoryConnectorFactory : this.connectorFactories) {
            factories.add($RepositoryConnectorFactory, $RepositoryConnectorFactory.getPriority());
        }
        ArrayList<$NoRepositoryConnectorException> errors = new ArrayList<$NoRepositoryConnectorException>();
        for ($PrioritizedComponent $PrioritizedComponent : factories.getEnabled()) {
            try {
                $RepositoryConnector connector = (($RepositoryConnectorFactory)$PrioritizedComponent.getComponent()).newInstance(session, repository);
                if (LOGGER.isDebugEnabled()) {
                    $Proxy proxy;
                    StringBuilder buffer = new StringBuilder(256);
                    buffer.append("Using connector ").append(connector.getClass().getSimpleName());
                    $Utils.appendClassLoader(buffer, connector);
                    buffer.append(" with priority ").append($PrioritizedComponent.getPriority());
                    buffer.append(" for ").append(repository.getUrl());
                    $Authentication auth = repository.getAuthentication();
                    if (auth != null) {
                        buffer.append(" with ").append(auth);
                    }
                    if ((proxy = repository.getProxy()) != null) {
                        buffer.append(" via ").append(proxy.getHost()).append(':').append(proxy.getPort());
                        auth = proxy.getAuthentication();
                        if (auth != null) {
                            buffer.append(" with ").append(auth);
                        }
                    }
                    LOGGER.debug(buffer.toString());
                }
                if (filter != null) {
                    return new $FilteringRepositoryConnector(repository, connector, filter);
                }
                return connector;
            }
            catch ($NoRepositoryConnectorException e) {
                errors.add(e);
            }
        }
        if (LOGGER.isDebugEnabled() && errors.size() > 1) {
            for (Exception exception : errors) {
                LOGGER.debug("Could not obtain connector factory for {}", (Object)repository, (Object)exception);
            }
        }
        StringBuilder stringBuilder = new StringBuilder(256);
        if (factories.isEmpty()) {
            stringBuilder.append("No connector factories available");
        } else {
            stringBuilder.append("Cannot access ").append(repository.getUrl());
            stringBuilder.append(" with type ").append(repository.getContentType());
            stringBuilder.append(" using the available connector factories: ");
            factories.list(stringBuilder);
        }
        throw new $NoRepositoryConnectorException(repository, stringBuilder.toString(), errors.size() == 1 ? (Throwable)errors.get(0) : null);
    }
}

