/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Version
implements Comparable<Version>,
Serializable {
    private static final long serialVersionUID = -7080189911455871050L;
    public static Version COMPLIANCE = Version.create(2, 0, 0);
    private static final Pattern PRE_RELEASE = Pattern.compile("(?:(?:[0-9]+[a-zA-Z-][\\w-]*)|(?:[a-zA-Z][\\w-]*)|(?:[1-9]\\d*)|0)(?:\\.(?:(?:[0-9]+[a-zA-Z-][\\w-]*)|(?:[a-zA-Z][\\w-]*)|(?:[1-9]\\d*)|0))*");
    private static final Pattern BUILD_MD = Pattern.compile("[\\w-]+(\\.[\\w-]+)*");
    private static final Pattern VERSION_PATTERN = Pattern.compile("(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:(?:[0-9]+[a-zA-Z-][\\w-]*)|(?:[a-zA-Z][\\w-]*)|(?:[1-9]\\d*)|0)(?:\\.(?:(?:[0-9]+[a-zA-Z-][\\w-]*)|(?:[a-zA-Z][\\w-]*)|(?:[1-9]\\d*)|0))*))?(?:\\+([\\w-]+(\\.[\\w-]+)*))?");
    private static final int MAJOR_GROUP = 1;
    private static final int MINOR_GROUP = 2;
    private static final int PATCH_GROUP = 3;
    private static final int PRE_RELEASE_GROUP = 4;
    private static final int BUILD_MD_GROUP = 5;
    public static final Comparator<Version> NATURAL_ORDER = new Comparator<Version>(){

        @Override
        public int compare(Version o1, Version o2) {
            return Version.compare(o1, o2);
        }
    };
    public static Comparator<Version> WITH_BUILD_META_DATA_ORDER = new Comparator<Version>(){

        @Override
        public int compare(Version o1, Version o2) {
            return Version.compareWithBuildMetaData(o1, o2);
        }
    };
    private final int major;
    private final int minor;
    private final int patch;
    private final String preRelease;
    private final String buildMetaData;

    public static int compare(Version v1, Version v2) {
        return Version.compare(v1, v2, false);
    }

    public static int compareWithBuildMetaData(Version v1, Version v2) {
        return Version.compare(v1, v2, true);
    }

    private static int compare(Version v1, Version v2, boolean withBuildMetaData) {
        int mp;
        int mm;
        if (v1 == null) {
            throw new NullPointerException("v1 is null");
        }
        if (v2 == null) {
            throw new NullPointerException("v2 is null");
        }
        if (v1 == v2) {
            return 0;
        }
        int mc = Integer.compare(v1.major, v2.major);
        int result = mc == 0 ? ((mm = Integer.compare(v1.minor, v2.minor)) == 0 ? ((mp = Integer.compare(v1.patch, v2.patch)) == 0 ? (v1.isPreRelease() && v2.isPreRelease() ? Version.compareIdentifiers(v1.getPreReleaseParts(), v2.getPreReleaseParts()) : (v1.isPreRelease() ? -1 : (v2.isPreRelease() ? 1 : 0))) : mp) : mm) : mc;
        if (withBuildMetaData && result == 0) {
            if (v1.hasBuildMetaData() && v2.hasBuildMetaData()) {
                return Version.compareIdentifiers(v1.getBuildMetaDataParts(), v2.getBuildMetaDataParts());
            }
            if (v1.hasBuildMetaData()) {
                return -1;
            }
            if (v2.hasBuildMetaData()) {
                return 1;
            }
        }
        return result;
    }

    private static int compareIdentifiers(String[] parts1, String[] parts2) {
        int min = Math.min(parts1.length, parts2.length);
        for (int i = 0; i < min; ++i) {
            int r = Version.comparePreReleaseParts(parts1[i], parts2[i]);
            if (r == 0) continue;
            return r;
        }
        return Integer.compare(parts1.length, parts2.length);
    }

    private static int comparePreReleaseParts(String p1, String p2) {
        int num1 = Version.isNumeric(p1);
        int num2 = Version.isNumeric(p2);
        if (num1 < 0 && num2 < 0) {
            return p1.compareTo(p2);
        }
        if (num1 >= 0 && num2 >= 0) {
            return Integer.compare(num1, num2);
        }
        if (num1 >= 0) {
            return -1;
        }
        if (num2 >= 0) {
            return 1;
        }
        throw new IllegalStateException();
    }

    private static int isNumeric(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static final Version create(int major, int minor, int patch, String preRelease, String buildMetaData) {
        Version.checkParams(major, minor, patch);
        if (preRelease == null) {
            throw new IllegalArgumentException("preRelease is null");
        }
        if (buildMetaData == null) {
            throw new IllegalArgumentException("buildMetaData is null");
        }
        if (!preRelease.isEmpty() && !PRE_RELEASE.matcher(preRelease).matches()) {
            throw new VersionFormatException(preRelease);
        }
        if (!buildMetaData.isEmpty() && !BUILD_MD.matcher(buildMetaData).matches()) {
            throw new VersionFormatException(buildMetaData);
        }
        return new Version(major, minor, patch, preRelease, buildMetaData);
    }

    public static final Version create(int major, int minor, int patch, String preRelease) {
        Version.checkParams(major, minor, patch);
        if (preRelease == null) {
            throw new IllegalArgumentException("preRelease is null");
        }
        if (!PRE_RELEASE.matcher(preRelease).matches()) {
            throw new VersionFormatException(preRelease);
        }
        return new Version(major, minor, patch, preRelease, "");
    }

    public static final Version create(int major, int minor, int patch) {
        Version.checkParams(major, minor, patch);
        return new Version(major, minor, patch, "", "");
    }

    private static void checkParams(int major, int minor, int patch) {
        if (major < 0) {
            throw new IllegalArgumentException("major < 0");
        }
        if (minor < 0) {
            throw new IllegalArgumentException("minor < 0");
        }
        if (patch < 0) {
            throw new IllegalArgumentException("patch < 0");
        }
        if (major == 0 && minor == 0 && patch == 0) {
            throw new IllegalArgumentException("all parts are 0");
        }
    }

    public static final Version parseVersion(String versionString) {
        if (versionString == null) {
            throw new IllegalArgumentException("versionString is null");
        }
        Matcher m = VERSION_PATTERN.matcher(versionString);
        if (!m.matches()) {
            throw new VersionFormatException(versionString);
        }
        int major = Integer.parseInt(m.group(1));
        int minor = Integer.parseInt(m.group(2));
        int patch = Integer.parseInt(m.group(3));
        Version.checkParams(major, minor, patch);
        String preRelease = m.group(4) != null ? m.group(4) : "";
        String buildMD = m.group(5) != null ? m.group(5) : "";
        return new Version(major, minor, patch, preRelease, buildMD);
    }

    private Version(int major, int minor, int patch, String preRelease, String buildMd) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.preRelease = preRelease;
        this.buildMetaData = buildMd;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public String[] getPreReleaseParts() {
        return this.preRelease.split("\\.");
    }

    public String getPreRelease() {
        return this.preRelease;
    }

    public String getBuildMetaData() {
        return this.buildMetaData;
    }

    public String[] getBuildMetaDataParts() {
        return this.buildMetaData.split("\\.");
    }

    public boolean isInitialDevelopment() {
        return this.major == 0;
    }

    public boolean isPreRelease() {
        return !this.preRelease.isEmpty();
    }

    public boolean hasBuildMetaData() {
        return !this.buildMetaData.isEmpty();
    }

    public String toString() {
        StringBuilder b = new StringBuilder(this.preRelease.length() + this.buildMetaData.length() + 24);
        b.append(this.major).append(".").append(this.minor).append(".").append(this.patch);
        if (!this.preRelease.isEmpty()) {
            b.append("-").append(this.preRelease);
        }
        if (!this.buildMetaData.isEmpty()) {
            b.append("+").append(this.buildMetaData);
        }
        return b.toString();
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch, this.preRelease);
    }

    public boolean equals(Object obj) {
        return this.equals(obj, false);
    }

    public boolean equalsIncludeBuildMetaData(Object obj) {
        return this.equals(obj, true);
    }

    private boolean equals(Object obj, boolean includeBuildMd) {
        return obj == this || obj != null && obj instanceof Version && Version.compare(this, (Version)obj, includeBuildMd) == 0;
    }

    @Override
    public int compareTo(Version other) {
        return Version.compare(this, other);
    }

    public int compareToWithBuildMetaData(Version other) {
        return Version.compareWithBuildMetaData(this, other);
    }

    public static class VersionFormatException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public VersionFormatException(String message) {
            super(message);
        }
    }
}

