/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.logbackgelf;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.util.LevelToSyslogSeverity;
import ch.qos.logback.core.encoder.EncoderBase;
import de.siegmar.logbackgelf.GelfMessage;
import de.siegmar.logbackgelf.InetUtil;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.slf4j.Marker;

public class GelfEncoder
extends EncoderBase<ILoggingEvent> {
    private static final Pattern VALID_ADDITIONAL_FIELD_PATTERN = Pattern.compile("^[\\w.-]*$");
    private static final double MSEC_DIVIDER = 1000.0;
    private static final String DEFAULT_SHORT_PATTERN = "%m%nopex";
    private static final String DEFAULT_FULL_PATTERN = "%m%n";
    private String originHost;
    private boolean includeRawMessage;
    private boolean includeMarker = true;
    private boolean includeMdcData = true;
    private boolean includeCallerData;
    private boolean includeRootCauseData;
    private boolean includeLevelName;
    private String levelNameKey = "level_name";
    private String loggerNameKey = "logger_name";
    private String threadNameKey = "thread_name";
    private boolean appendNewline;
    private PatternLayout shortPatternLayout;
    private PatternLayout fullPatternLayout;
    private boolean numbersAsString = true;
    private Map<String, Object> staticFields = new HashMap<String, Object>();

    public String getOriginHost() {
        return this.originHost;
    }

    public void setOriginHost(String originHost) {
        this.originHost = originHost;
    }

    public boolean isIncludeRawMessage() {
        return this.includeRawMessage;
    }

    public void setIncludeRawMessage(boolean includeRawMessage) {
        this.includeRawMessage = includeRawMessage;
    }

    public boolean isIncludeMarker() {
        return this.includeMarker;
    }

    public void setIncludeMarker(boolean includeMarker) {
        this.includeMarker = includeMarker;
    }

    public boolean isIncludeMdcData() {
        return this.includeMdcData;
    }

    public void setIncludeMdcData(boolean includeMdcData) {
        this.includeMdcData = includeMdcData;
    }

    public boolean isIncludeCallerData() {
        return this.includeCallerData;
    }

    public void setIncludeCallerData(boolean includeCallerData) {
        this.includeCallerData = includeCallerData;
    }

    public boolean isIncludeRootCauseData() {
        return this.includeRootCauseData;
    }

    public void setIncludeRootCauseData(boolean includeRootCauseData) {
        this.includeRootCauseData = includeRootCauseData;
    }

    public boolean isIncludeLevelName() {
        return this.includeLevelName;
    }

    public void setIncludeLevelName(boolean includeLevelName) {
        this.includeLevelName = includeLevelName;
    }

    public String getLevelNameKey() {
        return this.levelNameKey;
    }

    public void setLevelNameKey(String levelNameKey) {
        this.levelNameKey = levelNameKey;
    }

    public String getLoggerNameKey() {
        return this.loggerNameKey;
    }

    public void setLoggerNameKey(String loggerNameKey) {
        this.loggerNameKey = loggerNameKey;
    }

    public String getThreadNameKey() {
        return this.threadNameKey;
    }

    public void setThreadNameKey(String threadNameKey) {
        this.threadNameKey = threadNameKey;
    }

    public boolean isAppendNewline() {
        return this.appendNewline;
    }

    public void setAppendNewline(boolean appendNewline) {
        this.appendNewline = appendNewline;
    }

    public boolean isNumbersAsString() {
        return this.numbersAsString;
    }

    public void setNumbersAsString(boolean numbersAsString) {
        this.numbersAsString = numbersAsString;
    }

    public PatternLayout getShortPatternLayout() {
        return this.shortPatternLayout;
    }

    public void setShortPatternLayout(PatternLayout shortPatternLayout) {
        this.shortPatternLayout = shortPatternLayout;
    }

    public PatternLayout getFullPatternLayout() {
        return this.fullPatternLayout;
    }

    public void setFullPatternLayout(PatternLayout fullPatternLayout) {
        this.fullPatternLayout = fullPatternLayout;
    }

    public Map<String, Object> getStaticFields() {
        return this.staticFields;
    }

    public void setStaticFields(Map<String, Object> staticFields) {
        this.staticFields = Objects.requireNonNull(staticFields);
    }

    public void addStaticField(String staticField) {
        String[] split = staticField.split(":", 2);
        if (split.length == 2) {
            this.addField(this.staticFields, split[0].trim(), split[1].trim());
        } else {
            this.addWarn("staticField must be in format key:value - rejecting '" + staticField + "'");
        }
    }

    private void addField(Map<String, Object> dst, String key, String value) {
        if (key.isEmpty()) {
            this.addWarn("staticField key must not be empty");
        } else if ("id".equalsIgnoreCase(key)) {
            this.addWarn("staticField key name 'id' is prohibited");
        } else if (dst.containsKey(key)) {
            this.addWarn("additional field with key '" + key + "' is already set");
        } else if (!VALID_ADDITIONAL_FIELD_PATTERN.matcher(key).matches()) {
            this.addWarn("staticField key '" + key + "' is illegal. Keys must apply to regex ^[\\w.-]*$");
        } else if (value != null) {
            dst.put(key, this.processValue(value));
        }
    }

    private Object processValue(String value) {
        if (!this.numbersAsString) {
            try {
                return Double.valueOf(value);
            }
            catch (NumberFormatException e) {
                return value;
            }
        }
        return value;
    }

    public void start() {
        if (this.originHost == null || this.originHost.trim().isEmpty()) {
            this.originHost = this.buildHostname();
        }
        if (this.shortPatternLayout == null) {
            this.shortPatternLayout = this.buildPattern(DEFAULT_SHORT_PATTERN);
        }
        if (this.fullPatternLayout == null) {
            this.fullPatternLayout = this.buildPattern(DEFAULT_FULL_PATTERN);
        }
        super.start();
    }

    private String buildHostname() {
        try {
            return InetUtil.getLocalHostName();
        }
        catch (UnknownHostException e) {
            this.addWarn("Could not determine local hostname", e);
            return "unknown";
        }
    }

    private PatternLayout buildPattern(String pattern) {
        PatternLayout patternLayout = new PatternLayout();
        patternLayout.setContext(this.getContext());
        patternLayout.setPattern(pattern);
        patternLayout.start();
        return patternLayout;
    }

    public byte[] headerBytes() {
        return null;
    }

    public byte[] encode(ILoggingEvent event) {
        String shortMessage = this.shortPatternLayout.doLayout(event);
        String fullMessage = this.fullPatternLayout.doLayout(event);
        double timestamp = (double)event.getTimeStamp() / 1000.0;
        Map<String, Object> additionalFields = this.mapAdditionalFields(event);
        GelfMessage gelfMessage = new GelfMessage(this.originHost, shortMessage, fullMessage, timestamp, LevelToSyslogSeverity.convert((ILoggingEvent)event), additionalFields);
        String jsonStr = gelfMessage.toJSON();
        if (this.appendNewline) {
            jsonStr = jsonStr + System.lineSeparator();
        }
        return jsonStr.getBytes(StandardCharsets.UTF_8);
    }

    public byte[] footerBytes() {
        return null;
    }

    private Map<String, Object> mapAdditionalFields(ILoggingEvent event) {
        Marker marker;
        HashMap<String, Object> additionalFields = new HashMap<String, Object>(this.staticFields);
        additionalFields.put(this.loggerNameKey, event.getLoggerName());
        additionalFields.put(this.threadNameKey, event.getThreadName());
        if (this.includeRawMessage) {
            additionalFields.put("raw_message", event.getMessage());
        }
        if (this.includeMarker && (marker = event.getMarker()) != null) {
            additionalFields.put("marker", GelfEncoder.buildMarkerStr(marker));
        }
        if (this.includeLevelName) {
            additionalFields.put(this.levelNameKey, event.getLevel().levelStr);
        }
        if (this.includeMdcData) {
            additionalFields.putAll(this.buildMdcData(event.getMDCPropertyMap()));
        }
        if (this.includeCallerData) {
            additionalFields.putAll(this.buildCallerData(event.getCallerData()));
        }
        if (this.includeRootCauseData) {
            additionalFields.putAll(this.buildRootExceptionData(event.getThrowableProxy()));
        }
        return additionalFields;
    }

    private static String buildMarkerStr(Marker marker) {
        if (!marker.hasReferences()) {
            return marker.getName();
        }
        StringBuilder sb = new StringBuilder(marker.getName());
        Iterator it = marker.iterator();
        do {
            sb.append(", ").append(((Marker)it.next()).getName());
        } while (it.hasNext());
        return sb.toString();
    }

    private Map<String, Object> buildMdcData(Map<String, String> mdcProperties) {
        if (mdcProperties == null || mdcProperties.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> additionalFields = new HashMap<String, Object>();
        for (Map.Entry<String, String> entry : mdcProperties.entrySet()) {
            this.addField(additionalFields, entry.getKey(), entry.getValue());
        }
        return additionalFields;
    }

    private Map<String, Object> buildCallerData(StackTraceElement[] callerData) {
        if (callerData == null || callerData.length == 0) {
            return Collections.emptyMap();
        }
        StackTraceElement first = callerData[0];
        HashMap<String, Object> callerDataMap = new HashMap<String, Object>(4);
        callerDataMap.put("source_file_name", first.getFileName());
        callerDataMap.put("source_method_name", first.getMethodName());
        callerDataMap.put("source_class_name", first.getClassName());
        callerDataMap.put("source_line_number", first.getLineNumber());
        return callerDataMap;
    }

    private Map<String, Object> buildRootExceptionData(IThrowableProxy throwableProxy) {
        IThrowableProxy rootException = this.getRootException(throwableProxy);
        if (rootException == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> exceptionDataMap = new HashMap<String, Object>(2);
        exceptionDataMap.put("root_cause_class_name", rootException.getClassName());
        exceptionDataMap.put("root_cause_message", rootException.getMessage());
        return exceptionDataMap;
    }

    private IThrowableProxy getRootException(IThrowableProxy throwableProxy) {
        if (throwableProxy == null) {
            return null;
        }
        IThrowableProxy rootCause = throwableProxy;
        while (rootCause.getCause() != null) {
            rootCause = rootCause.getCause();
        }
        return rootCause;
    }
}

