/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.fastcsv.reader;

import de.siegmar.fastcsv.reader.ByteChannelStream;
import de.siegmar.fastcsv.reader.CommentStrategy;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;

final class CsvScanner {
    private final byte fieldSeparator;
    private final byte quoteCharacter;
    private final byte commentCharacter;
    private final CsvListener csvListener;
    private final ByteChannelStream stream;
    private final boolean readComments;

    CsvScanner(ReadableByteChannel channel, int bomHeaderLength, byte fieldSeparator, byte quoteCharacter, CommentStrategy commentStrategy, byte commentCharacter, CsvListener csvListener) throws IOException {
        this.fieldSeparator = fieldSeparator;
        this.quoteCharacter = quoteCharacter;
        this.commentCharacter = commentCharacter;
        this.csvListener = csvListener;
        this.readComments = commentStrategy != CommentStrategy.NONE;
        this.stream = new ByteChannelStream(channel, csvListener);
        if (bomHeaderLength > 0) {
            for (int i = 0; i < bomHeaderLength; ++i) {
                this.stream.get();
            }
        }
    }

    void scan() throws IOException {
        int d;
        while ((d = this.stream.get()) != -1) {
            this.csvListener.startOffset(this.stream.getOffset());
            if (d == this.commentCharacter && this.readComments) {
                this.consumeCommentedLine();
            } else {
                this.consumeRecord(d);
            }
            this.csvListener.onReadRecord();
        }
    }

    private void consumeRecord(int d) throws IOException {
        while (!(d != this.quoteCharacter ? this.consumeUnquotedField(d) : this.consumeQuotedField()) && (d = this.stream.get()) != -1) {
        }
    }

    private boolean consumeQuotedField() throws IOException {
        int d;
        while ((d = this.stream.get()) != -1) {
            if (d == this.quoteCharacter) {
                if (this.stream.consumeIfNextEq(this.quoteCharacter)) continue;
                break;
            }
            if (d == 13) {
                this.stream.consumeIfNextEq(10);
                this.csvListener.additionalLine();
                continue;
            }
            if (d != 10) continue;
            this.csvListener.additionalLine();
        }
        return this.stream.hasData() && this.consumeUnquotedField(this.stream.get());
    }

    private boolean consumeUnquotedField(int d) throws IOException {
        do {
            if (d == this.fieldSeparator) {
                return false;
            }
            if (d != 13) continue;
            this.stream.consumeIfNextEq(10);
            break;
        } while (d != 10 && (d = this.stream.get()) != -1);
        return true;
    }

    private void consumeCommentedLine() throws IOException {
        int d;
        while ((d = this.stream.get()) != -1) {
            if (d == 13) {
                this.stream.consumeIfNextEq(10);
                break;
            }
            if (d != 10) continue;
            break;
        }
    }

    public static interface CsvListener {
        public void onReadBytes(int var1);

        public void startOffset(long var1);

        public void onReadRecord();

        public void additionalLine();
    }
}

