/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.lucre.data;

import de.sciss.lucre.Exec;
import de.sciss.lucre.Ident;
import de.sciss.lucre.Mutable;
import de.sciss.lucre.TOrdered;
import de.sciss.lucre.Var;
import de.sciss.lucre.data.TotalOrder$Map$;
import de.sciss.lucre.data.TotalOrder$Set$EntryFormat$;
import de.sciss.lucre.data.TotalOrder$Set$EntryOptionFormat$;
import de.sciss.lucre.impl.MutableImpl;
import de.sciss.serial.DataInput;
import de.sciss.serial.DataOutput;
import de.sciss.serial.TFormat;
import de.sciss.serial.Writable;
import de.sciss.serial.WritableFormat;
import java.util.NoSuchElementException;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyVals$;
import scala.runtime.ObjectRef;
import scala.runtime.Scala3RunTime$;
import scala.runtime.Statics;

public interface TotalOrder<T extends Exec<T>>
extends Mutable<T> {
    public Object root();

    public Object head(T var1);

    public int size(T var1);

    public List<Object> tagList(Object var1, T var2);

    public static final class DefinedKey<T extends Exec<T>, A>
    implements KeyOption<T, A> {
        private final Map<T, A> map;
        private final Object get;

        public <T extends Exec<T>, A> DefinedKey(Map<T, A> map, A get) {
            this.map = map;
            this.get = get;
        }

        @Override
        public A get() {
            return (A)this.get;
        }

        @Override
        public boolean isDefined() {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Map.Entry<T, A> orNull() {
            return (Map.Entry)this.map.entryView().apply(this.get());
        }

        public void write(DataOutput out) {
            out.writeByte(1);
            this.map.keyFormat().write(this.get(), out);
        }

        public String toString() {
            return this.get().toString();
        }
    }

    public static final class EmptyKey<T extends Exec<T>, A>
    implements KeyOption<T, A> {
        @Override
        public boolean isDefined() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public A get() {
            throw new NoSuchElementException("EmptyKey.get");
        }

        @Override
        public Map.Entry<T, A> orNull() {
            return null;
        }

        public void write(DataOutput out) {
            out.writeByte(0);
        }

        public String toString() {
            return "<empty>";
        }
    }

    public static interface KeyOption<T extends Exec<T>, A>
    extends Writable {
        public Map.Entry<T, A> orNull();

        public boolean isDefined();

        public boolean isEmpty();

        public A get();
    }

    private static final class KeyOptionFormat<T extends Exec<T>, A>
    implements WritableFormat<T, KeyOption<T, A>> {
        private final Map<T, A> map;

        public <T extends Exec<T>, A> KeyOptionFormat(Map<T, A> map) {
            this.map = map;
        }

        public KeyOption<T, A> readT(DataInput in, T tx) {
            KeyOption keyOption;
            if (in.readByte() == 0) {
                keyOption = this.map.emptyKey();
            } else {
                Object key = this.map.keyFormat().readT(in, tx);
                keyOption = new DefinedKey<T, Object>(this.map, key);
            }
            return keyOption;
        }
    }

    public static interface Map<T extends Exec<T>, A>
    extends TotalOrder<T> {
        public static void $init$(Map $this) {
            $this.de$sciss$lucre$data$TotalOrder$Map$_setter_$emptyKey_$eq(new EmptyKey());
            $this.de$sciss$lucre$data$TotalOrder$Map$_setter_$EntryFormat_$eq((TFormat)new MapEntryFormat($this));
            $this.de$sciss$lucre$data$TotalOrder$Map$_setter_$keyOptionFmt_$eq((TFormat)new KeyOptionFormat($this));
        }

        public static String toString$(Map $this) {
            return $this.toString();
        }

        default public String toString() {
            return "Map" + this.id();
        }

        public KeyOption emptyKey();

        public void de$sciss$lucre$data$TotalOrder$Map$_setter_$emptyKey_$eq(KeyOption var1);

        public TFormat<T, Entry<T, A>> EntryFormat();

        public void de$sciss$lucre$data$TotalOrder$Map$_setter_$EntryFormat_$eq(TFormat var1);

        public TFormat<T, KeyOption<T, A>> keyOptionFmt();

        public void de$sciss$lucre$data$TotalOrder$Map$_setter_$keyOptionFmt_$eq(TFormat var1);

        public Var<T, Object> sizeVal();

        public RelabelObserver<T, A> observer();

        public TFormat<T, A> keyFormat();

        public Function1<A, Entry<T, A>> entryView();

        @Override
        public Entry root();

        public static Entry readEntry$(Map $this, DataInput in, Exec tx) {
            return $this.readEntry(in, tx);
        }

        default public Entry<T, A> readEntry(DataInput in, T tx) {
            return (Entry)this.EntryFormat().readT(in, tx);
        }

        public static void disposeData$(Map $this, Exec tx) {
            $this.disposeData(tx);
        }

        default public void disposeData(T tx) {
            this.root().dispose((Exec)tx);
            this.sizeVal().dispose(tx);
        }

        public static void writeData$(Map $this, DataOutput out) {
            $this.writeData(out);
        }

        default public void writeData(DataOutput out) {
            out.writeByte(84);
            this.sizeVal().write(out);
            this.root().write(out);
        }

        public static Entry insert$(Map $this, Exec tx) {
            return $this.insert(tx);
        }

        default public Entry<T, A> insert(T tx) {
            Ident idE = tx.newId();
            Var recTagVal = idE.newIntVar(-1, tx);
            Var recPrevRef = idE.newVar((Object)this.emptyKey(), tx, this.keyOptionFmt());
            Var recNextRef = idE.newVar((Object)this.emptyKey(), tx, this.keyOptionFmt());
            return new Entry(this, idE, recTagVal, recPrevRef, recNextRef);
        }

        public static void placeAfter$(Map $this, Object prev, Object key, Exec tx) {
            $this.placeAfter(prev, key, tx);
        }

        default public void placeAfter(A prev, A key, T tx) {
            Entry prevE = (Entry)this.entryView().apply(prev);
            KeyOption nextO = prevE.next(tx);
            this.placeBetween(prevE, new DefinedKey(this, prev), nextO.orNull(), nextO, key, tx);
        }

        public static void placeBefore$(Map $this, Object next, Object key, Exec tx) {
            $this.placeBefore(next, key, tx);
        }

        default public void placeBefore(A next, A key, T tx) {
            Entry nextE = (Entry)this.entryView().apply(next);
            KeyOption prevO = nextE.prev(tx);
            this.placeBetween(prevO.orNull(), prevO, nextE, new DefinedKey(this, next), key, tx);
        }

        public static void placeBetween$(Map $this, Entry prevE, KeyOption prevO, Entry nextE, KeyOption nextO, Object key, Exec tx) {
            $this.placeBetween(prevE, prevO, nextE, nextO, key, tx);
        }

        default public void placeBetween(Entry<T, A> prevE, KeyOption<T, A> prevO, Entry<T, A> nextE, KeyOption<T, A> nextO, A key, T tx) {
            int prevTag = prevE != null ? prevE.tag(tx) : 0;
            int nextTag = nextE != null ? nextE.tag(tx) : Integer.MAX_VALUE;
            int recTag = prevTag + (nextTag - prevTag + 1 >>> 1);
            Entry recE = (Entry)this.entryView().apply(key);
            Predef$.MODULE$.require(recE.tag(tx) == -1 && prevTag >= 0 && nextTag >= 0, () -> this.placeBetween$$anonfun$1(tx, prevTag, nextTag, recE));
            recE.updateTag(recTag, tx);
            recE.updatePrev(prevO, tx);
            recE.updateNext(nextO, tx);
            DefinedKey defK = new DefinedKey(this, key);
            if (prevE != null) {
                prevE.updateNext(defK, tx);
            }
            if (nextE != null) {
                nextE.updatePrev(defK, tx);
            }
            this.sizeVal().update((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.sizeVal().apply(tx)) + 1)), tx);
            if (recTag == nextTag) {
                this.relabel(key, recE, tx);
            }
        }

        public static void remove$(Map $this, Entry e, Exec tx) {
            $this.remove(e, tx);
        }

        default public void remove(Entry<T, A> e, T tx) {
            KeyOption<T, A> p = e.prev(tx);
            KeyOption<T, A> n = e.next(tx);
            if (p.isDefined()) {
                p.orNull().updateNext(n, tx);
            }
            if (n.isDefined()) {
                n.orNull().updatePrev(p, tx);
            }
            this.sizeVal().update((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.sizeVal().apply(tx)) - 1)), tx);
        }

        public static int size$(Map $this, Exec tx) {
            return $this.size(tx);
        }

        @Override
        default public int size(T tx) {
            return BoxesRunTime.unboxToInt((Object)this.sizeVal().apply(tx));
        }

        public static Entry head$(Map $this, Exec tx) {
            return $this.head(tx);
        }

        @Override
        default public Entry<T, A> head(T tx) {
            return this.step$1((Exec)tx, this.root());
        }

        public static List tagList$(Map $this, Entry from, Exec tx) {
            return $this.tagList(from, tx);
        }

        default public List<Object> tagList(Entry<T, A> from, T tx) {
            Builder b = package$.MODULE$.List().newBuilder();
            return this.step$2((Exec)tx, b, from);
        }

        private void relabel(A recK, Entry<T, A> recE, T tx) {
            IntRef mask = IntRef.create((int)-1);
            double thresh = 1.0;
            IntRef num = IntRef.create((int)1);
            double mul = (double)2 / scala.math.package$.MODULE$.pow((double)(this.size(tx) << 1), 0.03333333333333333);
            ObjectRef firstE = ObjectRef.create(recE);
            ObjectRef firstK = ObjectRef.create(recK);
            ObjectRef lastE = ObjectRef.create(recE);
            IntRef base = IntRef.create((int)recE.tag(tx));
            IntRef recOff = IntRef.create((int)0);
            do {
                int n;
                int n2;
                int inc;
                this.stepLeft$1((Exec)tx, mask, num, firstE, firstK, base, recOff);
                this.stepRight$1((Exec)tx, mask, num, lastE, base);
                if (num.elem > 1 && (double)(inc = -mask.elem / num.elem) >= thresh) {
                    int numM1 = num.elem - 1;
                    RelabelIterator<T, A> relabelIterator = recOff.elem == 0 ? new RelabelIterator<T, A>(-1, numM1, recE, ((Entry)firstE.elem).next(tx), this.entryView(), tx) : new RelabelIterator<T, Object>(recOff.elem, numM1, recE, new DefinedKey(this, firstK.elem), this.entryView(), tx);
                    this.observer().beforeRelabeling(relabelIterator, tx);
                    Entry curr = (Entry)firstE.elem;
                    int cnt = 0;
                    while (cnt < numM1) {
                        int n3;
                        curr.updateTag(base.elem, tx);
                        Object nextK = curr.next(tx).get();
                        base.elem = n3 = base.elem + inc;
                        curr = ++cnt == recOff.elem ? recE : (Entry)this.entryView().apply(nextK);
                    }
                    curr.updateTag(base.elem, tx);
                    relabelIterator.reset();
                    this.observer().afterRelabeling(relabelIterator, tx);
                    return;
                }
                mask.elem = n2 = mask.elem << 1;
                base.elem = n = base.elem & mask.elem;
                thresh *= mul;
            } while (mask.elem != 0);
            throw scala.sys.package$.MODULE$.error("label overflow");
        }

        private String placeBetween$$anonfun$1(Exec tx$1, int prevTag$1, int nextTag$1, Entry recE$1) {
            StringBuilder msg = new StringBuilder();
            if (recE$1.tag(tx$1) != -1) {
                msg.append("Placed key was already placed before. ");
            }
            if (prevTag$1 < 0) {
                msg.append("Predecessor of placed key has not yet been placed. ");
            }
            if (nextTag$1 < 0) {
                msg.append("Successor of placed key has not yet been placed. ");
            }
            return msg.toString();
        }

        private Entry step$1(Exec tx$2, Entry e) {
            KeyOption prevO;
            Entry entry = e;
            while (!(prevO = entry.prev(tx$2)).isEmpty()) {
                entry = prevO.orNull();
            }
            return entry;
        }

        private List step$2(Exec tx$3, Builder b$1, Entry e) {
            Entry entry = e;
            while (true) {
                b$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)entry.tag(tx$3)));
                KeyOption nextO = entry.next(tx$3);
                if (nextO.isEmpty()) break;
                entry = nextO.orNull();
            }
            return (List)b$1.result();
        }

        private void stepLeft$1(Exec tx$4, IntRef mask$1, IntRef num$1, ObjectRef firstE$1, ObjectRef firstK$1, IntRef base$1, IntRef recOff$1) {
            KeyOption prevO;
            while ((prevO = ((Entry)firstE$1.elem).prev(tx$4)).isDefined()) {
                int n;
                int n2;
                Object prevK = prevO.get();
                Entry prevE = (Entry)this.entryView().apply(prevK);
                if ((prevE.tag(tx$4) & mask$1.elem) != base$1.elem) break;
                Entry entry = prevE;
                firstE$1.elem = entry;
                Object a = prevK;
                firstK$1.elem = a;
                num$1.elem = n2 = num$1.elem + 1;
                recOff$1.elem = n = recOff$1.elem + 1;
            }
        }

        private void stepRight$1(Exec tx$5, IntRef mask$2, IntRef num$2, ObjectRef lastE$1, IntRef base$2) {
            Entry nextE;
            KeyOption nextO;
            while ((nextO = ((Entry)lastE$1.elem).next(tx$5)).isDefined() && ((nextE = (Entry)this.entryView().apply(nextO.get())).tag(tx$5) & mask$2.elem) == base$2.elem) {
                int n;
                Entry entry = nextE;
                lastE$1.elem = entry;
                num$2.elem = n = num$2.elem + 1;
            }
        }

        public static final class Entry<T extends Exec<T>, A>
        implements MutableImpl<T>,
        TOrdered<T, Entry<T, A>> {
            private final Map<T, A> map;
            private final Ident id;
            private final Var<T, Object> tagVal;
            private final Var<T, KeyOption<T, A>> prevRef;
            private final Var<T, KeyOption<T, A>> nextRef;

            public <T extends Exec<T>, A> Entry(Map<T, A> map, Ident<T> id, Var<T, Object> tagVal, Var<T, KeyOption<T, A>> prevRef, Var<T, KeyOption<T, A>> nextRef) {
                this.map = map;
                this.id = id;
                this.tagVal = tagVal;
                this.prevRef = prevRef;
                this.nextRef = nextRef;
            }

            public /* synthetic */ boolean de$sciss$lucre$Identified$$super$equals(Object x$0) {
                return super.equals(x$0);
            }

            public /* synthetic */ String de$sciss$lucre$impl$MutableImpl$$super$toString() {
                return super.toString();
            }

            public Ident<T> id() {
                return this.id;
            }

            public int tag(T tx) {
                return BoxesRunTime.unboxToInt((Object)this.tagVal.apply(tx));
            }

            public void validate(Function0<String> msg, T tx) {
                int nextTag;
                int prevTag;
                int recTag = this.tag(tx);
                if (this.prev(tx).isDefined() && (prevTag = ((Entry)this.map.entryView().apply(this.prev(tx).get())).tag(tx)) >= recTag) {
                    throw Scala3RunTime$.MODULE$.assertFailed((Object)("prev " + prevTag + " >= rec " + recTag + " - " + msg.apply()));
                }
                if (this.next(tx).isDefined() && recTag >= (nextTag = ((Entry)this.map.entryView().apply(this.next(tx).get())).tag(tx))) {
                    throw Scala3RunTime$.MODULE$.assertFailed((Object)("rec " + recTag + " >= next " + nextTag + " - " + msg.apply()));
                }
            }

            public String toString() {
                return "Map.Entry" + this.id();
            }

            public KeyOption<T, A> prev(T tx) {
                return (KeyOption)this.prevRef.apply(tx);
            }

            public KeyOption<T, A> next(T tx) {
                return (KeyOption)this.nextRef.apply(tx);
            }

            public void updatePrev(KeyOption<T, A> e, T tx) {
                this.prevRef.update(e, tx);
            }

            public void updateNext(KeyOption<T, A> e, T tx) {
                this.nextRef.update(e, tx);
            }

            public void updateTag(int value, T tx) {
                this.tagVal.update((Object)BoxesRunTime.boxToInteger((int)value), tx);
            }

            @Override
            public int compare(Entry<T, A> that, T tx) {
                int thatTag;
                int thisTag = this.tag(tx);
                return thisTag < (thatTag = that.tag(tx)) ? -1 : (thisTag > thatTag ? 1 : 0);
            }

            public void writeData(DataOutput out) {
                this.tagVal.write(out);
                this.prevRef.write(out);
                this.nextRef.write(out);
            }

            public void disposeData(T tx) {
                this.prevRef.dispose(tx);
                this.nextRef.dispose(tx);
                this.tagVal.dispose(tx);
            }

            public void remove(T tx) {
                this.map.remove(this, tx);
            }

            public void removeAndDispose(T tx) {
                this.remove(tx);
                this.dispose((Exec)tx);
            }
        }

        public static interface RelabelObserver<Tx, A> {
            public void beforeRelabeling(Iterator<A> var1, Tx var2);

            public void afterRelabeling(Iterator<A> var1, Tx var2);
        }
    }

    private static final class MapEntryFormat<T extends Exec<T>, A>
    implements WritableFormat<T, Map.Entry<T, A>> {
        private final Map<T, A> map;

        public <T extends Exec<T>, A> MapEntryFormat(Map<T, A> map) {
            this.map = map;
        }

        public Map.Entry<T, A> readT(DataInput in, T tx) {
            Ident idE = tx.readId(in);
            Var tagVal = idE.readIntVar(in);
            Var prevRef = idE.readVar(in, this.map.keyOptionFmt());
            Var nextRef = idE.readVar(in, this.map.keyOptionFmt());
            return new Map.Entry<T, A>(this.map, idE, tagVal, prevRef, nextRef);
        }
    }

    private static final class MapFormat<T extends Exec<T>, A>
    implements WritableFormat<T, Map<T, A>> {
        private final Map.RelabelObserver<T, A> observer;
        private final Function1<A, Map.Entry<T, A>> entryView;
        private final TFormat<T, A> keyFormat;

        public <T extends Exec<T>, A> MapFormat(Map.RelabelObserver<T, A> observer, Function1<A, Map.Entry<T, A>> entryView, TFormat<T, A> keyFormat) {
            this.observer = observer;
            this.entryView = entryView;
            this.keyFormat = keyFormat;
        }

        public Map<T, A> readT(DataInput in, T tx) {
            return TotalOrder$Map$.MODULE$.read(in, this.observer, this.entryView, tx, this.keyFormat);
        }

        public String toString() {
            return "Map.format";
        }
    }

    private static final class MapNew<T extends Exec<T>, A>
    implements Map<T, A>,
    MutableImpl<T> {
        private KeyOption emptyKey;
        private TFormat EntryFormat;
        private TFormat keyOptionFmt;
        private final Map.RelabelObserver observer;
        private final Function1 entryView;
        private final TFormat keyFormat;
        private final Ident id;
        private final Var sizeVal;
        private final Map.Entry root;

        public <T extends Exec<T>, A> MapNew(Map.RelabelObserver<T, A> observer, Function1<A, Map.Entry<T, A>> entryView, int rootTag, T tx0, TFormat<T, A> keyFormat) {
            this.observer = observer;
            this.entryView = entryView;
            this.keyFormat = keyFormat;
            Map.$init$(this);
            this.id = tx0.newId();
            this.sizeVal = this.id().newIntVar(1, tx0);
            T tx = tx0;
            Ident idE = tx.newId();
            Var tagVal = idE.newIntVar(rootTag, tx);
            Var prevRef = idE.newVar((Object)this.emptyKey(), tx, this.keyOptionFmt());
            Var nextRef = idE.newVar((Object)this.emptyKey(), tx, this.keyOptionFmt());
            this.root = new Map.Entry(this, idE, tagVal, prevRef, nextRef);
            Statics.releaseFence();
        }

        @Override
        public final KeyOption emptyKey() {
            return this.emptyKey;
        }

        @Override
        public final TFormat EntryFormat() {
            return this.EntryFormat;
        }

        @Override
        public final TFormat keyOptionFmt() {
            return this.keyOptionFmt;
        }

        @Override
        public void de$sciss$lucre$data$TotalOrder$Map$_setter_$emptyKey_$eq(KeyOption x$0) {
            this.emptyKey = x$0;
        }

        @Override
        public void de$sciss$lucre$data$TotalOrder$Map$_setter_$EntryFormat_$eq(TFormat x$0) {
            this.EntryFormat = x$0;
        }

        @Override
        public void de$sciss$lucre$data$TotalOrder$Map$_setter_$keyOptionFmt_$eq(TFormat x$0) {
            this.keyOptionFmt = x$0;
        }

        public /* synthetic */ boolean de$sciss$lucre$Identified$$super$equals(Object x$0) {
            return super.equals(x$0);
        }

        public /* synthetic */ String de$sciss$lucre$impl$MutableImpl$$super$toString() {
            return Map.toString$(this);
        }

        @Override
        public Map.RelabelObserver<T, A> observer() {
            return this.observer;
        }

        @Override
        public Function1<A, Map.Entry<T, A>> entryView() {
            return this.entryView;
        }

        @Override
        public TFormat<T, A> keyFormat() {
            return this.keyFormat;
        }

        public Ident<T> id() {
            return this.id;
        }

        @Override
        public Var<T, Object> sizeVal() {
            return this.sizeVal;
        }

        @Override
        public Map.Entry root() {
            return this.root;
        }
    }

    private static final class MapRead<T extends Exec<T>, A>
    implements Map<T, A>,
    MutableImpl<T> {
        private KeyOption emptyKey;
        private TFormat EntryFormat;
        private TFormat keyOptionFmt;
        private final Map.RelabelObserver observer;
        private final Function1 entryView;
        private final TFormat keyFormat;
        private final Ident id;
        private final Var sizeVal;
        private final Map.Entry root;

        public <T extends Exec<T>, A> MapRead(Map.RelabelObserver<T, A> observer, Function1<A, Map.Entry<T, A>> entryView, DataInput in, T tx0, TFormat<T, A> keyFormat) {
            this.observer = observer;
            this.entryView = entryView;
            this.keyFormat = keyFormat;
            Map.$init$(this);
            this.id = tx0.readId(in);
            byte version = in.readByte();
            Predef$.MODULE$.require(version == 84, () -> this.$init$$$anonfun$1(version));
            this.sizeVal = this.id().readIntVar(in);
            this.root = (Map.Entry)this.EntryFormat().readT(in, tx0);
            Statics.releaseFence();
        }

        @Override
        public final KeyOption emptyKey() {
            return this.emptyKey;
        }

        @Override
        public final TFormat EntryFormat() {
            return this.EntryFormat;
        }

        @Override
        public final TFormat keyOptionFmt() {
            return this.keyOptionFmt;
        }

        @Override
        public void de$sciss$lucre$data$TotalOrder$Map$_setter_$emptyKey_$eq(KeyOption x$0) {
            this.emptyKey = x$0;
        }

        @Override
        public void de$sciss$lucre$data$TotalOrder$Map$_setter_$EntryFormat_$eq(TFormat x$0) {
            this.EntryFormat = x$0;
        }

        @Override
        public void de$sciss$lucre$data$TotalOrder$Map$_setter_$keyOptionFmt_$eq(TFormat x$0) {
            this.keyOptionFmt = x$0;
        }

        public /* synthetic */ boolean de$sciss$lucre$Identified$$super$equals(Object x$0) {
            return super.equals(x$0);
        }

        public /* synthetic */ String de$sciss$lucre$impl$MutableImpl$$super$toString() {
            return Map.toString$(this);
        }

        @Override
        public Map.RelabelObserver<T, A> observer() {
            return this.observer;
        }

        @Override
        public Function1<A, Map.Entry<T, A>> entryView() {
            return this.entryView;
        }

        @Override
        public TFormat<T, A> keyFormat() {
            return this.keyFormat;
        }

        public Ident<T> id() {
            return this.id;
        }

        @Override
        public Var<T, Object> sizeVal() {
            return this.sizeVal;
        }

        @Override
        public Map.Entry<T, A> root() {
            return this.root;
        }

        private final String $init$$$anonfun$1(byte version$1) {
            return "Incompatible serialized version (found " + version$1 + ", required " + 84 + ").";
        }
    }

    private static final class RelabelIterator<T extends Exec<T>, A>
    implements Iterator<A> {
        private final int recOff;
        private final int num;
        private final Map.Entry<T, A> recE;
        private final KeyOption<T, A> firstK;
        private final Function1<A, Map.Entry<T, A>> entryView;
        private final T tx;
        private KeyOption<T, A> currK;
        private int cnt;

        public <T extends Exec<T>, A> RelabelIterator(int recOff, int num, Map.Entry<T, A> recE, KeyOption<T, A> firstK, Function1<A, Map.Entry<T, A>> entryView, T tx) {
            this.recOff = recOff;
            this.num = num;
            this.recE = recE;
            this.firstK = firstK;
            this.entryView = entryView;
            this.tx = tx;
            IterableOnce.$init$((IterableOnce)this);
            IterableOnceOps.$init$((IterableOnceOps)this);
            Iterator.$init$((Iterator)this);
            this.currK = firstK;
            this.cnt = 0;
        }

        public boolean hasNext() {
            return this.cnt < this.num;
        }

        /*
         * WARNING - void declaration
         */
        public A next() {
            void var1_1;
            if (this.cnt == this.num) {
                throw new NoSuchElementException("next on empty iterator");
            }
            A res = this.currK.get();
            ++this.cnt;
            Map.Entry currE = this.cnt == this.recOff ? this.recE : (Map.Entry)this.entryView.apply(res);
            this.currK = currE.next(this.tx);
            return var1_1;
        }

        public void reset() {
            this.currK = this.firstK;
            this.cnt = 0;
        }
    }

    public static interface Set<T extends Exec<T>>
    extends TotalOrder<T> {
        public static void $init$(Set $this) {
            $this.de$sciss$lucre$data$TotalOrder$Set$_setter_$empty_$eq(new EmptyEntry());
        }

        public Var<T, Object> sizeVal();

        public EmptyEntry<T> empty();

        public void de$sciss$lucre$data$TotalOrder$Set$_setter_$empty_$eq(EmptyEntry var1);

        public static String toString$(Set $this) {
            return $this.toString();
        }

        default public String toString() {
            return "Set" + this.id();
        }

        public static Entry readEntry$(Set $this, DataInput in, Exec tx) {
            return $this.readEntry(in, tx);
        }

        default public Entry<T> readEntry(DataInput in, T tx) {
            return this.EntryFormat().readT(in, tx);
        }

        public static TotalOrder$Set$EntryFormat$ EntryFormat$(Set $this) {
            return $this.EntryFormat();
        }

        default public TotalOrder$Set$EntryFormat$ EntryFormat() {
            return new TotalOrder$Set$EntryFormat$(this);
        }

        public static TotalOrder$Set$EntryOptionFormat$ EntryOptionFormat$(Set $this) {
            return $this.EntryOptionFormat();
        }

        default public TotalOrder$Set$EntryOptionFormat$ EntryOptionFormat() {
            return new TotalOrder$Set$EntryOptionFormat$(this);
        }

        public static void disposeData$(Set $this, Exec tx) {
            $this.disposeData(tx);
        }

        default public void disposeData(T tx) {
            ((MutableImpl)this.root()).dispose(tx);
            this.sizeVal().dispose(tx);
        }

        public static void writeData$(Set $this, DataOutput out) {
            $this.writeData(out);
        }

        default public void writeData(DataOutput out) {
            out.writeByte(84);
            this.sizeVal().write(out);
            ((MutableImpl)this.root()).write(out);
        }

        public static Entry insertMaxAfter$(Set $this, Entry prev, Exec tx) {
            return $this.insertMaxAfter(prev, tx);
        }

        default public Entry<T> insertMaxAfter(Entry<T> prev, T tx) {
            int n1;
            EntryOption<T> next = prev.next(tx);
            int nextTag = next.tagOr(Integer.MIN_VALUE, tx);
            int prevTag = prev.tag(tx);
            int recTag = prevTag == (n1 = nextTag - 1) ? nextTag : n1;
            return this.insert(prev, next, nextTag, recTag, tx);
        }

        public static Entry insertAfter$(Set $this, Entry prev, Exec tx) {
            return $this.insertAfter(prev, tx);
        }

        default public Entry<T> insertAfter(Entry<T> prev, T tx) {
            EntryOption<T> next = prev.next(tx);
            int nextTag = next.tagOr(Integer.MAX_VALUE, tx);
            int prevTag = prev.tag(tx);
            int recTag = prevTag + (nextTag - prevTag + 1 >>> 1);
            return this.insert(prev, next, nextTag, recTag, tx);
        }

        public static Entry insertBefore$(Set $this, Entry next, Exec tx) {
            return $this.insertBefore(next, tx);
        }

        default public Entry<T> insertBefore(Entry<T> next, T tx) {
            EntryOption<T> prev = next.prev(tx);
            int prevTag = prev.tagOr(0, tx);
            int nextTag = next.tag(tx);
            int recTag = prevTag + (nextTag - prevTag + 1 >>> 1);
            return this.insert(prev, next, nextTag, recTag, tx);
        }

        private Entry<T> insert(EntryOption<T> prev, EntryOption<T> next, int nextTag, int recTag, T tx) {
            Ident idE = tx.newId();
            Var recPrevRef = idE.newVar(prev, tx, (TFormat)this.EntryOptionFormat());
            Var recNextRef = idE.newVar(next, tx, (TFormat)this.EntryOptionFormat());
            Var recTagVal = idE.newIntVar(recTag, tx);
            Entry rec = new Entry(idE, this, recTagVal, recPrevRef, recNextRef);
            prev.updateNext(rec, tx);
            next.updatePrev(rec, tx);
            this.sizeVal().update((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.sizeVal().apply(tx)) + 1)), tx);
            if (recTag == nextTag) {
                this.relabel(rec, tx);
            }
            return rec;
        }

        public static void remove$(Set $this, Entry entry, Exec tx) {
            $this.remove(entry, tx);
        }

        default public void remove(Entry<T> entry, T tx) {
            EntryOption<T> p = entry.prev(tx);
            EntryOption<T> n = entry.next(tx);
            p.updateNext(n, tx);
            n.updatePrev(p, tx);
            this.sizeVal().update((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.sizeVal().apply(tx)) - 1)), tx);
        }

        public static int size$(Set $this, Exec tx) {
            return $this.size(tx);
        }

        @Override
        default public int size(T tx) {
            return BoxesRunTime.unboxToInt((Object)this.sizeVal().apply(tx));
        }

        public static Entry head$(Set $this, Exec tx) {
            return $this.head(tx);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        default public Entry<T> head(T tx) {
            void var2_2;
            Entry<T> e = (Entry<T>)this.root();
            for (Entry<T> p = e.prevOrNull(tx); p != null; p = p.prevOrNull(tx)) {
                e = p;
            }
            return var2_2;
        }

        public static List tagList$(Set $this, Entry from, Exec tx) {
            return $this.tagList(from, tx);
        }

        default public List<Object> tagList(Entry<T> from, T tx) {
            Builder b = package$.MODULE$.List().newBuilder();
            for (Entry<T> entry = from; entry != null; entry = entry.nextOrNull(tx)) {
                b.$plus$eq((Object)BoxesRunTime.boxToInteger((int)entry.tag(tx)));
            }
            return (List)b.result();
        }

        private void relabel(Entry<T> _first, T tx) {
            int mask = -1;
            double thresh = 1.0;
            int num = 1;
            double mul = (double)2 / scala.math.package$.MODULE$.pow((double)(this.size(tx) << 1), 0.03333333333333333);
            Entry<T> first = _first;
            Entry<T> last = _first;
            int base = _first.tag(tx);
            do {
                Entry<T> prev = first.prevOrNull(tx);
                while (prev != null && (prev.tag(tx) & mask) == base) {
                    first = prev;
                    prev = prev.prevOrNull(tx);
                    ++num;
                }
                Entry<T> next = last.nextOrNull(tx);
                while (next != null && (next.tag(tx) & mask) == base) {
                    last = next;
                    next = next.nextOrNull(tx);
                    ++num;
                }
                int inc = -mask / num;
                if ((double)inc >= thresh && num > 1) {
                    next = first;
                    for (int cnt = 0; cnt < num; ++cnt) {
                        next.updateTag(base, tx);
                        next = next.nextOrNull(tx);
                        base += inc;
                    }
                    return;
                }
                base &= (mask <<= 1);
                thresh *= mul;
            } while (mask != 0);
            throw scala.sys.package$.MODULE$.error("label overflow");
        }

        public static final class EmptyEntry<T extends Exec<T>>
        implements EntryOption<T> {
            @Override
            public void updatePrev(EntryOption<T> e, T t) {
            }

            @Override
            public void updateNext(EntryOption<T> e, T t) {
            }

            @Override
            public Entry orNull() {
                return null;
            }

            @Override
            public void updateTag(int value, T t) {
                throw scala.sys.package$.MODULE$.error("Internal error - shouldn't be here");
            }

            @Override
            public int tagOr(int empty, T tx) {
                return empty;
            }

            @Override
            public boolean isDefined() {
                return false;
            }

            @Override
            public boolean isEmpty() {
                return true;
            }

            public String toString() {
                return "<empty>";
            }
        }

        public static final class Entry<T extends Exec<T>>
        implements EntryOption<T>,
        MutableImpl<T>,
        TOrdered<T, Entry<T>> {
            private final Ident id;
            private final Set<T> set;
            private final Var<T, Object> tagVal;
            private final Var<T, EntryOption<T>> prevRef;
            private final Var<T, EntryOption<T>> nextRef;

            public <T extends Exec<T>> Entry(Ident<T> id, Set<T> set, Var<T, Object> tagVal, Var<T, EntryOption<T>> prevRef, Var<T, EntryOption<T>> nextRef) {
                this.id = id;
                this.set = set;
                this.tagVal = tagVal;
                this.prevRef = prevRef;
                this.nextRef = nextRef;
            }

            public /* synthetic */ boolean de$sciss$lucre$Identified$$super$equals(Object x$0) {
                return super.equals(x$0);
            }

            public /* synthetic */ String de$sciss$lucre$impl$MutableImpl$$super$toString() {
                return super.toString();
            }

            public Ident<T> id() {
                return this.id;
            }

            public String toString() {
                return "Set.Entry" + this.id();
            }

            @Override
            public int compare(Entry<T> that, T tx) {
                int thatTag;
                int thisTag = this.tag(tx);
                return thisTag < (thatTag = that.tag(tx)) ? -1 : (thisTag > thatTag ? 1 : 0);
            }

            public int tag(T t) {
                return BoxesRunTime.unboxToInt((Object)this.tagVal.apply(t));
            }

            @Override
            public int tagOr(int empty, T t) {
                return BoxesRunTime.unboxToInt((Object)this.tagVal.apply(t));
            }

            public EntryOption<T> prev(T tx) {
                return (EntryOption)this.prevRef.apply(tx);
            }

            public EntryOption<T> next(T tx) {
                return (EntryOption)this.nextRef.apply(tx);
            }

            public Entry<T> prevOrNull(T tx) {
                return ((EntryOption)this.prevRef.apply(tx)).orNull();
            }

            public Entry<T> nextOrNull(T tx) {
                return ((EntryOption)this.nextRef.apply(tx)).orNull();
            }

            @Override
            public Entry orNull() {
                return this;
            }

            @Override
            public boolean isDefined() {
                return true;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public void updatePrev(EntryOption<T> e, T tx) {
                this.prevRef.update(e, tx);
            }

            @Override
            public void updateNext(EntryOption<T> e, T tx) {
                this.nextRef.update(e, tx);
            }

            @Override
            public void updateTag(int value, T tx) {
                this.tagVal.update((Object)BoxesRunTime.boxToInteger((int)value), tx);
            }

            public void writeData(DataOutput out) {
                this.tagVal.write(out);
                this.prevRef.write(out);
                this.nextRef.write(out);
            }

            public void disposeData(T tx) {
                this.prevRef.dispose(tx);
                this.nextRef.dispose(tx);
                this.tagVal.dispose(tx);
            }

            public void remove(T tx) {
                this.set.remove(this, tx);
            }

            public Entry<T> append(T tx) {
                return this.set.insertAfter(this, tx);
            }

            public Entry<T> appendMax(T tx) {
                return this.set.insertMaxAfter(this, tx);
            }

            public Entry<T> prepend(T tx) {
                return this.set.insertBefore(this, tx);
            }

            public void removeAndDispose(T tx) {
                this.remove(tx);
                this.dispose((Exec)tx);
            }

            public void validate(Function0<String> msg, T tx) {
                int nextTag;
                int prevTag;
                int recTag = this.tag(tx);
                if (this.prev(tx).isDefined() && (prevTag = this.prev(tx).orNull().tag(tx)) >= recTag) {
                    throw Scala3RunTime$.MODULE$.assertFailed((Object)("prev " + prevTag + " >= rec " + recTag + " - " + msg.apply()));
                }
                if (this.next(tx).isDefined() && recTag >= (nextTag = this.next(tx).orNull().tag(tx))) {
                    throw Scala3RunTime$.MODULE$.assertFailed((Object)("rec " + recTag + " >= next " + nextTag + " - " + msg.apply()));
                }
            }
        }

        public static interface EntryOption<T extends Exec<T>> {
            public int tagOr(int var1, T var2);

            public void updatePrev(EntryOption<T> var1, T var2);

            public void updateNext(EntryOption<T> var1, T var2);

            public void updateTag(int var1, T var2);

            public Entry orNull();

            public boolean isDefined();

            public boolean isEmpty();
        }
    }

    private static final class SetFormat<T extends Exec<T>>
    implements WritableFormat<T, Set<T>> {
        public Set<T> readT(DataInput in, T tx) {
            return new SetRead<T>(in, tx);
        }

        public String toString() {
            return "Set.format";
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static final class SetNew<T extends Exec<T>>
    implements Set<T>,
    MutableImpl<T> {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffset(SetNew.class, "0bitmap$2");
        private Set.EmptyEntry empty;
        public TotalOrder$Set$EntryFormat$ EntryFormat$lzy2;
        public long 0bitmap$2;
        public TotalOrder$Set$EntryOptionFormat$ EntryOptionFormat$lzy2;
        private final Ident id;
        private final Var sizeVal;
        private final Set.Entry root;

        public <T extends Exec<T>> SetNew(int rootTag, T tx0) {
            Set.$init$(this);
            this.id = tx0.newId();
            this.sizeVal = this.id().newIntVar(1, tx0);
            Ident rootId = tx0.newId();
            Var tagVal = rootId.newIntVar(rootTag, tx0);
            Var prevRef = this.id().newVar((Object)this.empty(), tx0, (TFormat)this.EntryOptionFormat());
            Var nextRef = this.id().newVar((Object)this.empty(), tx0, (TFormat)this.EntryOptionFormat());
            this.root = new Set.Entry(rootId, this, tagVal, prevRef, nextRef);
            Statics.releaseFence();
        }

        @Override
        public final Set.EmptyEntry empty() {
            return this.empty;
        }

        @Override
        public final TotalOrder$Set$EntryFormat$ EntryFormat() {
            long l;
            long l2;
            while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
                if (l2 == 0L) {
                    if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                    try {
                        TotalOrder$Set$EntryFormat$ totalOrder$Set$EntryFormat$;
                        this.EntryFormat$lzy2 = totalOrder$Set$EntryFormat$ = new TotalOrder$Set$EntryFormat$(this);
                        LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                        return totalOrder$Set$EntryFormat$;
                    }
                    catch (Throwable throwable) {
                        LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                        throw throwable;
                    }
                }
                LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
            }
            return this.EntryFormat$lzy2;
        }

        @Override
        public final TotalOrder$Set$EntryOptionFormat$ EntryOptionFormat() {
            long l;
            long l2;
            while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 1)) != 3L) {
                if (l2 == 0L) {
                    if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 1)) continue;
                    try {
                        TotalOrder$Set$EntryOptionFormat$ totalOrder$Set$EntryOptionFormat$;
                        this.EntryOptionFormat$lzy2 = totalOrder$Set$EntryOptionFormat$ = new TotalOrder$Set$EntryOptionFormat$(this);
                        LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 1);
                        return totalOrder$Set$EntryOptionFormat$;
                    }
                    catch (Throwable throwable) {
                        LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 1);
                        throw throwable;
                    }
                }
                LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 1);
            }
            return this.EntryOptionFormat$lzy2;
        }

        @Override
        public void de$sciss$lucre$data$TotalOrder$Set$_setter_$empty_$eq(Set.EmptyEntry x$0) {
            this.empty = x$0;
        }

        public /* synthetic */ boolean de$sciss$lucre$Identified$$super$equals(Object x$0) {
            return super.equals(x$0);
        }

        public /* synthetic */ String de$sciss$lucre$impl$MutableImpl$$super$toString() {
            return Set.toString$(this);
        }

        public Ident<T> id() {
            return this.id;
        }

        @Override
        public Var<T, Object> sizeVal() {
            return this.sizeVal;
        }

        @Override
        public Set.Entry root() {
            return this.root;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static final class SetRead<T extends Exec<T>>
    implements Set<T>,
    MutableImpl<T> {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffset(SetRead.class, "0bitmap$1");
        private Set.EmptyEntry empty;
        public TotalOrder$Set$EntryFormat$ EntryFormat$lzy1;
        public long 0bitmap$1;
        public TotalOrder$Set$EntryOptionFormat$ EntryOptionFormat$lzy1;
        private final Ident id;
        private final Var sizeVal;
        private final Set.Entry root;

        public <T extends Exec<T>> SetRead(DataInput in, T tx0) {
            Set.$init$(this);
            this.id = tx0.readId(in);
            byte version = in.readByte();
            if (version != 84) {
                throw scala.sys.package$.MODULE$.error("Incompatible serialized version (found " + version + ", required " + 84 + ").");
            }
            this.sizeVal = this.id().readIntVar(in);
            this.root = this.EntryFormat().readT(in, tx0);
            Statics.releaseFence();
        }

        @Override
        public final Set.EmptyEntry empty() {
            return this.empty;
        }

        @Override
        public final TotalOrder$Set$EntryFormat$ EntryFormat() {
            long l;
            long l2;
            while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
                if (l2 == 0L) {
                    if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                    try {
                        TotalOrder$Set$EntryFormat$ totalOrder$Set$EntryFormat$;
                        this.EntryFormat$lzy1 = totalOrder$Set$EntryFormat$ = new TotalOrder$Set$EntryFormat$(this);
                        LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                        return totalOrder$Set$EntryFormat$;
                    }
                    catch (Throwable throwable) {
                        LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                        throw throwable;
                    }
                }
                LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
            }
            return this.EntryFormat$lzy1;
        }

        @Override
        public final TotalOrder$Set$EntryOptionFormat$ EntryOptionFormat() {
            long l;
            long l2;
            while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 1)) != 3L) {
                if (l2 == 0L) {
                    if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 1)) continue;
                    try {
                        TotalOrder$Set$EntryOptionFormat$ totalOrder$Set$EntryOptionFormat$;
                        this.EntryOptionFormat$lzy1 = totalOrder$Set$EntryOptionFormat$ = new TotalOrder$Set$EntryOptionFormat$(this);
                        LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 1);
                        return totalOrder$Set$EntryOptionFormat$;
                    }
                    catch (Throwable throwable) {
                        LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 1);
                        throw throwable;
                    }
                }
                LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 1);
            }
            return this.EntryOptionFormat$lzy1;
        }

        @Override
        public void de$sciss$lucre$data$TotalOrder$Set$_setter_$empty_$eq(Set.EmptyEntry x$0) {
            this.empty = x$0;
        }

        public /* synthetic */ boolean de$sciss$lucre$Identified$$super$equals(Object x$0) {
            return super.equals(x$0);
        }

        public /* synthetic */ String de$sciss$lucre$impl$MutableImpl$$super$toString() {
            return Set.toString$(this);
        }

        public Ident<T> id() {
            return this.id;
        }

        @Override
        public Var<T, Object> sizeVal() {
            return this.sizeVal;
        }

        @Override
        public Set.Entry<T> root() {
            return this.root;
        }
    }
}

