/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.lucre.data;

import de.sciss.lucre.Exec;
import de.sciss.lucre.Ident;
import de.sciss.lucre.Sink;
import de.sciss.lucre.Source;
import de.sciss.lucre.TOrdering;
import de.sciss.lucre.Var;
import de.sciss.lucre.data.HASkipList$;
import de.sciss.lucre.data.HASkipList$Branch$;
import de.sciss.lucre.data.HASkipList$Map$;
import de.sciss.lucre.data.HASkipList$Set$;
import de.sciss.lucre.data.SkipList;
import de.sciss.lucre.data.SkipList$NoKeyObserver$;
import de.sciss.lucre.impl.MutableImpl;
import de.sciss.serial.DataInput;
import de.sciss.serial.DataOutput;
import de.sciss.serial.TFormat;
import de.sciss.serial.Writable;
import de.sciss.serial.WritableFormat;
import java.io.Serializable;
import java.util.NoSuchElementException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Builder;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;

public interface HASkipList<T extends Exec<T>, A, E>
extends SkipList<T, A, E> {
    public Option<Node<T, A, E>> top(T var1);

    public int indexInNodeR(A var1, Node<T, A, E> var2, T var3);

    public int indexInNodeL(A var1, Node<T, A, E> var2, T var3);

    public static final class Branch<T extends Exec<T>, A, B>
    implements HeadOrBranch<T, A, B>,
    Node<T, A, B> {
        private final Vector keys;
        private final Vector downs;

        public static <T extends Exec<T>, A, B> Branch<T, A, B> read(DataInput dataInput, boolean bl, Ident<T> ident, T t, Impl<T, A, B> impl) {
            return HASkipList$Branch$.MODULE$.read(dataInput, bl, ident, t, impl);
        }

        public <T extends Exec<T>, A, B> Branch(Vector<A> keys, Vector<Var<T, Node<T, A, B>>> downs) {
            this.keys = keys;
            this.downs = downs;
        }

        public Vector<A> keys() {
            return this.keys;
        }

        public Vector<Var<T, Node<T, A, B>>> downs() {
            return this.downs;
        }

        public String toString() {
            return this.keys().mkString("Branch(", ",", ")");
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public boolean isBranch() {
            return true;
        }

        @Override
        public Leaf<T, A, B> asLeaf() {
            throw HASkipList$.MODULE$.de$sciss$lucre$data$HASkipList$$$opNotSupported();
        }

        @Override
        public Branch<T, A, B> asBranch() {
            return this;
        }

        @Override
        public Node<T, A, B> mergeRight(Node<T, A, B> sib) {
            Branch<T, A, B> bSib = sib.asBranch();
            return new Branch<T, A, B>((Vector)this.keys().$plus$plus(bSib.keys()), (Vector)this.downs().$plus$plus(bSib.downs()));
        }

        @Override
        public Node<T, A, B> borrowRight(Node<T, A, B> sib) {
            Branch<T, A, B> bSib = sib.asBranch();
            return new Branch<T, A, B>((Vector)this.keys().$colon$plus(bSib.keys().head()), (Vector)this.downs().$colon$plus(bSib.downs().head()));
        }

        @Override
        public Node<T, A, B> mergeLeft(Node<T, A, B> sib) {
            Branch<T, A, B> bSib = sib.asBranch();
            return new Branch<T, A, B>((Vector)bSib.keys().$plus$plus(this.keys()), (Vector)bSib.downs().$plus$plus(this.downs()));
        }

        @Override
        public Node<T, A, B> borrowLeft(Node<T, A, B> sib) {
            Branch<T, A, B> bSib = sib.asBranch();
            Object object = bSib.keys().last();
            Var var = (Var)bSib.downs().last();
            return new Branch<T, A, B>((Vector)this.keys().$plus$colon(object), (Vector)this.downs().$plus$colon((Object)var));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int leafSizeSum(T tx) {
            void var2_2;
            int res = 0;
            int sz = this.size();
            for (int i = 0; i < sz; ++i) {
                res += this.down(i, tx).leafSizeSum(tx);
            }
            return (int)var2_2;
        }

        @Override
        public IndexedSeq<String> printNode(boolean isRight, T tx) {
            int sz = this.size();
            int szm = sz - 1;
            Vector columns = (Vector)package$.MODULE$.Vector().tabulate(sz, (Function1 & Serializable)idx -> this.$anonfun$2(isRight, (Exec)tx, szm, BoxesRunTime.unboxToInt((Object)idx)));
            return (IndexedSeq)package$.MODULE$.Vector().tabulate(BoxesRunTime.unboxToInt((Object)((IterableOnceOps)columns.map((Function1 & Serializable)_$6 -> _$6.size())).max((Ordering)Ordering.Int$.MODULE$)), (Function1 & Serializable)row -> this.printNode$$anonfun$3(columns, BoxesRunTime.unboxToInt((Object)row)));
        }

        @Override
        public A key(int idx) {
            return (A)this.keys().apply(idx);
        }

        @Override
        public int size() {
            return this.keys().length();
        }

        public Var<T, Node<T, A, B>> downRef(int i) {
            return (Var)this.downs().apply(i);
        }

        public Node<T, A, B> down(int i, T tx) {
            return (Node)((Source)this.downs().apply(i)).apply(tx);
        }

        public Tuple2<Branch<T, A, B>, Branch<T, A, B>> split(Impl<T, A, B> list) {
            int lsz = list.arrMinSz();
            Tuple2 tuple2 = this.keys().splitAt(lsz);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Vector lKeys = (Vector)tuple2._1();
            Vector rKeys = (Vector)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)lKeys, (Object)rKeys);
            Vector lKeys2 = (Vector)tuple22._1();
            Vector rKeys2 = (Vector)tuple22._2();
            Tuple2 tuple23 = this.downs().splitAt(lsz);
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            Vector lDowns = (Vector)tuple23._1();
            Vector rDowns = (Vector)tuple23._2();
            Tuple2 tuple24 = Tuple2$.MODULE$.apply((Object)lDowns, (Object)rDowns);
            Vector lDowns2 = (Vector)tuple24._1();
            Vector rDowns2 = (Vector)tuple24._2();
            Branch<T, A, B> left = new Branch<T, A, B>(lKeys2, lDowns2);
            Branch<T, A, B> right = new Branch<T, A, B>(rKeys2, rDowns2);
            return Tuple2$.MODULE$.apply(left, right);
        }

        @Override
        public void updateDown(int i, Node<T, A, B> n, T tx) {
            ((Sink)this.downs().apply(i)).update(n, tx);
        }

        @Override
        public Branch<T, A, B> removeColumn(int idx, Impl<T, A, B> list) {
            Vector newKeys = (Vector)this.keys().patch(idx, (IterableOnce)package$.MODULE$.Vector().empty(), 1);
            Vector newDowns = (Vector)this.downs().patch(idx, (IterableOnce)package$.MODULE$.Vector().empty(), 1);
            return new Branch<T, A, B>(newKeys, newDowns);
        }

        public Branch<T, A, B> updateKey(int idx, A key) {
            Vector newKeys = this.keys().updated(idx, key);
            return new Branch<T, A, B>(newKeys, this.downs());
        }

        @Override
        public Branch<T, A, B> insertAfterSplit(int idx, A splitKey, Node<T, A, B> left, Node<T, A, B> right, Ident<T> id, T tx, Impl<T, A, B> list) {
            Vector bKeys = (Vector)this.keys().patch(idx, (IterableOnce)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{splitKey})), 0);
            Vector bDowns = (Vector)this.downs().patch(idx, (IterableOnce)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Var[]{id.newVar(left, tx, list)})), 0);
            int rightOff = idx + 1;
            ((Sink)bDowns.apply(rightOff)).update(right, tx);
            return new Branch<T, A, B>(bKeys, bDowns);
        }

        @Override
        public void write(DataOutput out, Impl<T, A, B> list) {
            int i;
            int sz = this.size();
            int sz1 = sz - 1;
            boolean isRight = this.keys().apply(sz1) == null;
            int szi = isRight ? sz1 : sz;
            out.writeByte(isRight ? 5 : 1);
            out.writeByte(sz);
            for (i = 0; i < szi; ++i) {
                list.keyFormat().write(this.keys().apply(i), out);
            }
            for (i = 0; i < sz; ++i) {
                ((Writable)this.downs().apply(i)).write(out);
            }
        }

        private final /* synthetic */ Vector $anonfun$2(boolean isRight$2, Exec tx$17, int szm$2, int idx) {
            boolean rr = isRight$2 && idx == szm$2;
            IndexedSeq<String> child = this.down(idx, tx$17).printNode(rr, tx$17);
            int childSz = ((String)child.head()).length();
            String ks = rr ? "M" : this.key(idx).toString();
            int keySz = ks.length();
            int colSz = scala.math.package$.MODULE$.max(keySz, childSz) + 2;
            String keyAdd = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(idx == this.size() - 1 ? " " : "-"), colSz - keySz);
            String bar = "|" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), colSz - 1);
            String childAdd = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), colSz - childSz);
            return (Vector)((IterableOps)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ks + keyAdd, bar}))).$plus$plus((IterableOnce)child.map((Function1 & Serializable)_$5 -> _$5 + childAdd));
        }

        private final /* synthetic */ String printNode$$anonfun$3(Vector columns$1, int row) {
            return ((IterableOnceOps)columns$1.map((Function1 & Serializable)_$7 -> (String)_$7.apply(row))).mkString("");
        }
    }

    public static interface HeadOrBranch<T extends Exec<T>, A, E> {
        public void updateDown(int var1, Node<T, A, E> var2, T var3);

        public Branch<T, A, E> insertAfterSplit(int var1, A var2, Node<T, A, E> var3, Node<T, A, E> var4, Ident<T> var5, T var6, Impl<T, A, E> var7);
    }

    private static abstract class Impl<T extends Exec<T>, A, E>
    implements HASkipList<T, A, E>,
    HeadOrBranch<T, A, E>,
    TFormat<T, Node<T, A, E>>,
    MutableImpl<T> {
        private final Ident id;
        private final boolean hasObserver;

        public <T extends Exec<T>, A, E> Impl(Ident<T> id) {
            this.id = id;
            SkipList.KeyObserver<T, A> keyObserver = this.keyObserver();
            SkipList$NoKeyObserver$ skipList$NoKeyObserver$ = SkipList$NoKeyObserver$.MODULE$;
            this.hasObserver = keyObserver == null ? skipList$NoKeyObserver$ != null : !keyObserver.equals(skipList$NoKeyObserver$);
        }

        public /* synthetic */ boolean de$sciss$lucre$Identified$$super$equals(Object x$0) {
            return super.equals(x$0);
        }

        public /* synthetic */ String de$sciss$lucre$impl$MutableImpl$$super$toString() {
            return super.toString();
        }

        public final Ident<T> id() {
            return this.id;
        }

        public abstract Var<T, Node<T, A, E>> downNode();

        public abstract SkipList.KeyObserver<T, A> keyObserver();

        public abstract void writeEntry(E var1, DataOutput var2);

        public abstract Leaf<T, A, E> newLeaf(E var1);

        public abstract Leaf<T, A, E> readLeaf(DataInput var1, boolean var2, T var3);

        public final int arrMinSz() {
            return this.minGap() + 1;
        }

        private int arrMaxSz() {
            return this.minGap() + 1 << 1;
        }

        public final void writeData(DataOutput out) {
            out.writeByte(76);
            out.writeByte(this.minGap());
            this.downNode().write(out);
        }

        @Override
        public final void clear(T tx) {
            this.downNode().update(null, tx);
        }

        public final void disposeData(T tx) {
            this.downNode().dispose(tx);
        }

        @Override
        public int size(T tx) {
            Node<T, A, E> c = this.topN(tx);
            return c == null ? 0 : c.leafSizeSum(tx) - 1;
        }

        @Override
        public final int maxGap() {
            return (this.minGap() << 1) + 1;
        }

        @Override
        public final boolean isEmpty(T tx) {
            return this.topN(tx) == null;
        }

        @Override
        public final boolean nonEmpty(T tx) {
            return !this.isEmpty(tx);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int height(T tx) {
            int n;
            Node<T, A, E> n2 = this.topN(tx);
            if (n2 == null) {
                n = 0;
            } else {
                void var3_3;
                int h = 1;
                while (n2.isBranch()) {
                    n2 = n2.asBranch().down(0, tx);
                    ++h;
                }
                n = var3_3;
            }
            return n;
        }

        @Override
        public final Option<Node<T, A, E>> top(T tx) {
            return Option$.MODULE$.apply(this.topN(tx));
        }

        public final Node<T, A, E> topN(T tx) {
            return (Node)this.downNode().apply(tx);
        }

        @Override
        public final String debugPrint(T tx) {
            return this.topN(tx).printNode(true, tx).mkString("\n");
        }

        @Override
        public final IndexedSeq<E> toIndexedSeq(T tx) {
            return (IndexedSeq)this.fillBuilder((Builder)package$.MODULE$.Vector().newBuilder(), tx);
        }

        @Override
        public final List<E> toList(T tx) {
            return (List)this.fillBuilder(package$.MODULE$.List().newBuilder(), tx);
        }

        @Override
        public final Seq<E> toSeq(T tx) {
            return (Seq)this.fillBuilder(package$.MODULE$.Seq().newBuilder(), tx);
        }

        @Override
        public final scala.collection.immutable.Set<E> toSet(T tx) {
            return (scala.collection.immutable.Set)this.fillBuilder(Set$.MODULE$.newBuilder(), tx);
        }

        private <Res> Res fillBuilder(Builder<E, Res> b, T tx) {
            Iterator<E> i = this.iterator(tx);
            while (i.hasNext()) {
                b.$plus$eq(i.next());
            }
            return (Res)b.result();
        }

        private E headImpl(Node<T, A, E> n, T tx) {
            Impl impl = this;
            Node<T, A, E> node = n;
            while (!node.isLeaf()) {
                Impl impl2 = impl;
                Node<T, A, E> node2 = node.asBranch().down(0, tx);
                impl = impl2;
                node = node2;
            }
            return node.asLeaf().entry(0);
        }

        @Override
        public final E head(T tx) {
            Node<T, A, E> n0 = this.topN(tx);
            if (n0 == null) {
                throw new NoSuchElementException("head of empty list");
            }
            return this.headImpl(n0, tx);
        }

        @Override
        public final Option<E> headOption(T tx) {
            Node<T, A, E> n0 = this.topN(tx);
            return n0 == null ? None$.MODULE$ : Some$.MODULE$.apply(this.headImpl(n0, tx));
        }

        private E lastImpl(Node<T, A, E> n, T tx) {
            Impl impl = this;
            Node<T, A, E> node = n;
            while (!node.isLeaf()) {
                Impl impl2 = impl;
                Node<T, A, E> node2 = node.asBranch().down(node.size() - 1, tx);
                impl = impl2;
                node = node2;
            }
            return node.asLeaf().entry(node.size() - 2);
        }

        @Override
        public final E last(T tx) {
            Node<T, A, E> n0 = this.topN(tx);
            if (n0 == null) {
                throw new NoSuchElementException("last of empty list");
            }
            return this.lastImpl(n0, tx);
        }

        @Override
        public final Option<E> lastOption(T tx) {
            Node<T, A, E> n0 = this.topN(tx);
            return n0 == null ? None$.MODULE$ : Some$.MODULE$.apply(this.lastImpl(n0, tx));
        }

        @Override
        public final Option<E> floor(A key, T tx) {
            Node<T, A, E> n0 = this.topN(tx);
            return n0 == null ? None$.MODULE$ : this.step$1(key, (Exec)tx, n0, null, 0, true);
        }

        @Override
        public final Option<E> ceil(A key, T tx) {
            Node<T, A, E> c = this.topN(tx);
            return c == null ? None$.MODULE$ : this.step$2(key, (Exec)tx, c, true);
        }

        @Override
        public final Tuple2<E, Object> isomorphicQuery(Function1<A, Object> compare, T tx) {
            Node<T, A, E> c = this.topN(tx);
            if (c == null) {
                throw new NoSuchElementException("isomorphicQuery on an empty list");
            }
            return this.stepRight$1((Function1)compare, (Exec)tx, c);
        }

        @Override
        public final boolean contains(A v, T tx) {
            Node<T, A, E> c = this.topN(tx);
            return c == null ? false : this.stepRight$2(v, (Exec)tx, c);
        }

        @Override
        public final int indexInNodeR(A key, Node<T, A, E> n, T tx) {
            int idx = 0;
            int sz = n.size() - 1;
            do {
                int cmp;
                if ((cmp = this.ordering().compare(key, n.key(idx), tx)) == 0) {
                    return -(idx + 1);
                }
                if (cmp >= 0) continue;
                return idx;
            } while (++idx < sz);
            return sz;
        }

        @Override
        public final int indexInNodeL(A key, Node<T, A, E> n, T tx) {
            return this.step$3(key, n, (Exec)tx, 0);
        }

        public final Option<E> addEntry(A key, E entry, T tx) {
            Option<E> option;
            Node<T, A, E> c = this.topN(tx);
            if (c == null) {
                Leaf<T, A, E> l = this.newLeaf(entry);
                this.downNode().update(l, tx);
                option = None$.MODULE$;
            } else {
                option = c.isLeaf() ? this.addToLeaf(key, entry, this, 0, this, 0, c.asLeaf(), true, tx) : this.addToBranch(key, entry, this, 0, this, 0, c.asBranch(), true, tx);
            }
            return option;
        }

        private Option<E> addToLeaf(A key, E entry, HeadOrBranch<T, A, E> pp, int ppIdx, HeadOrBranch<T, A, E> p, int pIdx, Leaf<T, A, E> l, boolean isRight, T tx) {
            Some some;
            int idx;
            int n = idx = isRight ? this.indexInNodeR(key, l, tx) : this.indexInNodeL(key, l, tx);
            if (idx < 0) {
                int idxP = -(idx + 1);
                E oldEntry = l.entry(idxP);
                if (!BoxesRunTime.equals(entry, oldEntry)) {
                    Leaf<T, A, E> lNew = l.update(idxP, entry);
                    p.updateDown(pIdx, lNew, tx);
                }
                some = Some$.MODULE$.apply(oldEntry);
            } else {
                if (l.size() == this.arrMaxSz()) {
                    Object splitKey = l.key(this.minGap());
                    Tuple2<Leaf<T, A, E>, Leaf<T, A, E>> tup = l.splitAndInsert(idx, entry, this);
                    Leaf left = (Leaf)tup._1();
                    Leaf right = (Leaf)tup._2();
                    Branch<T, A, E> pNew = p.insertAfterSplit(pIdx, splitKey, left, right, this.id(), tx, this);
                    pp.updateDown(ppIdx, pNew, tx);
                    if (this.hasObserver) {
                        this.keyObserver().keyUp(splitKey, tx);
                    }
                } else {
                    Leaf<T, A, E> lNew = l.insert(idx, entry);
                    p.updateDown(pIdx, lNew, tx);
                }
                some = None$.MODULE$;
            }
            return some;
        }

        private Option<E> addToBranch(A key, E entry, HeadOrBranch<T, A, E> pp, int ppIdx, HeadOrBranch<T, A, E> p, int pIdx, Branch<T, A, E> b, boolean isRight, T tx) {
            Node<T, A, E> c;
            boolean isRightNew;
            int pIdxNew;
            HeadOrBranch<T, A, E> pNew;
            int idxNew;
            Branch bNew;
            Impl impl = this;
            boolean bl = isRight;
            Branch branch = b;
            int n = pIdx;
            HeadOrBranch<T, A, E> headOrBranch = p;
            int n2 = ppIdx;
            HeadOrBranch<T, A, E> headOrBranch2 = pp;
            while (true) {
                int idx = bl ? impl.indexInNodeR(key, branch, tx) : impl.indexInNodeL(key, branch, tx);
                boolean found = idx < 0;
                int idxP = found ? -(idx + 1) : idx;
                bNew = branch;
                idxNew = idxP;
                pNew = headOrBranch;
                pIdxNew = n;
                int bsz = branch.size();
                boolean bl2 = isRightNew = bl && idxP == bsz - 1;
                if (!found && bsz == impl.arrMaxSz()) {
                    A splitKey = branch.key(impl.minGap());
                    Tuple2<Branch<T, A, E>, Branch<T, A, E>> tup = branch.split(impl);
                    Branch left = (Branch)tup._1();
                    Branch right = (Branch)tup._2();
                    Branch<T, A, E> pbNew = headOrBranch.insertAfterSplit(n, splitKey, left, right, impl.id(), tx, impl);
                    pNew = pbNew;
                    headOrBranch2.updateDown(n2, pbNew, tx);
                    int mns = impl.arrMinSz();
                    if (idx < mns) {
                        bNew = left;
                    } else {
                        bNew = right;
                        ++pIdxNew;
                        idxNew -= mns;
                    }
                    if (impl.hasObserver) {
                        impl.keyObserver().keyUp(splitKey, tx);
                    }
                }
                if ((c = bNew.down(idxNew, tx)).isLeaf()) break;
                Impl impl2 = impl;
                HeadOrBranch<T, A, E> headOrBranch3 = pNew;
                int n3 = pIdxNew;
                Branch branch2 = bNew;
                int n4 = idxNew;
                Branch<T, A, E> branch3 = c.asBranch();
                boolean bl3 = isRightNew;
                impl = impl2;
                headOrBranch2 = headOrBranch3;
                n2 = n3;
                headOrBranch = branch2;
                n = n4;
                branch = branch3;
                bl = bl3;
            }
            return impl.addToLeaf(key, entry, pNew, pIdxNew, bNew, idxNew, c.asLeaf(), isRightNew, tx);
        }

        @Override
        public final Impl $minus$eq(A key, T tx) {
            this.removeEntry(key, tx);
            return this;
        }

        public final Option<E> removeEntry(A key, T tx) {
            Node<T, A, E> c = this.topN(tx);
            return c == null ? None$.MODULE$ : (c.isLeaf() ? this.removeFromLeaf(key, (Sink<T, Node<T, A, E>>)this.downNode(), c.asLeaf(), true, false, tx) : this.removeFromBranch(key, (Sink<T, Node<T, A, E>>)this.downNode(), c.asBranch(), true, false, tx));
        }

        private Option<E> removeFromLeaf(A key, Sink<T, Node<T, A, E>> pDown, Leaf<T, A, E> l, boolean isRight, boolean lDirty, T tx) {
            None$ none$;
            boolean found;
            int idx = isRight ? this.indexInNodeR(key, l, tx) : this.indexInNodeL(key, l, tx);
            boolean bl = found = idx < 0;
            if (found) {
                int idxP = -(idx + 1);
                Leaf<T, A, E> lNew = l.removeColumn(idxP, this);
                pDown.update(lNew.size() > 1 ? lNew : null, tx);
                none$ = Some$.MODULE$.apply(l.entry(idxP));
            } else {
                if (lDirty) {
                    pDown.update(l.size() > 1 ? l : null, tx);
                }
                none$ = None$.MODULE$;
            }
            return none$;
        }

        private Option<E> removeFromBranchAndBubble(A key, Sink<T, Node<T, A, E>> pDown, Branch<T, A, E> b, A leafUpKey, T tx) {
            boolean bl;
            Leaf<T, A, E> leaf;
            Sink<T, Node<T, A, E>> bDown;
            Impl impl = this;
            Branch<T, A, E> branch = b;
            Sink<T, Node<T, A, E>> sink = pDown;
            while (true) {
                Sink<T, Node<T, A, E>> sink2;
                int bsz = branch.size();
                int idxP = bsz - 1;
                int mns = impl.arrMinSz();
                Node<T, A, E> c = branch.down(idxP, tx);
                int cSz = c.size();
                Branch<T, A, Object> bNew = null;
                int bDownIdx = idxP;
                Node<T, A, E> cNew = c;
                if (impl.hasObserver) {
                    impl.keyObserver().keyDown(key, tx);
                }
                if (cSz == mns) {
                    int idxPM1 = idxP - 1;
                    Node<T, A, E> cSib = branch.down(idxPM1, tx);
                    int cSibSz = cSib.size();
                    A downKey = branch.key(idxPM1);
                    if (impl.hasObserver) {
                        impl.keyObserver().keyDown(downKey, tx);
                    }
                    if (cSibSz == mns) {
                        Node bNew0 = branch.removeColumn(idxPM1, impl);
                        bNew = ((Branch)bNew0).updateKey(idxPM1, leafUpKey);
                        branch.downRef(idxPM1).dispose(tx);
                        bDownIdx = idxPM1;
                        cNew = c.mergeLeft(cSib);
                    } else {
                        A upKey = cSib.key(cSibSz - 2);
                        Branch<T, A, E> bNew0 = branch.updateKey(idxPM1, upKey);
                        bNew = bNew0.updateKey(idxP, leafUpKey);
                        if (impl.hasObserver) {
                            impl.keyObserver().keyUp(upKey, tx);
                        }
                        Var<T, Node<T, A, E>> bDown1 = branch.downRef(idxPM1);
                        bDown1.update(cSib.removeColumn(cSibSz - 1, impl), tx);
                        cNew = c.borrowLeft(cSib);
                    }
                } else {
                    bNew = branch.updateKey(idxP, leafUpKey);
                }
                if (impl.hasObserver) {
                    impl.keyObserver().keyUp(leafUpKey, tx);
                }
                if (bNew.size() > 1) {
                    sink.update(bNew, tx);
                    sink2 = bNew.downRef(bDownIdx);
                } else {
                    bNew.downRef(0).dispose(tx);
                    sink2 = bDown = sink;
                }
                if (cNew.isLeaf()) {
                    leaf = cNew.asLeaf();
                    if (cNew != c) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                Impl impl2 = impl;
                Sink<T, Node<T, A, E>> sink3 = bDown;
                Branch<T, A, E> branch2 = cNew.asBranch();
                impl = impl2;
                sink = sink3;
                branch = branch2;
            }
            return impl.removeFromLeaf(key, bDown, leaf, false, bl, tx);
        }

        private Option<E> removeFromBranch(A key, Sink<T, Node<T, A, E>> pDown, Branch<T, A, E> b, boolean isRight, boolean bDirty, T tx) {
            boolean cDirty;
            Var<T, Node<T, A, E>> bDown;
            Node<T, A, E> cNew;
            boolean isRightNew;
            Impl impl = this;
            boolean bl = bDirty;
            boolean bl2 = isRight;
            Branch<T, Object, E> branch = b;
            Sink<T, Node<T, A, E>> sink = pDown;
            while (true) {
                Var<T, Node<T, A, E>> var;
                int idx = bl2 ? impl.indexInNodeR(key, branch, tx) : impl.indexInNodeL(key, branch, tx);
                boolean found = idx < 0;
                int idxP = found ? -(idx + 1) : idx;
                int bsz = branch.size();
                int mns = impl.arrMinSz();
                Node<T, A, E> c = branch.down(idxP, tx);
                int cSz = c.size();
                if (found && cSz > mns) {
                    Object leafUpKey = this.findUpKey$1((Exec)tx, c);
                    if (impl.hasObserver) {
                        impl.keyObserver().keyDown(key, tx);
                    }
                    Branch<T, Object, E> bNew = branch.updateKey(idxP, leafUpKey);
                    if (impl.hasObserver) {
                        impl.keyObserver().keyUp(leafUpKey, tx);
                    }
                    sink.update(bNew, tx);
                    Var<T, Node<T, Object, E>> bDown2 = bNew.downRef(idxP);
                    return c.isLeaf() ? impl.removeFromLeaf(key, (Sink<T, Node<T, A, E>>)bDown2, c.asLeaf(), false, false, tx) : impl.removeFromBranchAndBubble(key, (Sink<T, Node<T, A, E>>)bDown2, c.asBranch(), (A)leafUpKey, tx);
                }
                isRightNew = bl2 && idxP == bsz - 1;
                Node<T, Object, Object> bNew = branch;
                int bDownIdx = idxP;
                cNew = c;
                if (cSz == mns) {
                    boolean bHasRight;
                    int idxP1 = idxP + 1;
                    boolean bl3 = bHasRight = idxP1 < bsz;
                    if (bHasRight) {
                        Node<T, A, E> cSib = branch.down(idxP1, tx);
                        int cSibSz = cSib.size();
                        int mergedSz = cSz + cSibSz;
                        A downKey = branch.key(idxP);
                        if (impl.hasObserver) {
                            impl.keyObserver().keyDown(downKey, tx);
                        }
                        if (mergedSz <= impl.arrMaxSz()) {
                            bNew = branch.removeColumn(idxP, impl);
                            branch.downRef(idxP).dispose(tx);
                            cNew = c.mergeRight(cSib);
                            isRightNew = bl2 && idxP == bsz - 2;
                        } else {
                            if (cSibSz <= mns) {
                                throw Scala3RunTime$.MODULE$.assertFailed();
                            }
                            A upKey = cSib.key(0);
                            bNew = branch.updateKey(idxP, upKey);
                            if (impl.hasObserver) {
                                impl.keyObserver().keyUp(upKey, tx);
                            }
                            Var<T, Node<T, A, E>> bDown1 = branch.downRef(idxP1);
                            bDown1.update(cSib.removeColumn(0, impl), tx);
                            cNew = c.borrowRight(cSib);
                        }
                    } else {
                        int idxPM1 = idxP - 1;
                        Node<T, A, E> cSib = branch.down(idxPM1, tx);
                        int cSibSz = cSib.size();
                        A downKey = branch.key(idxPM1);
                        if (impl.hasObserver) {
                            impl.keyObserver().keyDown(downKey, tx);
                        }
                        if (cSibSz == mns) {
                            bNew = branch.removeColumn(idxPM1, impl);
                            branch.downRef(idxPM1).dispose(tx);
                            bDownIdx = idxPM1;
                            cNew = c.mergeLeft(cSib);
                        } else {
                            A upKey = cSib.key(cSibSz - 2);
                            bNew = branch.updateKey(idxPM1, upKey);
                            if (impl.hasObserver) {
                                impl.keyObserver().keyUp(upKey, tx);
                            }
                            Var<T, Node<T, A, E>> bDown1 = branch.downRef(idxPM1);
                            bDown1.update(cSib.removeColumn(cSibSz - 1, impl), tx);
                            cNew = c.borrowLeft(cSib);
                        }
                    }
                }
                if (bl || bNew != branch) {
                    if (bNew.size() > 1) {
                        sink.update(bNew, tx);
                        var = bNew.downRef(bDownIdx);
                    } else {
                        bNew.downRef(0).dispose(tx);
                        var = sink;
                    }
                } else {
                    var = bNew.downRef(bDownIdx);
                }
                bDown = var;
                boolean bl4 = cDirty = cNew != c;
                if (cNew.isLeaf()) break;
                Impl impl2 = impl;
                Var<T, Node<T, A, E>> var2 = bDown;
                Branch<T, A, E> branch2 = cNew.asBranch();
                boolean bl5 = isRightNew;
                boolean bl6 = cDirty;
                impl = impl2;
                sink = var2;
                branch = branch2;
                bl2 = bl5;
                bl = bl6;
            }
            return impl.removeFromLeaf(key, (Sink<T, Node<T, A, E>>)bDown, cNew.asLeaf(), isRightNew, cDirty, tx);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Iterator<E> iterator(T tx) {
            void var2_2;
            EntryIteratorImpl i = new EntryIteratorImpl(this, tx);
            i.init();
            return var2_2;
        }

        public void write(Node<T, A, E> v, DataOutput out) {
            if (v == null) {
                out.writeByte(0);
            } else {
                v.write(out, this);
            }
        }

        public Node<T, A, E> readT(DataInput in, T tx) {
            Node<T, A, Object> node;
            byte by = in.readByte();
            switch (by) {
                case 0: {
                    node = null;
                    break;
                }
                case 1: {
                    node = HASkipList$Branch$.MODULE$.read(in, false, this.id(), tx, this);
                    break;
                }
                case 2: {
                    node = this.readLeaf(in, false, tx);
                    break;
                }
                case 5: {
                    node = HASkipList$Branch$.MODULE$.read(in, true, this.id(), tx, this);
                    break;
                }
                case 6: {
                    node = this.readLeaf(in, true, tx);
                    break;
                }
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
                }
            }
            return node;
        }

        @Override
        public void updateDown(int i, Node<T, A, E> n, T tx) {
            if (i != 0) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)i).toString());
            }
            this.downNode().update(n, tx);
        }

        @Override
        public Branch<T, A, E> insertAfterSplit(int pIdx, A splitKey, Node<T, A, E> left, Node<T, A, E> right, Ident<T> id, T tx, Impl<T, A, E> head) {
            Vector bKeys = (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{splitKey, null}));
            Vector bDowns = (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Var[]{id.newVar(left, tx, head), id.newVar(right, tx, head)}));
            return new Branch(bKeys, bDowns);
        }

        private final Object straight$1(Exec tx$8, Node n, int idx) {
            int n2 = idx;
            Node node = n;
            while (!node.isLeaf()) {
                Node c;
                Node node2 = c = node.asBranch().down(n2, tx$8);
                int n3 = c.size() - 1;
                node = node2;
                n2 = n3;
            }
            return node.asLeaf().entry(n2);
        }

        private final Option step$1(Object key$6, Exec tx$9, Node n, Node _bckNode, int _bckIdx, boolean isRight) {
            Some some;
            boolean bl = isRight;
            int n2 = _bckIdx;
            Node node = _bckNode;
            Node node2 = n;
            while (true) {
                int idx;
                int n3 = idx = bl ? this.indexInNodeR(key$6, node2, tx$9) : this.indexInNodeL(key$6, node2, tx$9);
                if (idx < 0) {
                    some = Some$.MODULE$.apply(this.straight$1(tx$9, node2, -(idx + 1)));
                    break;
                }
                Node bckNode = node;
                int bckIdx = n2;
                if (idx > 0) {
                    bckNode = node2;
                    bckIdx = idx - 1;
                }
                if (node2.isLeaf()) {
                    if (bckNode == null) {
                        some = None$.MODULE$;
                        break;
                    }
                    some = Some$.MODULE$.apply(this.straight$1(tx$9, bckNode, bckIdx));
                    break;
                }
                Node node3 = node2.asBranch().down(idx, tx$9);
                Node node4 = bckNode;
                int n4 = bckIdx;
                boolean bl2 = bl && idx == node2.size() - 1;
                node2 = node3;
                node = node4;
                n2 = n4;
                bl = bl2;
            }
            return some;
        }

        private final Option step$2(Object key$7, Exec tx$10, Node n, boolean isRight) {
            None$ none$;
            boolean bl = isRight;
            Node node = n;
            while (true) {
                boolean newRight;
                int idx = bl ? this.indexInNodeR(key$7, node, tx$10) : this.indexInNodeL(key$7, node, tx$10);
                int idxP = idx < 0 ? -(idx + 1) : idx;
                boolean bl2 = newRight = bl && idxP == node.size() - 1;
                if (node.isLeaf()) {
                    if (newRight) {
                        none$ = None$.MODULE$;
                        break;
                    }
                    none$ = Some$.MODULE$.apply(node.asLeaf().entry(idxP));
                    break;
                }
                Node node2 = node.asBranch().down(idxP, tx$10);
                boolean bl3 = newRight;
                node = node2;
                bl = bl3;
            }
            return none$;
        }

        private final int isoIndexR$1(Function1 compare$1, Node n) {
            int idx = 0;
            int sz = n.size() - 1;
            do {
                int cmp;
                if ((cmp = BoxesRunTime.unboxToInt((Object)compare$1.apply(n.key(idx)))) == 0) {
                    return -(idx + 1);
                }
                if (cmp >= 0) continue;
                return idx;
            } while (++idx < sz);
            return sz;
        }

        private final int step$4(Function1 compare$3, Node n$1, int idx) {
            int n;
            int n2 = idx;
            while (true) {
                int cmp;
                if ((cmp = BoxesRunTime.unboxToInt((Object)compare$3.apply(n$1.key(n2)))) == 0) {
                    n = -(n2 + 1);
                    break;
                }
                if (cmp < 0) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            return n;
        }

        private final int isoIndexL$1(Function1 compare$2, Node n) {
            return this.step$4(compare$2, n, 0);
        }

        private final Tuple2 stepRight$1(Function1 compare$4, Exec tx$11, Node n) {
            Tuple2 tuple2;
            Node node = n;
            while (true) {
                int idxP;
                int idx;
                boolean found = (idx = this.isoIndexR$1(compare$4, node)) < 0;
                int n2 = idxP = found ? -(idx + 1) : idx;
                if (node.isLeaf()) {
                    Leaf l = node.asLeaf();
                    if (found) {
                        tuple2 = Tuple2$.MODULE$.apply(l.entry(idxP), (Object)BoxesRunTime.boxToInteger((int)0));
                        break;
                    }
                    if (idxP == l.size() - 1) {
                        tuple2 = Tuple2$.MODULE$.apply(l.entry(idxP - 1), (Object)BoxesRunTime.boxToInteger((int)1));
                        break;
                    }
                    tuple2 = Tuple2$.MODULE$.apply(l.entry(idxP), (Object)BoxesRunTime.boxToInteger((int)-1));
                    break;
                }
                Node c = node.asBranch().down(idxP, tx$11);
                if (idxP < node.size() - 1) {
                    tuple2 = this.stepLeft$1(compare$4, tx$11, c);
                    break;
                }
                node = c;
            }
            return tuple2;
        }

        private final Tuple2 stepLeft$1(Function1 compare$5, Exec tx$12, Node n) {
            Integer n2;
            Object e;
            Node node = n;
            while (true) {
                int idxP;
                int idx;
                boolean found = (idx = this.isoIndexL$1(compare$5, node)) < 0;
                int n3 = idxP = found ? -(idx + 1) : idx;
                if (node.isLeaf()) {
                    Leaf l = node.asLeaf();
                    e = l.entry(idxP);
                    if (found) {
                        n2 = BoxesRunTime.boxToInteger((int)0);
                        break;
                    }
                    n2 = BoxesRunTime.boxToInteger((int)-1);
                    break;
                }
                node = node.asBranch().down(idxP, tx$12);
            }
            return Tuple2$.MODULE$.apply(e, (Object)n2);
        }

        private final boolean stepRight$2(Object v$1, Exec tx$13, Node n) {
            boolean bl;
            Node node = n;
            while (true) {
                int idx;
                if ((idx = this.indexInNodeR(v$1, node, tx$13)) < 0) {
                    bl = true;
                    break;
                }
                if (node.isLeaf()) {
                    bl = false;
                    break;
                }
                Node c = node.asBranch().down(idx, tx$13);
                if (idx < node.size() - 1) {
                    bl = this.stepLeft$2(v$1, tx$13, c);
                    break;
                }
                node = c;
            }
            return bl;
        }

        private final boolean stepLeft$2(Object v$2, Exec tx$14, Node n) {
            boolean bl;
            Node node = n;
            while (true) {
                int idx;
                if ((idx = this.indexInNodeL(v$2, node, tx$14)) < 0) {
                    bl = true;
                    break;
                }
                if (node.isLeaf()) {
                    bl = false;
                    break;
                }
                node = node.asBranch().down(idx, tx$14);
            }
            return bl;
        }

        private final int step$3(Object key$8, Node n$2, Exec tx$15, int idx) {
            int n;
            int n2 = idx;
            while (true) {
                int cmp;
                if ((cmp = this.ordering().compare(key$8, n$2.key(n2), tx$15)) == 0) {
                    n = -(n2 + 1);
                    break;
                }
                if (cmp < 0) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            return n;
        }

        private final Object findUpKey$1(Exec tx$16, Node n) {
            Node node = n;
            while (!node.isLeaf()) {
                node = node.asBranch().down(node.size() - 1, tx$16);
            }
            return node.key(node.size() - 2);
        }

        private final class EntryIteratorImpl
        extends IteratorImpl<E> {
            private final Impl<T, A, E> $outer;

            public EntryIteratorImpl(T tx) {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super((Impl)$outer, tx);
            }

            @Override
            public E getValue(Leaf<T, A, E> l, int idx) {
                return l.entry(idx);
            }

            @Override
            public String toString() {
                return "Iterator";
            }

            public final Impl<T, A, E> de$sciss$lucre$data$HASkipList$Impl$EntryIteratorImpl$$$outer() {
                return this.$outer;
            }
        }

        public abstract class IteratorImpl<C>
        implements Iterator<C> {
            private final T tx;
            private Leaf<T, A, E> l;
            private C nextValue;
            private boolean isRight;
            private int idx;
            private List<Tuple3<Branch<T, A, E>, Object, Object>> stack;
            private final Impl<T, A, E> $outer;

            public <C> IteratorImpl(T tx) {
                this.tx = tx;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
                this.isRight = true;
                this.idx = 0;
                this.stack = package$.MODULE$.List().empty();
            }

            public String toString() {
                return "" + this.$outer + ".iterator";
            }

            public abstract C getValue(Leaf<T, A, E> var1, int var2);

            private void pushDown(Node<T, A, E> n, int idx0, boolean r) {
                IteratorImpl iteratorImpl = this;
                boolean bl = r;
                int n2 = idx0;
                Node node = n;
                while (true) {
                    if (node.isLeaf()) break;
                    Branch b = node.asBranch();
                    iteratorImpl.stack = iteratorImpl.stack.$colon$colon((Object)Tuple3$.MODULE$.apply(b, (Object)BoxesRunTime.boxToInteger((int)(n2 + 1)), (Object)BoxesRunTime.boxToBoolean((boolean)bl)));
                    IteratorImpl iteratorImpl2 = iteratorImpl;
                    Node node2 = b.down(n2, iteratorImpl.tx);
                    int n3 = 0;
                    boolean bl2 = bl && n2 == b.size() - 1;
                    iteratorImpl = iteratorImpl2;
                    node = node2;
                    n2 = n3;
                    bl = bl2;
                }
                Leaf l2 = node.asLeaf();
                iteratorImpl.l = l2;
                iteratorImpl.idx = 0;
                iteratorImpl.isRight = bl;
                iteratorImpl.nextValue = iteratorImpl.getValue(l2, 0);
            }

            public void init() {
                Node c = this.$outer.topN(this.tx);
                if (c != null) {
                    this.pushDown(c, 0, true);
                }
            }

            public boolean hasNext() {
                return this.l != null;
            }

            /*
             * WARNING - void declaration
             */
            public C next() {
                void var1_1;
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next on empty iterator");
                }
                C res = this.nextValue;
                ++this.idx;
                if (this.idx == (this.isRight ? this.l.size() - 1 : this.l.size())) {
                    this.popUp$1();
                } else {
                    this.nextValue = this.getValue(this.l, this.idx);
                }
                return var1_1;
            }

            public final Impl<T, A, E> de$sciss$lucre$data$HASkipList$Impl$IteratorImpl$$$outer() {
                return this.$outer;
            }

            private final void popUp$1() {
                block5: {
                    boolean r;
                    Branch b;
                    int i;
                    do {
                        List tail;
                        List list;
                        Tuple3 tuple3;
                        block7: {
                            List list2;
                            block6: {
                                if (this.stack.isEmpty()) {
                                    this.l = null;
                                    this.nextValue = null;
                                    break block5;
                                }
                                list2 = this.stack;
                                if (!(list2 instanceof .colon.colon)) break block6;
                                .colon.colon colon2 = (.colon.colon)list2;
                                tuple3 = (Tuple3)colon2.head();
                                list = colon2.next$access$1();
                                if (tuple3 != null) break block7;
                            }
                            throw new MatchError(list2);
                        }
                        Branch b2 = (Branch)tuple3._1();
                        int i2 = BoxesRunTime.unboxToInt((Object)tuple3._2());
                        boolean r2 = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
                        List tail2 = list;
                        Tuple4 tuple4 = Tuple4$.MODULE$.apply((Object)b2, (Object)BoxesRunTime.boxToInteger((int)i2), (Object)BoxesRunTime.boxToBoolean((boolean)r2), (Object)tail2);
                        b = (Branch)tuple4._1();
                        i = BoxesRunTime.unboxToInt((Object)tuple4._2());
                        r = BoxesRunTime.unboxToBoolean((Object)tuple4._3());
                        this.stack = tail = (List)tuple4._4();
                    } while (i >= b.size());
                    this.pushDown(b, i, r);
                }
            }
        }
    }

    public static interface Leaf<T extends Exec<T>, A, E>
    extends Node<T, A, E> {
        public static String toString$(Leaf $this) {
            return $this.toString();
        }

        default public String toString() {
            return this.entries().mkString("Leaf(", ",", ")");
        }

        public Vector<E> entries();

        public static Object entry$(Leaf $this, int idx) {
            return $this.entry(idx);
        }

        default public E entry(int idx) {
            return (E)this.entries().apply(idx);
        }

        public Leaf<T, A, E> copy(Vector<E> var1);

        public static int size$(Leaf $this) {
            return $this.size();
        }

        @Override
        default public int size() {
            return this.entries().size();
        }

        public static boolean isLeaf$(Leaf $this) {
            return $this.isLeaf();
        }

        @Override
        default public boolean isLeaf() {
            return true;
        }

        public static boolean isBranch$(Leaf $this) {
            return $this.isBranch();
        }

        @Override
        default public boolean isBranch() {
            return false;
        }

        public static Leaf asLeaf$(Leaf $this) {
            return $this.asLeaf();
        }

        @Override
        default public Leaf<T, A, E> asLeaf() {
            return this;
        }

        public static Branch asBranch$(Leaf $this) {
            return $this.asBranch();
        }

        @Override
        default public Branch<T, A, E> asBranch() {
            throw HASkipList$.MODULE$.de$sciss$lucre$data$HASkipList$$$opNotSupported();
        }

        public static int leafSizeSum$(Leaf $this, Exec tx) {
            return $this.leafSizeSum(tx);
        }

        @Override
        default public int leafSizeSum(T tx) {
            return this.size();
        }

        public static IndexedSeq printNode$(Leaf $this, boolean isRight, Exec tx) {
            return $this.printNode(isRight, tx);
        }

        @Override
        default public IndexedSeq<String> printNode(boolean isRight, T tx) {
            int sz = this.size();
            int szm = sz - 1;
            Seq strings = (Seq)package$.MODULE$.Seq().tabulate(sz, (Function1 & Serializable)idx -> this.$anonfun$1(isRight, szm, BoxesRunTime.unboxToInt((Object)idx)));
            return (IndexedSeq)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{strings.mkString("--")}));
        }

        public static Node mergeRight$(Leaf $this, Node sib) {
            return $this.mergeRight(sib);
        }

        @Override
        default public Node<T, A, E> mergeRight(Node<T, A, E> sib) {
            Leaf<T, A, E> lSib = sib.asLeaf();
            return this.copy((Vector)this.entries().$plus$plus(lSib.entries()));
        }

        public static Node borrowRight$(Leaf $this, Node sib) {
            return $this.borrowRight(sib);
        }

        @Override
        default public Node<T, A, E> borrowRight(Node<T, A, E> sib) {
            Leaf<T, A, E> lSib = sib.asLeaf();
            return this.copy((Vector)this.entries().$colon$plus(lSib.entries().head()));
        }

        public static Node mergeLeft$(Leaf $this, Node sib) {
            return $this.mergeLeft(sib);
        }

        @Override
        default public Node<T, A, E> mergeLeft(Node<T, A, E> sib) {
            Leaf<T, A, E> lSib = sib.asLeaf();
            return this.copy((Vector)lSib.entries().$plus$plus(this.entries()));
        }

        public static Node borrowLeft$(Leaf $this, Node sib) {
            return $this.borrowLeft(sib);
        }

        @Override
        default public Node<T, A, E> borrowLeft(Node<T, A, E> sib) {
            Leaf<T, A, E> lSib = sib.asLeaf();
            Object object = lSib.entries().last();
            return this.copy((Vector)this.entries().$plus$colon(object));
        }

        public static Leaf insert$(Leaf $this, int idx, Object entry) {
            return $this.insert(idx, entry);
        }

        default public Leaf<T, A, E> insert(int idx, E entry) {
            Vector newEntries = (Vector)this.entries().patch(idx, (IterableOnce)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{entry})), 0);
            return this.copy(newEntries);
        }

        public static Leaf update$(Leaf $this, int idx, Object entry) {
            return $this.update(idx, entry);
        }

        default public Leaf<T, A, E> update(int idx, E entry) {
            Vector newEntries = (Vector)this.entries().patch(idx, (IterableOnce)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{entry})), 1);
            return this.copy(newEntries);
        }

        public static Tuple2 splitAndInsert$(Leaf $this, int idx, Object entry, Impl list) {
            return $this.splitAndInsert(idx, entry, list);
        }

        default public Tuple2<Leaf<T, A, E>, Leaf<T, A, E>> splitAndInsert(int idx, E entry, Impl<T, A, E> list) {
            Tuple2 tuple2;
            int arrMinSz = list.arrMinSz();
            Tuple2 tuple22 = this.entries().splitAt(arrMinSz);
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            Vector len0 = (Vector)tuple22._1();
            Vector ren0 = (Vector)tuple22._2();
            Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)len0, (Object)ren0);
            Vector len02 = (Vector)tuple23._1();
            Vector ren02 = (Vector)tuple23._2();
            if (idx < arrMinSz) {
                Vector len = (Vector)len02.patch(idx, (IterableOnce)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{entry})), 0);
                Leaf<T, A, E> left = this.copy(len);
                Leaf<T, A, E> right = this.copy(ren02);
                tuple2 = Tuple2$.MODULE$.apply(left, right);
            } else {
                int numL = idx - arrMinSz;
                Vector ren = (Vector)ren02.patch(numL, (IterableOnce)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{entry})), 0);
                Leaf<T, A, E> left = this.copy(len02);
                Leaf<T, A, E> right = this.copy(ren);
                tuple2 = Tuple2$.MODULE$.apply(left, right);
            }
            return tuple2;
        }

        public static Leaf removeColumn$(Leaf $this, int idx, Impl list) {
            return $this.removeColumn(idx, list);
        }

        @Override
        default public Leaf<T, A, E> removeColumn(int idx, Impl<T, A, E> list) {
            Vector newEntries = (Vector)this.entries().patch(idx, (IterableOnce)package$.MODULE$.Vector().empty(), 1);
            return this.copy(newEntries);
        }

        public static void write$(Leaf $this, DataOutput out, Impl list) {
            $this.write(out, list);
        }

        @Override
        default public void write(DataOutput out, Impl<T, A, E> list) {
            int sz = this.size();
            int sz1 = sz - 1;
            boolean isRight = this.entries().apply(sz1) == null;
            int szi = isRight ? sz1 : sz;
            out.writeByte(isRight ? 6 : 2);
            out.writeByte(sz);
            for (int i = 0; i < szi; ++i) {
                list.writeEntry(this.entries().apply(i), out);
            }
        }

        private /* synthetic */ String $anonfun$1(boolean isRight$1, int szm$1, int idx) {
            return !isRight$1 || idx < szm$1 ? this.entry(idx).toString() : "M";
        }
    }

    public static interface Map<T extends Exec<T>, A, B>
    extends SkipList.Map<T, A, B>,
    HASkipList<T, A, Tuple2<A, B>> {
    }

    private static final class MapFmt<T extends Exec<T>, A, B>
    implements WritableFormat<T, Map<T, A, B>> {
        private final SkipList.KeyObserver<T, A> keyObserver;
        private final TOrdering<T, A> ordering;
        private final TFormat<T, A> keyFormat;
        private final TFormat<T, B> valueFormat;

        public <T extends Exec<T>, A, B> MapFmt(SkipList.KeyObserver<T, A> keyObserver, TOrdering<T, A> ordering, TFormat<T, A> keyFormat, TFormat<T, B> valueFormat) {
            this.keyObserver = keyObserver;
            this.ordering = ordering;
            this.keyFormat = keyFormat;
            this.valueFormat = valueFormat;
        }

        public Map<T, A, B> readT(DataInput in, T tx) {
            return HASkipList$Map$.MODULE$.read(in, this.keyObserver, tx, this.ordering, this.keyFormat, this.valueFormat);
        }

        public String toString() {
            return "HASkipList.Map.format";
        }
    }

    private static final class MapImpl<T extends Exec<T>, A, B>
    extends Impl<T, A, Tuple2<A, B>>
    implements Map<T, A, B> {
        private final int minGap;
        private final SkipList.KeyObserver keyObserver;
        private final TOrdering ordering;
        private final TFormat keyFormat;
        private final TFormat valueFormat;
        private final Var downNode;

        public <T extends Exec<T>, A, B> MapImpl(Ident<T> id, int minGap, SkipList.KeyObserver<T, A> keyObserver, Function1<MapImpl<T, A, B>, Var<T, Node<T, A, Tuple2<A, B>>>> _downNode, TOrdering<T, A> ordering, TFormat<T, A> keyFormat, TFormat<T, B> valueFormat) {
            this.minGap = minGap;
            this.keyObserver = keyObserver;
            this.ordering = ordering;
            this.keyFormat = keyFormat;
            this.valueFormat = valueFormat;
            super(id);
            this.downNode = (Var)_downNode.apply((Object)this);
        }

        private Ident<T> id$accessor() {
            return super.id();
        }

        @Override
        public int minGap() {
            return this.minGap;
        }

        @Override
        public SkipList.KeyObserver<T, A> keyObserver() {
            return this.keyObserver;
        }

        @Override
        public TOrdering<T, A> ordering() {
            return this.ordering;
        }

        @Override
        public TFormat<T, A> keyFormat() {
            return this.keyFormat;
        }

        public TFormat<T, B> valueFormat() {
            return this.valueFormat;
        }

        @Override
        public Var<T, Node<T, A, Tuple2<A, B>>> downNode() {
            return this.downNode;
        }

        @Override
        public String toString() {
            return "SkipList.Map" + this.id$accessor();
        }

        @Override
        public Option<B> put(A key, B value, T tx) {
            return this.addEntry(key, Tuple2$.MODULE$.apply(key, value), tx).map((Function1 & Serializable)_$1 -> _$1._2());
        }

        @Override
        public Option<B> remove(A key, T tx) {
            return this.removeEntry(key, tx).map((Function1 & Serializable)_$2 -> _$2._2());
        }

        @Override
        public A firstKey(T tx) {
            return (A)((Tuple2)this.head(tx))._1();
        }

        @Override
        public A lastKey(T tx) {
            return (A)((Tuple2)this.last(tx))._1();
        }

        public MapImpl $plus$eq(Tuple2<A, B> entry, T tx) {
            this.addEntry(entry._1(), entry, tx);
            return this;
        }

        @Override
        public void writeEntry(Tuple2<A, B> entry, DataOutput out) {
            this.keyFormat().write(entry._1(), out);
            this.valueFormat().write(entry._2(), out);
        }

        @Override
        public Leaf<T, A, Tuple2<A, B>> newLeaf(Tuple2<A, B> entry) {
            Vector en = (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{entry, null}));
            return new MapLeaf(en);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Iterator<A> keysIterator(T tx) {
            void var2_2;
            KeyIteratorImpl i = new KeyIteratorImpl(this, tx);
            i.init();
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Iterator<B> valuesIterator(T tx) {
            void var2_2;
            ValueIteratorImpl i = new ValueIteratorImpl(this, tx);
            i.init();
            return var2_2;
        }

        @Override
        public Option<B> get(A key, T tx) {
            Node c = this.topN(tx);
            return c == null ? None$.MODULE$ : this.stepRight$1(key, (Exec)tx, c);
        }

        @Override
        public <B1> B1 getOrElse(A key, Function0<B1> function0, T tx) {
            return (B1)this.get(key, tx).getOrElse(function0);
        }

        @Override
        public B getOrElseUpdate(A key, Function0<B> op, T tx) {
            return (B)this.get(key, tx).getOrElse(() -> this.getOrElseUpdate$$anonfun$1(key, op, tx));
        }

        @Override
        public Leaf<T, A, Tuple2<A, B>> readLeaf(DataInput in, boolean isRight, T tx) {
            int sz = in.readByte();
            int szi = isRight ? sz - 1 : sz;
            Vector en = (Vector)package$.MODULE$.Vector().tabulate(sz, (Function1 & Serializable)i -> this.$anonfun$1(in, (Exec)tx, szi, BoxesRunTime.unboxToInt((Object)i)));
            return new MapLeaf(en);
        }

        private final Option stepRight$1(Object key$3, Exec tx$4, Node n) {
            None$ none$;
            Node node = n;
            while (true) {
                int idx;
                int idxP;
                int n2 = idxP = (idx = this.indexInNodeR(key$3, node, tx$4)) < 0 ? -(idx + 1) : idx;
                if (node.isLeaf()) {
                    if (idx < 0) {
                        none$ = Some$.MODULE$.apply(((Tuple2)node.asLeaf().entry(idxP))._2());
                        break;
                    }
                    none$ = None$.MODULE$;
                    break;
                }
                Node c = node.asBranch().down(idxP, tx$4);
                if (idxP < node.size() - 1) {
                    none$ = this.stepLeft$1(key$3, tx$4, c);
                    break;
                }
                node = c;
            }
            return none$;
        }

        private final Option stepLeft$1(Object key$4, Exec tx$5, Node n) {
            None$ none$;
            Node node = n;
            while (true) {
                int idx;
                int idxP;
                int n2 = idxP = (idx = this.indexInNodeL(key$4, node, tx$5)) < 0 ? -(idx + 1) : idx;
                if (node.isLeaf()) {
                    if (idx < 0) {
                        none$ = Some$.MODULE$.apply(((Tuple2)node.asLeaf().entry(idxP))._2());
                        break;
                    }
                    none$ = None$.MODULE$;
                    break;
                }
                node = node.asBranch().down(idxP, tx$5);
            }
            return none$;
        }

        private final Object getOrElseUpdate$$anonfun$1(Object key$5, Function0 op$1, Exec tx$6) {
            Object value = op$1.apply();
            this.put(key$5, value, tx$6);
            return value;
        }

        private final /* synthetic */ Tuple2 $anonfun$1(DataInput in$2, Exec tx$7, int szi$2, int i) {
            Tuple2 tuple2;
            if (i < szi$2) {
                Object key = this.keyFormat().readT(in$2, (Object)tx$7);
                Object value = this.valueFormat().readT(in$2, (Object)tx$7);
                tuple2 = Tuple2$.MODULE$.apply(key, value);
            } else {
                tuple2 = null;
            }
            return tuple2;
        }

        private final class KeyIteratorImpl
        extends Impl.IteratorImpl<A> {
            private final MapImpl<T, A, B> $outer;

            public KeyIteratorImpl(T tx) {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super((Impl)$outer, tx);
            }

            @Override
            public A getValue(Leaf<T, A, Tuple2<A, B>> l, int idx) {
                return l.key(idx);
            }

            @Override
            public String toString() {
                return "KeyIterator";
            }

            public final MapImpl<T, A, B> de$sciss$lucre$data$HASkipList$MapImpl$KeyIteratorImpl$$$outer() {
                return this.$outer;
            }
        }

        private final class ValueIteratorImpl
        extends Impl.IteratorImpl<B> {
            private final MapImpl<T, A, B> $outer;

            public ValueIteratorImpl(T tx) {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super((Impl)$outer, tx);
            }

            @Override
            public B getValue(Leaf<T, A, Tuple2<A, B>> l, int idx) {
                return l.entry(idx)._2();
            }

            @Override
            public String toString() {
                return "ValueIterator";
            }

            public final MapImpl<T, A, B> de$sciss$lucre$data$HASkipList$MapImpl$ValueIteratorImpl$$$outer() {
                return this.$outer;
            }
        }
    }

    private static final class MapLeaf<T extends Exec<T>, A, B>
    implements Leaf<T, A, Tuple2<A, B>> {
        private final Vector entries;

        public <T extends Exec<T>, A, B> MapLeaf(Vector<Tuple2<A, B>> entries) {
            this.entries = entries;
        }

        @Override
        public Vector<Tuple2<A, B>> entries() {
            return this.entries;
        }

        @Override
        public Leaf<T, A, Tuple2<A, B>> copy(Vector<Tuple2<A, B>> newEntries) {
            return new MapLeaf<T, A, B>(newEntries);
        }

        @Override
        public A key(int idx) {
            return (A)((Tuple2)this.entries().apply(idx))._1();
        }
    }

    public static interface Node<T extends Exec<T>, A, E> {
        public Node<T, A, E> removeColumn(int var1, Impl<T, A, E> var2);

        public int size();

        public A key(int var1);

        public void write(DataOutput var1, Impl<T, A, E> var2);

        public int leafSizeSum(T var1);

        public IndexedSeq<String> printNode(boolean var1, T var2);

        public Node<T, A, E> mergeRight(Node<T, A, E> var1);

        public Node<T, A, E> borrowRight(Node<T, A, E> var1);

        public Node<T, A, E> mergeLeft(Node<T, A, E> var1);

        public Node<T, A, E> borrowLeft(Node<T, A, E> var1);

        public boolean isLeaf();

        public boolean isBranch();

        public Leaf<T, A, E> asLeaf();

        public Branch<T, A, E> asBranch();
    }

    public static interface Set<T extends Exec<T>, A>
    extends SkipList.Set<T, A>,
    HASkipList<T, A, A> {
    }

    private static final class SetFmt<T extends Exec<T>, A>
    implements TFormat<T, Set<T, A>> {
        private final SkipList.KeyObserver<T, A> keyObserver;
        private final TOrdering<T, A> ordering;
        private final TFormat<T, A> keyFormat;

        public <T extends Exec<T>, A> SetFmt(SkipList.KeyObserver<T, A> keyObserver, TOrdering<T, A> ordering, TFormat<T, A> keyFormat) {
            this.keyObserver = keyObserver;
            this.ordering = ordering;
            this.keyFormat = keyFormat;
        }

        public Set<T, A> readT(DataInput in, T tx) {
            return HASkipList$Set$.MODULE$.read(in, this.keyObserver, tx, this.ordering, this.keyFormat);
        }

        public void write(Set<T, A> list, DataOutput out) {
            list.write(out);
        }

        public String toString() {
            return "HASkipList.Set.format";
        }
    }

    private static final class SetImpl<T extends Exec<T>, A>
    extends Impl<T, A, A>
    implements Set<T, A> {
        private final int minGap;
        private final SkipList.KeyObserver keyObserver;
        private final TOrdering ordering;
        private final TFormat keyFormat;
        private final Var downNode;

        public <T extends Exec<T>, A> SetImpl(Ident<T> id, int minGap, SkipList.KeyObserver<T, A> keyObserver, Function1<SetImpl<T, A>, Var<T, Node<T, A, A>>> _downNode, TOrdering<T, A> ordering, TFormat<T, A> keyFormat) {
            this.minGap = minGap;
            this.keyObserver = keyObserver;
            this.ordering = ordering;
            this.keyFormat = keyFormat;
            super(id);
            this.downNode = (Var)_downNode.apply((Object)this);
        }

        private Ident<T> id$accessor() {
            return super.id();
        }

        @Override
        public int minGap() {
            return this.minGap;
        }

        @Override
        public SkipList.KeyObserver<T, A> keyObserver() {
            return this.keyObserver;
        }

        @Override
        public TOrdering<T, A> ordering() {
            return this.ordering;
        }

        @Override
        public TFormat<T, A> keyFormat() {
            return this.keyFormat;
        }

        @Override
        public Var<T, Node<T, A, A>> downNode() {
            return this.downNode;
        }

        @Override
        public String toString() {
            return "SkipList.Set" + this.id$accessor();
        }

        @Override
        public boolean add(A key, T tx) {
            return this.addEntry(key, key, tx).isEmpty();
        }

        @Override
        public boolean remove(A key, T tx) {
            return this.removeEntry(key, tx).isDefined();
        }

        @Override
        public A firstKey(T tx) {
            return (A)this.head(tx);
        }

        @Override
        public A lastKey(T tx) {
            return (A)this.last(tx);
        }

        public SetImpl $plus$eq(A key, T tx) {
            this.addEntry(key, key, tx);
            return this;
        }

        @Override
        public Leaf<T, A, A> newLeaf(A key) {
            Vector lKeys = (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{key, null}));
            return new SetLeaf(lKeys);
        }

        @Override
        public void writeEntry(A key, DataOutput out) {
            this.keyFormat().write(key, out);
        }

        @Override
        public Leaf<T, A, A> readLeaf(DataInput in, boolean isRight, T tx) {
            int sz = in.readByte();
            int szi = isRight ? sz - 1 : sz;
            Vector keys = (Vector)package$.MODULE$.Vector().tabulate(sz, (Function1 & Serializable)i -> this.$anonfun$1(in, (Exec)tx, szi, BoxesRunTime.unboxToInt((Object)i)));
            return new SetLeaf(keys);
        }

        private final /* synthetic */ Object $anonfun$1(DataInput in$1, Exec tx$3, int szi$1, int i) {
            return i < szi$1 ? this.keyFormat().readT(in$1, (Object)tx$3) : null;
        }
    }

    private static final class SetLeaf<T extends Exec<T>, A>
    implements Leaf<T, A, A> {
        private final Vector entries;

        public <T extends Exec<T>, A> SetLeaf(Vector<A> entries) {
            this.entries = entries;
        }

        @Override
        public Vector<A> entries() {
            return this.entries;
        }

        @Override
        public Leaf<T, A, A> copy(Vector<A> newEntries) {
            return new SetLeaf<T, A>(newEntries);
        }

        @Override
        public A key(int idx) {
            return (A)this.entries().apply(idx);
        }
    }
}

