/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.util;

import java.util.Deque;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class InheritableThreadLocalStack<T> {
    private final Stacks<T> stacks = new Stacks();

    public boolean isEmpty() {
        return ((Deque)this.stacks.get()).isEmpty();
    }

    @Nullable
    public T peek() {
        return (T)((Deque)this.stacks.get()).peek();
    }

    @Nullable
    public T peekOrElse(@Nullable T elze) {
        T element = this.peek();
        return null != element ? element : elze;
    }

    @Nullable
    public T push(@Nullable T element) {
        ((Deque)this.stacks.get()).push(element);
        return element;
    }

    @Nullable
    public T pop() {
        Deque stack = (Deque)this.stacks.get();
        Object element = stack.pop();
        if (stack.isEmpty()) {
            this.stacks.remove();
        }
        return (T)element;
    }

    public void popIf(@Nullable T expected) {
        try {
            T got = this.pop();
            if (got != expected) {
                this.push(got);
                throw new IllegalStateException(got + " (expected " + expected + " as the top element of the inheritable thread local stack)");
            }
        }
        catch (NoSuchElementException ex) {
            throw new IllegalStateException("The inheritable thread local stack is empty!", ex);
        }
    }

    private static final class Stacks<T>
    extends InheritableThreadLocal<Deque<T>> {
        private Stacks() {
        }

        @Override
        protected Deque<T> initialValue() {
            return new LinkedList();
        }

        @Override
        protected Deque<T> childValue(Deque<T> parent) {
            LinkedList<T> child = new LinkedList<T>();
            T element = parent.peek();
            if (null != element) {
                child.push(element);
            }
            return child;
        }
    }
}

