/*
 * Decompiled with CFR 0.152.
 */
package de.pdark.decentxml;

import de.pdark.decentxml.Node;
import de.pdark.decentxml.ProcessingInstruction;
import de.pdark.decentxml.Token;
import de.pdark.decentxml.XMLParseException;
import de.pdark.decentxml.XMLSource;
import de.pdark.decentxml.XMLStringSource;

public class XMLDeclaration
extends ProcessingInstruction {
    private String versionSpace;
    private String version;
    private String versionEquals;
    private char versionQuote;
    private String encodingSpace;
    private String encoding;
    private String encodingEquals;
    private char encodingQuote;
    private String standaloneSpace;
    private boolean standalone;
    private String standaloneEquals;
    private char standaloneQuote;
    private boolean showStandaloneNo;
    private String postSpace;

    public XMLDeclaration(Token token) {
        super(token);
    }

    public XMLDeclaration(String version) {
        this(version, null, false);
    }

    public XMLDeclaration(String version, String encoding) {
        this(version, encoding, false);
    }

    public XMLDeclaration(String version, String encoding, boolean standalone) {
        super("xml", null);
        this.checkVersion(version);
        if (encoding != null && encoding.trim().length() == 0) {
            throw new IllegalArgumentException("encoding is blank");
        }
        this.versionSpace = " ";
        this.versionEquals = "=";
        this.versionQuote = (char)34;
        this.version = version;
        this.encodingSpace = " ";
        this.encodingEquals = "=";
        this.encodingQuote = (char)34;
        this.encoding = encoding;
        this.standaloneSpace = " ";
        this.standaloneEquals = "=";
        this.standaloneQuote = (char)34;
        this.standalone = standalone;
        this.postSpace = "";
        this.updateText();
    }

    protected void checkVersion(String version) {
        if (version == null || version.trim().length() == 0) {
            throw new IllegalArgumentException("version is null or blank");
        }
        if (!"1.0".equals(version) && !"1.1".equals(version)) {
            throw new IllegalArgumentException("only versions '1.0' and '1.1' are supported: [" + version + "]");
        }
    }

    public String getVersionSpace() {
        return this.versionSpace;
    }

    public XMLDeclaration setVersionSpace(String versionSpace) {
        this.checkSpace("version", versionSpace);
        this.versionSpace = versionSpace;
        this.updateText();
        return this;
    }

    protected void checkSpace(String name, String value) {
        if (value == null) {
            throw new XMLParseException("space before " + name + " field can't be null");
        }
        if (value.length() == 0) {
            throw new XMLParseException("space before " + name + " field can't be empty");
        }
        if (value.trim().length() != 0) {
            throw new XMLParseException("space before " + name + " field must contain only whitespace: [" + value + "]");
        }
    }

    public String getVersion() {
        return this.version;
    }

    public XMLDeclaration setVersion(String version) {
        this.checkVersion(version);
        this.version = version;
        this.updateText();
        return this;
    }

    public String getVersionEquals() {
        return this.versionEquals;
    }

    public XMLDeclaration setVersionEquals(String versionEquals) {
        this.checkEquals("version", versionEquals);
        this.versionEquals = versionEquals;
        this.updateText();
        return this;
    }

    protected void checkEquals(String name, String value) {
        if (value == null) {
            throw new XMLParseException("equal sign after " + name + " field can't be null");
        }
        if (value.length() == 0) {
            throw new XMLParseException("equal sign after " + name + " field can't be empty");
        }
        if (!"=".equals(value.trim())) {
            throw new XMLParseException("equal sign after " + name + " field must only contain whitespace and a single '=': [" + value + "]");
        }
    }

    public char getVersionQuote() {
        return this.versionQuote;
    }

    public XMLDeclaration setVersionQuote(char versionQuote) {
        this.checkQuote("version", versionQuote);
        this.versionQuote = versionQuote;
        this.updateText();
        return this;
    }

    private void checkQuote(String name, char value) {
        if (value != '\"' && value != '\'') {
            throw new XMLParseException("The quote for " + name + " must be '\"' or '\\'': [" + value + "]");
        }
    }

    public String getEncodingSpace() {
        return this.encodingSpace;
    }

    public XMLDeclaration setEncodingSpace(String encodingSpace) {
        this.checkSpace("encoding", encodingSpace);
        this.encodingSpace = encodingSpace;
        this.updateText();
        return this;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public XMLDeclaration setEncoding(String encoding) {
        if (encoding != null && encoding.trim().length() == 0) {
            throw new IllegalArgumentException("encoding is blank");
        }
        this.encoding = encoding;
        this.updateText();
        return this;
    }

    public String getEncodingEquals() {
        return this.encodingEquals;
    }

    public XMLDeclaration setEncodingEquals(String encodingEquals) {
        this.checkEquals("encoding", encodingEquals);
        this.encodingEquals = encodingEquals;
        this.updateText();
        return this;
    }

    public char getEncodingQuote() {
        return this.encodingQuote;
    }

    public XMLDeclaration setEncodingQuote(char encodingQuote) {
        this.encodingQuote = encodingQuote;
        this.updateText();
        return this;
    }

    public String getStandaloneSpace() {
        return this.standaloneSpace;
    }

    public XMLDeclaration setStandaloneSpace(String standaloneSpace) {
        this.checkSpace("standalone", standaloneSpace);
        this.standaloneSpace = standaloneSpace;
        this.updateText();
        return this;
    }

    public boolean isStandalone() {
        return this.standalone;
    }

    public XMLDeclaration setStandalone(boolean standalone) {
        this.standalone = standalone;
        this.updateText();
        return this;
    }

    public String getStandaloneEquals() {
        return this.standaloneEquals;
    }

    public XMLDeclaration setStandaloneEquals(String standaloneEquals) {
        this.checkEquals("standalone", standaloneEquals);
        this.standaloneEquals = standaloneEquals;
        this.updateText();
        return this;
    }

    public char getStandaloneQuote() {
        return this.standaloneQuote;
    }

    public XMLDeclaration setStandaloneQuote(char standaloneQuote) {
        this.standaloneQuote = standaloneQuote;
        this.updateText();
        return this;
    }

    public boolean isShowStandaloneNo() {
        return this.showStandaloneNo;
    }

    public XMLDeclaration setShowStandaloneNo(boolean showStandaloneNo) {
        this.showStandaloneNo = showStandaloneNo;
        this.updateText();
        return this;
    }

    public String getPostSpace() {
        return this.postSpace;
    }

    public XMLDeclaration setPostSpace(String postSpace) {
        if (postSpace == null) {
            postSpace = "";
        } else if (postSpace.trim().length() != 0) {
            throw new XMLParseException("Space after the last field must not contain anything but whitespace");
        }
        this.postSpace = postSpace;
        this.updateText();
        return this;
    }

    protected void updateText() {
        this.setText(this.buildText(this.version, this.encoding, this.standalone));
    }

    protected String buildText(String version, String encoding, boolean standalone) {
        StringBuilder buffer = new StringBuilder(32);
        buffer.append(this.versionSpace);
        buffer.append("version");
        buffer.append(this.versionEquals);
        buffer.append(this.versionQuote);
        buffer.append(version);
        buffer.append(this.versionQuote);
        String s = encoding;
        if (s != null) {
            buffer.append(this.encodingSpace);
            buffer.append("encoding");
            buffer.append(this.encodingEquals);
            buffer.append(this.encodingQuote);
            buffer.append(s);
            buffer.append(this.encodingQuote);
        }
        String string = standalone ? "yes" : (s = this.showStandaloneNo ? "no" : null);
        if (s != null) {
            buffer.append(this.standaloneSpace);
            buffer.append("standalone");
            buffer.append(this.standaloneEquals);
            buffer.append(this.standaloneQuote);
            buffer.append(s);
            buffer.append(this.standaloneQuote);
        }
        buffer.append(this.postSpace);
        return buffer.toString();
    }

    public static boolean isXMLDeclaration(ProcessingInstruction pi) {
        return "xml".equalsIgnoreCase(pi.getTarget());
    }

    public static XMLDeclaration parseXMLDeclaration(ProcessingInstruction pi) {
        XMLDeclaration decl = new XMLDeclaration("1.0");
        decl.parseXMLDeclaration(pi.getValue());
        return decl;
    }

    protected void parseXMLDeclaration(String text) {
        XMLStringSource source = new XMLStringSource(text);
        if (!text.startsWith("<?xml")) {
            throw new XMLParseException("Expected '<?xml'", source, 0);
        }
        int end = text.length() - 2;
        if (!text.endsWith("?>")) {
            throw new XMLParseException("Expected '?>'", source, end);
        }
        this.version = null;
        this.encoding = null;
        this.standalone = false;
        boolean sawStandalone = false;
        for (int pos = 5; pos < end; ++pos) {
            char c;
            String attrName;
            if (!Character.isWhitespace(text.charAt(pos))) {
                throw new XMLParseException("Expecting whitespace between attributes of XML declaration", source, pos);
            }
            int spaceStart = pos;
            while (pos < end && Character.isWhitespace(text.charAt(pos))) {
                ++pos;
            }
            if (pos == end) {
                this.postSpace = text.substring(spaceStart, pos);
                break;
            }
            char startChar = text.charAt(pos);
            if (startChar == 'v') {
                attrName = "version";
                this.expect(source, pos, "version");
                if (this.version != null) {
                    throw new XMLParseException("Found a second version attribute", source, pos);
                }
                this.versionSpace = text.substring(spaceStart, pos);
                pos += 7;
            } else if (startChar == 'e') {
                attrName = "encoding";
                this.expect(source, pos, "encoding");
                if (this.encoding != null) {
                    throw new XMLParseException("Found a second encoding attribute", source, pos);
                }
                if (this.version == null) {
                    throw new XMLParseException("Version must be before encoding", source, pos);
                }
                this.encodingSpace = text.substring(spaceStart, pos);
                pos += 8;
            } else if (startChar == 's') {
                attrName = "standalone";
                this.expect(source, pos, "standalone");
                if (sawStandalone) {
                    throw new XMLParseException("Found a second standalone attribute", source, pos);
                }
                sawStandalone = true;
                this.standaloneSpace = text.substring(spaceStart, pos);
                pos += 10;
            } else {
                throw new XMLParseException("Expected 'version', 'encoding' or 'standalone'", source, pos);
            }
            spaceStart = pos;
            while (pos < end && Character.isWhitespace(text.charAt(pos))) {
                ++pos;
            }
            if (pos == end || text.charAt(pos) != '=') {
                throw new XMLParseException("Expected '=' after " + attrName, source, pos);
            }
            ++pos;
            while (pos < end && Character.isWhitespace(text.charAt(pos))) {
                ++pos;
            }
            if (pos == end) {
                throw new XMLParseException("Expected value for " + attrName, source, pos);
            }
            if (startChar == 'v') {
                this.versionEquals = text.substring(spaceStart, pos);
            } else if (startChar == 'e') {
                this.encodingEquals = text.substring(spaceStart, pos);
            } else if (startChar == 's') {
                this.standaloneEquals = text.substring(spaceStart, pos);
            }
            char quoteChar = text.charAt(pos);
            if (quoteChar != '\"' && quoteChar != '\'') {
                throw new XMLParseException("Expected single or double quotes around value of " + attrName + " but found '" + quoteChar + "' (" + Integer.toString(quoteChar, 16) + ")", source, pos);
            }
            char otherQuoteChar = quoteChar == '\"' ? (char)'\'' : '\"';
            int valueStart = ++pos;
            while (pos < end && (c = text.charAt(pos)) != quoteChar) {
                if (c == otherQuoteChar) {
                    throw new XMLParseException("Quote mismatch: Expected [" + quoteChar + "], found [" + c + "]", source, pos);
                }
                ++pos;
            }
            if (pos == end) {
                throw new XMLParseException("Missing closing quote after value for " + attrName, source, pos);
            }
            String value = text.substring(valueStart, pos);
            if (value.trim().length() == 0) {
                throw new XMLParseException("Value for " + attrName + " is empty", source, valueStart - 1);
            }
            if (startChar == 'v') {
                try {
                    this.checkVersion(value);
                }
                catch (IllegalArgumentException e) {
                    throw new XMLParseException(e.getMessage(), e).setSource(source, valueStart - 1);
                }
                this.version = value;
                this.versionQuote = quoteChar;
                continue;
            }
            if (startChar != 'e') continue;
            this.encoding = value;
            this.encodingQuote = quoteChar;
        }
        if (this.version == null) {
            throw new XMLParseException("Missing version attribute", source, 0);
        }
        this.updateText();
    }

    private void expect(XMLSource source, int pos, String expected) {
        int end = Math.min(pos + expected.length(), source.length());
        String s = source.substring(pos, end);
        if (!expected.equals(s)) {
            throw new XMLParseException("Expected '" + expected + "' but found '" + s + "'", source, pos);
        }
    }

    public XMLDeclaration createClone() {
        return new XMLDeclaration(this.version);
    }

    public XMLDeclaration copy(Node orig) {
        super.copy(orig);
        XMLDeclaration other = (XMLDeclaration)orig;
        this.encoding = other.encoding;
        this.encodingEquals = other.encodingEquals;
        this.encodingQuote = other.encodingQuote;
        this.encodingSpace = other.encodingSpace;
        this.postSpace = other.postSpace;
        this.showStandaloneNo = other.showStandaloneNo;
        this.standalone = other.standalone;
        this.standaloneEquals = other.standaloneEquals;
        this.standaloneQuote = other.standaloneQuote;
        this.standaloneSpace = other.standaloneSpace;
        this.version = other.version;
        this.versionEquals = other.versionEquals;
        this.versionQuote = other.versionQuote;
        this.versionSpace = other.versionSpace;
        return this;
    }

    public XMLDeclaration copy() {
        return (XMLDeclaration)super.copy();
    }
}

