/*
 * Decompiled with CFR 0.152.
 */
package de.pco.example;

import de.pco.sdk.enums.BildField;
import java.awt.Component;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.TableCellEditor;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class MetadataTableEditor
extends AbstractCellEditor
implements TableCellEditor {
    private JTextField textTF = new JTextField();
    private JCheckBox checkboxCB = null;
    private JSpinner spinnerS = null;
    private JComboBox comboboxCB = null;
    private int requestedRow = -1;

    public MetadataTableEditor() {
        this.textTF.setDocument(new PlainDocument(){

            @Override
            public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
                int LIMIT = 40;
                if (str == null) {
                    return;
                }
                if (this.getLength() + str.length() <= 40) {
                    super.insertString(offset, str, attr);
                }
            }
        });
        this.checkboxCB = new JCheckBox();
        this.comboboxCB = new JComboBox();
        this.spinnerS = new JSpinner();
    }

    @Override
    public Object getCellEditorValue() {
        BildField enumValue = BildField.values()[this.requestedRow];
        if (BildField.isBooleanField((BildField)enumValue)) {
            return this.checkboxCB.isSelected();
        }
        if (BildField.isEnumField((BildField)enumValue)) {
            return this.comboboxCB.getSelectedItem();
        }
        if (BildField.isTextField((BildField)enumValue)) {
            return this.textTF.getText();
        }
        return this.spinnerS.getValue();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        BildField enumValue = BildField.values()[row];
        this.requestedRow = row;
        if (BildField.isBooleanField((BildField)enumValue)) {
            this.checkboxCB.setSelected((Boolean)value);
            return this.checkboxCB;
        }
        if (BildField.isEnumField((BildField)enumValue)) {
            while (this.comboboxCB.getItemCount() != 0) {
                this.comboboxCB.removeItemAt(0);
            }
            int count = 0;
            for (Object object : BildField.getEnumFieldValues((BildField)enumValue)) {
                this.comboboxCB.insertItemAt(object, this.comboboxCB.getItemCount());
                if (object.equals(value)) {
                    this.comboboxCB.setSelectedIndex(count);
                }
                ++count;
            }
            return this.comboboxCB;
        }
        if (BildField.isTextField((BildField)enumValue)) {
            this.textTF.setText(value.toString());
            return this.textTF;
        }
        Comparable min = BildField.getMinValue((BildField)enumValue);
        Comparable max = BildField.getMaxValue((BildField)enumValue);
        Object step = BildField.getStepValue((BildField)enumValue);
        SpinnerNumberModel snm = null;
        JSpinner.NumberEditor editor = null;
        if (value instanceof Double) {
            snm = new SpinnerNumberModel((Double)value, (Double)min, (Double)max, (Double)step);
            this.spinnerS = new JSpinner(snm);
            editor = new JSpinner.NumberEditor(this.spinnerS, "0.0########");
        } else {
            snm = new SpinnerNumberModel(Integer.parseInt(value.toString()), Integer.parseInt(min.toString()), Integer.parseInt(max.toString()), Integer.parseInt(step.toString()));
            this.spinnerS = new JSpinner(snm);
            editor = new JSpinner.NumberEditor(this.spinnerS, "#");
        }
        JFormattedTextField textField = editor.getTextField();
        textField.setHorizontalAlignment(2);
        this.spinnerS.setEditor(editor);
        return this.spinnerS;
    }
}

