/*
 * Decompiled with CFR 0.152.
 */
package de.number42.subsampling_pdf_decoder;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.pdf.PdfRenderer;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import com.davemorrissey.labs.subscaleview.decoder.ImageDecoder;
import java.io.File;

@TargetApi(value=21)
public class PDFDecoder
implements ImageDecoder {
    private float scale;
    private int position;
    private File file;

    public PDFDecoder(int position, File file, float scale) {
        this.file = file;
        this.scale = scale;
        this.position = position;
    }

    public Bitmap decode(Context context, Uri uri) throws Exception {
        ParcelFileDescriptor descriptor = ParcelFileDescriptor.open((File)this.file, (int)0x10000000);
        PdfRenderer renderer = new PdfRenderer(descriptor);
        PdfRenderer.Page page = renderer.openPage(this.position);
        Bitmap bitmap = Bitmap.createBitmap((int)((int)((double)((float)page.getWidth() * this.scale) + 0.5)), (int)((int)((float)page.getHeight() * this.scale + 0.5f)), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        page.render(bitmap, null, null, 1);
        page.close();
        renderer.close();
        descriptor.close();
        return bitmap;
    }
}

