/*
 * Decompiled with CFR 0.152.
 */
package de.number42.subsampling_pdf_decoder;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.pdf.PdfRenderer;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import com.davemorrissey.labs.subscaleview.decoder.ImageRegionDecoder;
import java.io.File;
import java.io.IOException;

@TargetApi(value=21)
public class PDFRegionDecoder
implements ImageRegionDecoder {
    private PdfRenderer renderer;
    private float scale;
    private int position;
    private PdfRenderer.Page page;
    private ParcelFileDescriptor descriptor;
    private File file;

    public PDFRegionDecoder(int position, File file, float scale) {
        this.file = file;
        this.scale = scale;
        this.position = position;
    }

    public Point init(Context context, Uri uri) throws Exception {
        this.descriptor = ParcelFileDescriptor.open((File)this.file, (int)0x10000000);
        this.renderer = new PdfRenderer(this.descriptor);
        this.page = this.renderer.openPage(this.position);
        return new Point((int)((float)this.page.getWidth() * this.scale + 0.5f), (int)((float)this.page.getHeight() * this.scale + 0.5f));
    }

    public Bitmap decodeRegion(Rect rect, int sampleSize) {
        int bitmapWidth = rect.width() / sampleSize;
        int bitmapHeight = rect.height() / sampleSize;
        Bitmap bitmap = Bitmap.createBitmap((int)bitmapWidth, (int)bitmapHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Matrix matrix = new Matrix();
        matrix.setScale(this.scale / (float)sampleSize, this.scale / (float)sampleSize);
        matrix.postTranslate((float)(-rect.left / sampleSize), (float)(-rect.top / sampleSize));
        this.page.render(bitmap, null, matrix, 1);
        return bitmap;
    }

    public boolean isReady() {
        return true;
    }

    public void recycle() {
        this.page.close();
        this.renderer.close();
        try {
            this.descriptor.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

