/*
 * Decompiled with CFR 0.152.
 */
package de.muenchen.refarch.integration.s3.client.repository;

import de.muenchen.refarch.integration.s3.application.port.in.FolderOperationsInPort;
import de.muenchen.refarch.integration.s3.client.domain.model.FileMetadata;
import de.muenchen.refarch.integration.s3.client.exception.DocumentStorageClientErrorException;
import de.muenchen.refarch.integration.s3.client.exception.DocumentStorageException;
import de.muenchen.refarch.integration.s3.client.exception.DocumentStorageServerErrorException;
import de.muenchen.refarch.integration.s3.client.repository.DocumentStorageFolderRepository;
import de.muenchen.refarch.integration.s3.client.repository.mapper.FileMetadataMapper;
import de.muenchen.refarch.integration.s3.domain.exception.FileSystemAccessException;
import de.muenchen.refarch.integration.s3.domain.model.FilesMetadataInFolder;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public class DocumentStorageFolderJavaRepository
implements DocumentStorageFolderRepository {
    private final FolderOperationsInPort folderOperationsInPort;
    private final FileMetadataMapper fileMetadataMapper;

    public void deleteFolder(String pathToFolder) throws DocumentStorageClientErrorException, DocumentStorageServerErrorException, DocumentStorageException {
        try {
            this.folderOperationsInPort.deleteFolder(pathToFolder);
        }
        catch (FileSystemAccessException e) {
            throw new DocumentStorageException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public Set<String> getAllFilesInFolderRecursively(String pathToFolder) throws DocumentStorageClientErrorException, DocumentStorageServerErrorException, DocumentStorageException {
        try {
            return this.folderOperationsInPort.getAllFilesInFolderRecursively(pathToFolder).pathToFiles();
        }
        catch (FileSystemAccessException e) {
            throw new DocumentStorageException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public List<FileMetadata> getMetadataOfAllFilesInFolderRecursively(String pathToFolder) throws DocumentStorageClientErrorException, DocumentStorageServerErrorException, DocumentStorageException {
        try {
            FilesMetadataInFolder filesMetadataInFolder = this.folderOperationsInPort.getMetadataOfAllFilesInFolderRecursively(pathToFolder);
            return this.fileMetadataMapper.map(filesMetadataInFolder.files());
        }
        catch (FileSystemAccessException e) {
            throw new DocumentStorageException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public Map<String, Long> getAllFileSizesInFolderRecursively(String pathToFolder) throws DocumentStorageClientErrorException, DocumentStorageServerErrorException, DocumentStorageException {
        try {
            return this.folderOperationsInPort.getAllFileSizesInFolderRecursively(pathToFolder).fileSizes();
        }
        catch (FileSystemAccessException e) {
            throw new DocumentStorageException(e.getMessage(), (Exception)((Object)e));
        }
    }

    @Generated
    public DocumentStorageFolderJavaRepository(FolderOperationsInPort folderOperationsInPort, FileMetadataMapper fileMetadataMapper) {
        this.folderOperationsInPort = folderOperationsInPort;
        this.fileMetadataMapper = fileMetadataMapper;
    }
}

