/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.commons.exec;

import de.mklinger.commons.exec.CmdUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NullFile
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(NullFile.class);
    private File file;
    private boolean temporaryFile;

    public NullFile() throws IOException {
        this(NullFile.getNativeNull());
    }

    protected NullFile(File nativeNull) throws IOException {
        if (nativeNull != null) {
            LOG.debug("Using native null device: {}", (Object)nativeNull);
            this.file = nativeNull;
            this.temporaryFile = false;
        } else {
            LOG.warn("Using temporary file as simulated null device");
            this.file = File.createTempFile("null", ".null");
            this.file.deleteOnExit();
            this.temporaryFile = true;
        }
    }

    private static File getNativeNull() {
        File nativeNull = null;
        if (CmdUtil.isWindows()) {
            nativeNull = new File("nul");
        } else {
            nativeNull = new File("/dev/null");
            if (!nativeNull.exists() || !nativeNull.canWrite()) {
                return null;
            }
        }
        return nativeNull;
    }

    public File getFile() {
        return this.file;
    }

    public void cleanup() {
        if (this.temporaryFile) {
            this.file.delete();
        }
    }

    @Override
    public void close() {
        this.cleanup();
    }
}

