/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.commons.exec;

import de.mklinger.commons.exec.CmdException;

public class CmdOutputException
extends CmdException {
    private static final long serialVersionUID = 1L;
    private final String output;
    private final boolean stdoutIncluded;
    private final boolean stderrIncluded;

    public CmdOutputException(CmdException cause, String output, boolean stdoutIncluded, boolean stderrIncluded) {
        super(cause);
        this.output = output;
        this.stdoutIncluded = stdoutIncluded;
        this.stderrIncluded = stderrIncluded;
    }

    public String getOutput() {
        return this.output;
    }

    public boolean isStdoutIncluded() {
        return this.stdoutIncluded;
    }

    public boolean isStderrIncluded() {
        return this.stderrIncluded;
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        StringBuilder sb = new StringBuilder(message.length() + this.output.length() + 25);
        sb.append(message);
        sb.append("\nOutput (");
        if (this.stdoutIncluded) {
            sb.append("stdout");
        }
        if (this.stderrIncluded) {
            if (this.stdoutIncluded) {
                sb.append("+");
            }
            sb.append("stderr");
        }
        sb.append("):\n");
        sb.append(this.output);
        return sb.toString();
    }
}

