/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.commons.exec.docker;

import de.mklinger.commons.exec.CmdException;
import de.mklinger.commons.exec.CmdOutputException;
import de.mklinger.commons.exec.CmdOutputUtil;
import de.mklinger.commons.exec.docker.DockerCmdBuilder;
import de.mklinger.commons.exec.docker.DockerMachine;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DockerNetworks {
    public static void createAttachable(String name) {
        try {
            CmdOutputUtil.executeForOutput(((DockerCmdBuilder)((DockerCmdBuilder)new DockerCmdBuilder("network", "create").arg("--attachable")).arg(name)).dockerMachine(DockerMachine.getDockerMachine()));
        }
        catch (CmdException e) {
            throw new DockerException("Error creating docker network", (Exception)((Object)e));
        }
    }

    public static void rm(String nameOrId) {
        try {
            CmdOutputUtil.executeForOutput(((DockerCmdBuilder)new DockerCmdBuilder("network", "rm").arg(nameOrId)).dockerMachine(DockerMachine.getDockerMachine()));
        }
        catch (CmdException e) {
            throw new DockerException("Error removing docker network", (Exception)((Object)e));
        }
    }

    public static boolean exists(String nameOrId) {
        for (DockerNetwork network : DockerNetworks.ls()) {
            if (!network.getName().equals(nameOrId) && !network.getNetworkId().equals(nameOrId)) continue;
            return true;
        }
        return false;
    }

    public static List<DockerNetwork> ls() {
        String networksOutput;
        try {
            networksOutput = CmdOutputUtil.executeForStdout(new DockerCmdBuilder("network", "ls").dockerMachine(DockerMachine.getDockerMachine()));
        }
        catch (CmdException e) {
            throw new DockerException("Error getting docker networks", (Exception)((Object)e));
        }
        ArrayList<DockerNetwork> networks = new ArrayList<DockerNetwork>();
        StringTokenizer st = new StringTokenizer(networksOutput, "\n");
        boolean firstLine = true;
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            if (firstLine) {
                firstLine = false;
                continue;
            }
            networks.add(DockerNetwork.parseLsLine(line));
        }
        return networks;
    }

    public static class DockerException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private String output;

        private DockerException(String message, Exception cause) {
            super(message, cause);
            if (cause instanceof CmdOutputException) {
                this.output = ((CmdOutputException)cause).getOutput();
            }
        }

        public boolean containsOutput(String s) {
            return this.output != null && this.output.contains(s);
        }
    }

    public static class DockerNetwork {
        private final String networkId;
        private final String name;
        private final String driver;
        private final String scope;
        private static final Pattern LS_LINE_PATTERN = Pattern.compile("([a-f0-9]+)\\s+([^\\s]+)\\s+([^\\s]+)\\s+([^\\s]+)\\s*");

        public DockerNetwork(String networkId, String name, String driver, String scope) {
            this.networkId = networkId;
            this.name = name;
            this.driver = driver;
            this.scope = scope;
        }

        public static DockerNetwork parseLsLine(String line) {
            Matcher matcher = LS_LINE_PATTERN.matcher(line);
            if (!matcher.matches()) {
                throw new IllegalArgumentException();
            }
            return new DockerNetwork(matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(4));
        }

        public String getNetworkId() {
            return this.networkId;
        }

        public String getName() {
            return this.name;
        }

        public String getDriver() {
            return this.driver;
        }

        public String getScope() {
            return this.scope;
        }
    }
}

