/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.commons.exec.docker;

import de.mklinger.commons.exec.CmdSettings;
import de.mklinger.commons.exec.docker.DockerCmdBuilderBase;
import de.mklinger.commons.exec.docker.Volume;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DockerCreateCmdBuilderBase<B extends DockerCreateCmdBuilderBase<B>>
extends DockerCmdBuilderBase<B> {
    private final String image;
    private List<Volume> volumes;

    public DockerCreateCmdBuilderBase(String repository, String tag, String dockerCommand) {
        this(DockerCreateCmdBuilderBase.toImage(repository, tag), dockerCommand);
    }

    private static String toImage(String repository, String tag) {
        DockerCreateCmdBuilderBase.requireNonEmpty(repository);
        if (tag != null && !tag.isEmpty()) {
            return repository + ":" + tag;
        }
        return repository;
    }

    public DockerCreateCmdBuilderBase(String image, String dockerCommand) {
        super(dockerCommand);
        this.image = DockerCreateCmdBuilderBase.requireNonEmpty(image);
    }

    public B name(String name) {
        return (B)((Object)((DockerCreateCmdBuilderBase)((DockerCreateCmdBuilderBase)this.arg("--name")).arg(DockerCreateCmdBuilderBase.requireNonEmpty(name))));
    }

    public B cidFile(Path cidFile) {
        return (B)((Object)((DockerCreateCmdBuilderBase)((DockerCreateCmdBuilderBase)this.arg("--cidfile")).arg(cidFile.toString())));
    }

    public B environment(String name) {
        return (B)this.environment(name, null);
    }

    public B environment(String name, String value) {
        String envArg = value == null ? name : name + "=" + value;
        return (B)((Object)((DockerCreateCmdBuilderBase)((DockerCreateCmdBuilderBase)this.arg("-e")).arg(envArg)));
    }

    public B publish(int hostPort, int containerPort) {
        return this.publish(null, hostPort, containerPort, null);
    }

    public B publish(int hostPort, int containerPort, String protocol) {
        return this.publish(null, hostPort, containerPort, protocol);
    }

    public B publish(int containerPort) {
        return this.publish(null, 0, containerPort, null);
    }

    public B publish(int containerPort, String protocol) {
        return this.publish(null, 0, containerPort, protocol);
    }

    public B publish(String ip, int hostPort, int containerPort) {
        return this.publish(ip, hostPort, containerPort, null);
    }

    public B publish(String ip, int hostPort, int containerPort, String protocol) {
        StringBuilder publishArg = new StringBuilder();
        if (ip != null) {
            publishArg.append(ip);
            publishArg.append(':');
        }
        if (hostPort > 0) {
            publishArg.append(hostPort);
            publishArg.append(':');
        }
        if (containerPort <= 0) {
            throw new IllegalArgumentException("Invalid container port: " + containerPort);
        }
        publishArg.append(containerPort);
        if (protocol != null) {
            publishArg.append('/');
            publishArg.append(protocol);
        }
        return (B)((Object)((DockerCreateCmdBuilderBase)((DockerCreateCmdBuilderBase)this.arg("-p")).arg(publishArg.toString())));
    }

    public B network(String network) {
        return (B)((Object)((DockerCreateCmdBuilderBase)((DockerCreateCmdBuilderBase)this.arg("--network")).arg(DockerCreateCmdBuilderBase.requireNonEmpty(network))));
    }

    public B networkAlias(String networkAlias) {
        return (B)((Object)((DockerCreateCmdBuilderBase)((DockerCreateCmdBuilderBase)this.arg("--network-alias")).arg(DockerCreateCmdBuilderBase.requireNonEmpty(networkAlias))));
    }

    public B volume(String hostPathOrVolume, String containerPath) {
        return this.volume(hostPathOrVolume, containerPath, null);
    }

    public B volume(String hostPathOrVolume, String containerPath, String options) {
        Objects.requireNonNull(hostPathOrVolume);
        Objects.requireNonNull(containerPath);
        if (this.volumes == null) {
            this.volumes = new ArrayList<Volume>();
        }
        if (options != null && !options.isEmpty()) {
            this.volumes.add(new Volume(hostPathOrVolume, containerPath, options));
        } else {
            this.volumes.add(new Volume(hostPathOrVolume, containerPath));
        }
        return (B)((Object)((DockerCreateCmdBuilderBase)this.getBuilder()));
    }

    @Override
    public CmdSettings toCmdSettings() {
        CmdSettings cmdSettings = super.toCmdSettings();
        if (this.volumes != null) {
            boolean isDockerMachine = this.getDockerMachine() != null;
            for (Volume volume : this.volumes) {
                cmdSettings.getCommand().add("-v");
                cmdSettings.getCommand().add(volume.toArgString(isDockerMachine));
            }
        }
        cmdSettings.getCommand().add(this.image);
        return cmdSettings;
    }
}

