/*
 * Decompiled with CFR 0.152.
 */
package de.mannodermaus.rxbonjour.broadcast;

import android.content.Context;
import android.net.wifi.WifiManager;
import android.os.Bundle;
import de.mannodermaus.rxbonjour.broadcast.BonjourBroadcast;
import de.mannodermaus.rxbonjour.broadcast.BonjourBroadcastBuilder;
import de.mannodermaus.rxbonjour.exc.BroadcastFailed;
import de.mannodermaus.rxbonjour.exc.StaleContextException;
import de.mannodermaus.rxbonjour.internal.BonjourSchedulers;
import de.mannodermaus.rxbonjour.model.BonjourEvent;
import de.mannodermaus.rxbonjour.model.BonjourService;
import de.mannodermaus.rxbonjour.utils.SupportUtils;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceInfo;
import rx.Emitter;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.android.MainThreadSubscription;
import rx.functions.Action1;

final class SupportBonjourBroadcast
extends BonjourBroadcast<SupportUtils> {
    private static final String LOCK_TAG = "RxBonjourBroadcast";

    protected SupportBonjourBroadcast(BonjourBroadcastBuilder builder) {
        super(builder);
    }

    @Override
    protected SupportUtils createUtils() {
        return SupportUtils.get();
    }

    @Override
    public Observable<BonjourEvent> start(Context context) {
        final WeakReference<Context> weakContext = new WeakReference<Context>(context);
        return Observable.create((Action1)new Action1<Emitter<BonjourEvent>>(){

            public void call(Emitter<BonjourEvent> emitter) {
                Context context = (Context)weakContext.get();
                if (context == null) {
                    emitter.onError((Throwable)new StaleContextException());
                    return;
                }
                WifiManager wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
                final WifiManager.MulticastLock lock = wifiManager.createMulticastLock(SupportBonjourBroadcast.LOCK_TAG);
                lock.setReferenceCounted(true);
                lock.acquire();
                try {
                    BonjourService bonjourService = SupportBonjourBroadcast.this.createBonjourService(context);
                    final ServiceInfo jmdnsService = SupportBonjourBroadcast.this.createJmdnsService(bonjourService);
                    final JmDNS jmdns = ((SupportUtils)SupportBonjourBroadcast.this.utils).getManager(context);
                    emitter.setSubscription((Subscription)new MainThreadSubscription(){

                        protected void onUnsubscribe() {
                            jmdns.unregisterService(jmdnsService);
                            ((SupportUtils)SupportBonjourBroadcast.this.utils).decrementSubscriberCount();
                            lock.release();
                            Observable cleanUpObservable = Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Void>(){

                                public void call(Subscriber<? super Void> subscriber) {
                                    ((SupportUtils)SupportBonjourBroadcast.this.utils).closeIfNecessary();
                                    subscriber.unsubscribe();
                                }
                            });
                            cleanUpObservable.compose(BonjourSchedulers.cleanupSchedulers()).subscribe();
                        }
                    });
                    jmdns.registerService(jmdnsService);
                    ((SupportUtils)SupportBonjourBroadcast.this.utils).incrementSubscriberCount();
                    emitter.onNext((Object)new BonjourEvent(BonjourEvent.Type.ADDED, bonjourService));
                }
                catch (IOException e) {
                    emitter.onError((Throwable)new BroadcastFailed(SupportBonjourBroadcast.class, SupportBonjourBroadcast.this.type));
                }
            }
        }, (Emitter.BackpressureMode)Emitter.BackpressureMode.LATEST);
    }

    private ServiceInfo createJmdnsService(BonjourService serviceInfo) {
        int txtRecordCount = serviceInfo.getTxtRecordCount();
        Bundle txtRecordBundle = serviceInfo.getTxtRecords();
        HashMap<String, String> txtRecordMap = new HashMap<String, String>(txtRecordCount);
        if (txtRecordBundle.size() > 0) {
            for (String key : txtRecordBundle.keySet()) {
                txtRecordMap.put(key, txtRecordBundle.getString(key));
            }
        }
        return ServiceInfo.create((String)serviceInfo.getType(), (String)serviceInfo.getName(), (int)serviceInfo.getPort(), (int)0, (int)0, (boolean)true, txtRecordMap);
    }

    static BonjourBroadcastBuilder newBuilder(String type) {
        return new SupportBonjourBroadcastBuilder(type);
    }

    private static final class SupportBonjourBroadcastBuilder
    extends BonjourBroadcastBuilder {
        private static final String SUFFIX = ".local.";

        protected SupportBonjourBroadcastBuilder(String type) {
            super(type.endsWith(SUFFIX) ? type : type + SUFFIX);
        }

        public BonjourBroadcast build() {
            return new SupportBonjourBroadcast(this);
        }
    }
}

