/*
 * Decompiled with CFR 0.152.
 */
package de.mannodermaus.gradle.plugins.junit5.internal.providers;

import com.android.build.gradle.api.BaseVariant;
import com.android.builder.model.SourceProvider;
import de.mannodermaus.gradle.plugins.junit5.internal.extensions.BaseVariantExtKt;
import de.mannodermaus.gradle.plugins.junit5.internal.extensions.LoggerExtKt;
import de.mannodermaus.gradle.plugins.junit5.internal.providers.DirectoryProvider;
import de.mannodermaus.gradle.plugins.junit5.internal.providers.KotlinDirectoryProviderKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.tasks.KotlinCompile;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0016\u0010\u000b\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\t0\t0\bH\u0016J\u001e\u0010\r\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\t0\t0\b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0016\u0010\u000f\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\t0\t0\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/mannodermaus/gradle/plugins/junit5/internal/providers/KotlinDirectoryProvider;", "Lde/mannodermaus/gradle/plugins/junit5/internal/providers/DirectoryProvider;", "project", "Lorg/gradle/api/Project;", "variant", "Lcom/android/build/gradle/api/BaseVariant;", "(Lorg/gradle/api/Project;Lcom/android/build/gradle/api/BaseVariant;)V", "classFoldersOf", "", "Ljava/io/File;", "mainClassDirectories", "mainSourceDirectories", "kotlin.jvm.PlatformType", "sourceFoldersOf", "testClassDirectories", "testSourceDirectories", "android-junit5"})
public final class KotlinDirectoryProvider
implements DirectoryProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final BaseVariant variant;

    public KotlinDirectoryProvider(@NotNull Project project, @NotNull BaseVariant variant) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        this.project = project;
        this.variant = variant;
    }

    @Override
    @NotNull
    public Set<File> mainSourceDirectories() {
        return this.sourceFoldersOf(this.variant);
    }

    @Override
    @NotNull
    public Set<File> testSourceDirectories() {
        return this.sourceFoldersOf((BaseVariant)BaseVariantExtKt.getUnitTestVariant(this.variant));
    }

    @Override
    @NotNull
    public Set<File> mainClassDirectories() {
        return this.classFoldersOf(this.variant);
    }

    @Override
    @NotNull
    public Set<File> testClassDirectories() {
        return this.classFoldersOf((BaseVariant)BaseVariantExtKt.getUnitTestVariant(this.variant));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<File> sourceFoldersOf(BaseVariant variant) {
        void $this$flatMapTo$iv$iv;
        List list = variant.getSourceSets();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"variant.sourceSets");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            SourceProvider it = (SourceProvider)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            Set set = KotlinDirectoryProviderKt.access$getKotlin(it).getSrcDirs();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"it.kotlin.srcDirs");
            Iterable list$iv$iv = set;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final Set<File> classFoldersOf(BaseVariant variant) {
        Set set;
        Task kotlinTask = (Task)this.project.getTasks().findByName(KotlinDirectoryProviderKt.access$getKotlinTaskName(variant));
        if (kotlinTask != null) {
            set = SetsKt.setOfNotNull((Object)((KotlinCompile)kotlinTask).getDestinationDirectory().getAsFile().getOrNull());
        } else {
            Logger logger = this.project.getLogger();
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"project.logger");
            LoggerExtKt.agpLog(logger, LogLevel.WARN, "The kotlin-android plugin is currently applied after android-junit5! To guarantee full compatibility, please declare it above the JUnit 5 plugin.");
            set = SetsKt.setOf((Object)new File(this.project.getBuildDir(), Intrinsics.stringPlus((String)"tmp/kotlin-classes/", (Object)variant.getName())));
        }
        return set;
    }

    @Override
    @NotNull
    public Set<File> classDirectories() {
        return DirectoryProvider.DefaultImpls.classDirectories(this);
    }

    @Override
    @NotNull
    public Set<File> sourceDirectories() {
        return DirectoryProvider.DefaultImpls.sourceDirectories(this);
    }
}

