/*
 * Decompiled with CFR 0.152.
 */
package de.jjohannes.gradle.javamodules;

import de.jjohannes.gradle.javamodules.ExtraModuleInfoPluginExtension;
import de.jjohannes.gradle.javamodules.ExtraModuleInfoTransform;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.util.VersionNumber;

public class ExtraModuleInfoPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        if (VersionNumber.parse((String)project.getGradle().getGradleVersion()).compareTo(VersionNumber.parse((String)"6.4-rc-1")) < 0) {
            throw new RuntimeException("This plugin requires Gradle 6.4+");
        }
        ExtraModuleInfoPluginExtension extension = (ExtraModuleInfoPluginExtension)project.getObjects().newInstance(ExtraModuleInfoPluginExtension.class, new Object[0]);
        project.getExtensions().add(ExtraModuleInfoPluginExtension.class, "extraJavaModuleInfo", (Object)extension);
        project.getPlugins().withType(JavaPlugin.class).configureEach(javaPlugin -> this.configureTransform(project, extension));
    }

    private void configureTransform(Project project, ExtraModuleInfoPluginExtension extension) {
        Attribute artifactType = Attribute.of((String)"artifactType", String.class);
        Attribute javaModule = Attribute.of((String)"javaModule", Boolean.class);
        project.getConfigurations().matching(this::isResolvingJavaPluginConfiguration).all(c -> c.getAttributes().attribute(javaModule, (Object)true));
        ((ArtifactTypeDefinition)project.getDependencies().getArtifactTypes().getByName("jar")).getAttributes().attribute(javaModule, (Object)false);
        project.getDependencies().registerTransform(ExtraModuleInfoTransform.class, t -> {
            t.parameters(p -> {
                p.setModuleInfo(extension.getModuleInfo());
                p.setAutomaticModules(extension.getAutomaticModules());
            });
            t.getFrom().attribute(artifactType, (Object)"jar").attribute(javaModule, (Object)false);
            t.getTo().attribute(artifactType, (Object)"jar").attribute(javaModule, (Object)true);
        });
    }

    private boolean isResolvingJavaPluginConfiguration(Configuration configuration) {
        if (!configuration.isCanBeResolved()) {
            return false;
        }
        return configuration.getName().endsWith("compileClasspath".substring(1)) || configuration.getName().endsWith("runtimeClasspath".substring(1)) || configuration.getName().endsWith("annotationProcessor".substring(1));
    }
}

