/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.image;

import java.io.IOException;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public class ImageMetadata {
    private IIOMetadata[] imageMetadata;
    private IIOMetadata streamMetadata;

    public static ImageMetadata createFromImageReader(ImageReader imageReader) throws IOException {
        IIOMetadata[] iIOMetadataArray = new IIOMetadata[imageReader.getNumImages(true)];
        int n = 0;
        while (n < iIOMetadataArray.length) {
            iIOMetadataArray[n] = imageReader.getImageMetadata(n);
            ++n;
        }
        return new ImageMetadata(imageReader.getStreamMetadata(), iIOMetadataArray);
    }

    protected ImageMetadata() {
    }

    public ImageMetadata(IIOMetadata iIOMetadata, IIOMetadata[] iIOMetadataArray) {
        this.streamMetadata = iIOMetadata;
        this.imageMetadata = iIOMetadataArray;
    }

    public Node getAsTree(String string) {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("root");
        if (this.streamMetadata != null) {
            iIOMetadataNode.appendChild(this.streamMetadata.getAsTree(string));
        }
        int n = 0;
        while (n < this.imageMetadata.length) {
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode(String.valueOf(n));
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            iIOMetadataNode2.appendChild(this.imageMetadata[n].getAsTree(string));
            ++n;
        }
        return iIOMetadataNode;
    }

    public IIOMetadata[] getImageMetadata() {
        return this.imageMetadata;
    }

    public String getNativeMetadataFormatName() {
        return this.imageMetadata[0].getNativeMetadataFormatName();
    }

    public IIOMetadata getStreamMetadata() {
        return this.streamMetadata;
    }

    protected void setImageMetadata(IIOMetadata[] iIOMetadataArray) {
        this.imageMetadata = iIOMetadataArray;
    }

    protected void setStreamMetadata(IIOMetadata iIOMetadata) {
        this.streamMetadata = iIOMetadata;
    }
}

