/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.image;

import de.intarsys.cwt.image.IImage;
import de.intarsys.cwt.image.IImageContainer;
import de.intarsys.cwt.image.IImageEntry;
import de.intarsys.tools.attribute.AttributeMap;
import java.io.IOException;
import java.lang.ref.SoftReference;

public abstract class ImageEntry
implements IImageEntry {
    private final IImageContainer container;
    private final AttributeMap attributes = new AttributeMap();
    private SoftReference delegate;

    protected ImageEntry(IImageContainer iImageContainer) {
        this.container = iImageContainer;
    }

    public final Object getAttribute(Object object) {
        return this.attributes.get(object);
    }

    @Override
    public IImageContainer getContainer() {
        return this.container;
    }

    protected synchronized IImage getDelegate() {
        IImage iImage = null;
        if (this.delegate != null) {
            iImage = (IImage)this.delegate.get();
        }
        if (iImage == null) {
            try {
                iImage = this.loadContent();
            }
            catch (Exception exception) {
                iImage = this.getErrorImage(exception);
            }
            this.delegate = new SoftReference<IImage>(iImage);
        }
        return iImage;
    }

    protected abstract IImage getErrorImage(Exception var1);

    @Override
    public int getHeight() {
        return this.getDelegate().getHeight();
    }

    @Override
    public int getWidth() {
        return this.getDelegate().getWidth();
    }

    protected abstract IImage loadContent() throws IOException;

    public final Object removeAttribute(Object object) {
        return this.attributes.remove(object);
    }

    public final Object setAttribute(Object object, Object object2) {
        return this.attributes.put(object, object2);
    }
}

