/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.less;

import com.inet.lib.less.ColorUtils;
import com.inet.lib.less.CssFormatter;
import com.inet.lib.less.Expression;
import com.inet.lib.less.LessException;
import com.inet.lib.less.Operation;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.bind.DatatypeConverter;

class UrlUtils {
    UrlUtils() {
    }

    @Nonnull
    static String removeQuote(@Nonnull String str) {
        char ch;
        if (str.length() > 1 && ((ch = str.charAt(0)) == '\'' || ch == '\"') && str.charAt(str.length() - 1) == ch) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    static void svgGradient(CssFormatter formatter, List<Expression> parameters) {
        String gradientDirection;
        if (parameters.size() < 3) {
            throw new LessException("error evaluating function `svg-gradient expects direction, start_color [start_position], [color position,]..., end_color ");
        }
        String direction = parameters.get(0).stringValue(formatter);
        String gradientType = "linear";
        String rectangleDimension = "x=\"0\" y=\"0\" width=\"1\" height=\"1\"";
        switch (direction) {
            case "to bottom": {
                gradientDirection = "x1=\"0%\" y1=\"0%\" x2=\"0%\" y2=\"100%\"";
                break;
            }
            case "to right": {
                gradientDirection = "x1=\"0%\" y1=\"0%\" x2=\"100%\" y2=\"0%\"";
                break;
            }
            case "to bottom right": {
                gradientDirection = "x1=\"0%\" y1=\"0%\" x2=\"100%\" y2=\"100%\"";
                break;
            }
            case "to top right": {
                gradientDirection = "x1=\"0%\" y1=\"100%\" x2=\"100%\" y2=\"0%\"";
                break;
            }
            case "ellipse": 
            case "ellipse at center": {
                gradientType = "radial";
                gradientDirection = "cx=\"50%\" cy=\"50%\" r=\"75%\"";
                rectangleDimension = "x=\"-50\" y=\"-50\" width=\"101\" height=\"101\"";
                break;
            }
            default: {
                throw new LessException("error evaluating function `svg-gradient`: svg-gradient direction must be 'to bottom', 'to right', 'to bottom right', 'to top right' or 'ellipse at center'");
            }
        }
        StringBuilder builder = new StringBuilder("<?xml version=\"1.0\" ?><svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" width=\"100%\" height=\"100%\" viewBox=\"0 0 1 1\" preserveAspectRatio=\"none\">");
        builder.append('<').append(gradientType).append("Gradient id=\"gradient\" gradientUnits=\"userSpaceOnUse\" ").append(gradientDirection).append('>');
        for (int i = 1; i < parameters.size(); ++i) {
            double position;
            double color;
            Expression param = parameters.get(i).unpack(formatter);
            if (param.getClass() == Operation.class && ((Operation)param).getOperator() == ' ') {
                ArrayList<Expression> operands = ((Operation)param).getOperands();
                color = UrlUtils.getColor(operands.get(0), formatter);
                position = ColorUtils.getPercent(operands.get(1), formatter);
            } else {
                color = UrlUtils.getColor(param, formatter);
                position = (double)(i - 1) / ((double)parameters.size() - 2.0);
            }
            builder.append("<stop offset=\"");
            if ((position *= 100.0) == (double)((int)position)) {
                builder.append((int)position);
            } else {
                builder.append(formatter.getFormat().format(position));
            }
            builder.append("%\" stop-color=\"");
            formatter.addOutput();
            formatter.appendColor(color, null);
            builder.append(formatter.releaseOutput());
            builder.append('\"');
            double alpha = ColorUtils.alpha(color);
            if (alpha < 1.0) {
                builder.append(" stop-opacity=\"" + alpha).append('\"');
            }
            builder.append("/>");
        }
        builder.append("</").append(gradientType).append("Gradient><rect ").append(rectangleDimension).append(" fill=\"url(#gradient)\" /></svg>");
        byte[] bytes = builder.toString().getBytes(StandardCharsets.UTF_8);
        formatter.append("url('data:image/svg+xml;base64,");
        formatter.append(DatatypeConverter.printBase64Binary((byte[])bytes));
        formatter.append("')");
    }

    static double getColor(Expression param, CssFormatter formatter) throws LessException {
        switch (param.getDataType(formatter)) {
            case 4: 
            case 5: {
                return param.doubleValue(formatter);
            }
        }
        throw new LessException("Not a color: " + param);
    }

    static void dataUri(CssFormatter formatter, String relativeURL, String urlString, String type) throws IOException {
        int count;
        InputStream input;
        URL url = new URL(formatter.getBaseURL(), relativeURL);
        String urlStr = UrlUtils.removeQuote(urlString);
        url = new URL(url, urlStr);
        try {
            input = url.openStream();
        }
        catch (Exception e) {
            formatter.append("url(").append(urlString).append(')');
            return;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((count = input.read(data, 0, data.length)) > 0) {
            buffer.write(data, 0, count);
        }
        input.close();
        byte[] bytes = buffer.toByteArray();
        if (bytes.length >= 32768) {
            formatter.append("url(").append(urlString).append(')');
        } else {
            UrlUtils.dataUri(formatter, bytes, urlStr, type);
        }
    }

    static void dataUri(CssFormatter formatter, byte[] bytes, String urlStr, String type) {
        if (type == null) {
            switch (urlStr.substring(urlStr.lastIndexOf(46) + 1)) {
                case "gif": {
                    type = "image/gif;base64";
                    break;
                }
                case "png": {
                    type = "image/png;base64";
                    break;
                }
                case "jpg": 
                case "jpeg": {
                    type = "image/jpeg;base64";
                    break;
                }
                default: {
                    type = "text/html";
                    break;
                }
            }
        } else {
            type = UrlUtils.removeQuote(type);
        }
        if (type.endsWith("base64")) {
            formatter.append("url(\"data:").append(type).append(',');
            formatter.append(DatatypeConverter.printBase64Binary((byte[])bytes));
            formatter.append("\")");
        } else {
            formatter.append("url(\"data:").append(type).append(',');
            UrlUtils.appendEncode(formatter, bytes);
            formatter.append("\")");
        }
    }

    private static void appendEncode(CssFormatter formatter, byte[] bytes) {
        block3: for (byte b : bytes) {
            if (b >= 97 && b <= 122 || b >= 65 && b <= 90 || b >= 48 && b <= 57) {
                formatter.append((char)b);
                continue;
            }
            switch (b) {
                case 42: 
                case 45: 
                case 46: 
                case 95: {
                    formatter.append((char)b);
                    continue block3;
                }
                default: {
                    formatter.append('%');
                    formatter.append(Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16)));
                    formatter.append(Character.toUpperCase(Character.forDigit(b & 0xF, 16)));
                }
            }
        }
    }
}

