/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.less;

import com.inet.lib.less.ParameterOutOfBoundsException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class RegExp {
    private static final Pattern REPLACEMENT_BACKSLASH = Pattern.compile("\\\\");
    private static final String REPLACEMENT_BACKSLASH_FOR_JAVA = "\\\\\\\\";
    private static final Pattern REPLACEMENT_DOLLAR_AMPERSAND = Pattern.compile("((?:^|\\G|[^$])(?:\\$\\$)*)\\$&");
    private static final String REPLACEMENT_DOLLAR_AMPERSAND_FOR_JAVA = "$1\\$0";
    private static final Pattern REPLACEMENT_DOLLAR_APOSTROPHE = Pattern.compile("(?:^|[^$])(?:\\$\\$)*\\$[`']");
    private static final Pattern REPLACEMENT_DOLLAR_DOLLAR = Pattern.compile("\\$\\$");
    private static final String REPLACEMENT_DOLLAR_DOLLAR_FOR_JAVA = "\\\\\\$";
    private boolean global;
    private final Pattern pattern;

    RegExp(String pattern, String flags) throws ParameterOutOfBoundsException {
        int patternFlags = 1;
        block5: for (int i = 0; i < flags.length(); ++i) {
            char flag = flags.charAt(i);
            switch (flag) {
                case 'g': {
                    this.global = true;
                    continue block5;
                }
                case 'i': {
                    patternFlags |= 0x42;
                    continue block5;
                }
                case 'm': {
                    patternFlags |= 8;
                    continue block5;
                }
                default: {
                    throw new ParameterOutOfBoundsException();
                }
            }
        }
        this.pattern = Pattern.compile(pattern, patternFlags);
    }

    public String replace(String input, String replacement) throws ParameterOutOfBoundsException {
        replacement = REPLACEMENT_BACKSLASH.matcher(replacement).replaceAll(REPLACEMENT_BACKSLASH_FOR_JAVA);
        if (REPLACEMENT_DOLLAR_APOSTROPHE.matcher(replacement = REPLACEMENT_DOLLAR_AMPERSAND.matcher(replacement).replaceAll(REPLACEMENT_DOLLAR_AMPERSAND_FOR_JAVA)).find()) {
            throw new ParameterOutOfBoundsException();
        }
        replacement = REPLACEMENT_DOLLAR_DOLLAR.matcher(replacement).replaceAll(REPLACEMENT_DOLLAR_DOLLAR_FOR_JAVA);
        Matcher matcher = this.pattern.matcher(input);
        return this.global ? matcher.replaceAll(replacement) : matcher.replaceFirst(replacement);
    }
}

