/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.transitions;

import de.flapdoodle.embed.process.config.store.Package;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.distribution.PackageResolver;
import de.flapdoodle.embed.process.transitions.PackageOfDistribution;
import de.flapdoodle.reverse.StateID;
import de.flapdoodle.reverse.naming.HasLabel;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="PackageOfDistribution", generator="Immutables")
public final class ImmutablePackageOfDistribution
extends PackageOfDistribution {
    private final String transitionLabel;
    private final PackageResolver packageResolver;
    private final StateID<Distribution> distribution;
    private final StateID<Package> destination;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePackageOfDistribution(Builder builder) {
        this.packageResolver = builder.packageResolver;
        if (builder.transitionLabel != null) {
            this.initShim.transitionLabel(builder.transitionLabel);
        }
        if (builder.distribution != null) {
            this.initShim.distribution((StateID<Distribution>)builder.distribution);
        }
        if (builder.destination != null) {
            this.initShim.destination((StateID<Package>)builder.destination);
        }
        this.transitionLabel = this.initShim.transitionLabel();
        this.distribution = this.initShim.distribution();
        this.destination = this.initShim.destination();
        this.initShim = null;
    }

    private ImmutablePackageOfDistribution(String transitionLabel, PackageResolver packageResolver, StateID<Distribution> distribution, StateID<Package> destination) {
        this.transitionLabel = transitionLabel;
        this.packageResolver = packageResolver;
        this.distribution = distribution;
        this.destination = destination;
        this.initShim = null;
    }

    @Override
    public String transitionLabel() {
        InitShim shim = this.initShim;
        return shim != null ? shim.transitionLabel() : this.transitionLabel;
    }

    @Override
    protected PackageResolver packageResolver() {
        return this.packageResolver;
    }

    @Override
    protected StateID<Distribution> distribution() {
        InitShim shim = this.initShim;
        return shim != null ? shim.distribution() : this.distribution;
    }

    @Override
    public StateID<Package> destination() {
        InitShim shim = this.initShim;
        return shim != null ? shim.destination() : this.destination;
    }

    public final ImmutablePackageOfDistribution withTransitionLabel(String value) {
        String newValue = Objects.requireNonNull(value, "transitionLabel");
        if (this.transitionLabel.equals(newValue)) {
            return this;
        }
        return new ImmutablePackageOfDistribution(newValue, this.packageResolver, this.distribution, this.destination);
    }

    public final ImmutablePackageOfDistribution withPackageResolver(PackageResolver value) {
        if (this.packageResolver == value) {
            return this;
        }
        PackageResolver newValue = Objects.requireNonNull(value, "packageResolver");
        return new ImmutablePackageOfDistribution(this.transitionLabel, newValue, this.distribution, this.destination);
    }

    public final ImmutablePackageOfDistribution withDistribution(StateID<Distribution> value) {
        if (this.distribution == value) {
            return this;
        }
        StateID<Distribution> newValue = Objects.requireNonNull(value, "distribution");
        return new ImmutablePackageOfDistribution(this.transitionLabel, this.packageResolver, newValue, this.destination);
    }

    public final ImmutablePackageOfDistribution withDestination(StateID<Package> value) {
        if (this.destination == value) {
            return this;
        }
        StateID<Package> newValue = Objects.requireNonNull(value, "destination");
        return new ImmutablePackageOfDistribution(this.transitionLabel, this.packageResolver, this.distribution, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePackageOfDistribution && this.equalTo(0, (ImmutablePackageOfDistribution)another);
    }

    private boolean equalTo(int synthetic, ImmutablePackageOfDistribution another) {
        return this.transitionLabel.equals(another.transitionLabel) && this.packageResolver.equals(another.packageResolver) && this.distribution.equals(another.distribution) && this.destination.equals(another.destination);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.transitionLabel.hashCode();
        h += (h << 5) + this.packageResolver.hashCode();
        h += (h << 5) + this.distribution.hashCode();
        h += (h << 5) + this.destination.hashCode();
        return h;
    }

    public String toString() {
        return "PackageOfDistribution{transitionLabel=" + this.transitionLabel + ", packageResolver=" + this.packageResolver + ", distribution=" + this.distribution + ", destination=" + this.destination + "}";
    }

    public static ImmutablePackageOfDistribution copyOf(PackageOfDistribution instance) {
        if (instance instanceof ImmutablePackageOfDistribution) {
            return (ImmutablePackageOfDistribution)instance;
        }
        return ImmutablePackageOfDistribution.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PackageOfDistribution", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_PACKAGE_RESOLVER = 1L;
        private long initBits = 1L;
        private String transitionLabel;
        private PackageResolver packageResolver;
        private StateID<Distribution> distribution;
        private StateID<Package> destination;

        private Builder() {
        }

        public final Builder from(PackageOfDistribution instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(HasLabel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PackageOfDistribution instance;
            long bits = 0L;
            if (object instanceof PackageOfDistribution) {
                instance = (PackageOfDistribution)object;
                this.destination(instance.destination());
                this.distribution(instance.distribution());
                this.packageResolver(instance.packageResolver());
                if ((bits & 1L) == 0L) {
                    this.transitionLabel(instance.transitionLabel());
                    bits |= 1L;
                }
            }
            if (object instanceof HasLabel) {
                instance = (HasLabel)object;
                if ((bits & 1L) == 0L) {
                    this.transitionLabel(instance.transitionLabel());
                    bits |= 1L;
                }
            }
        }

        public final Builder transitionLabel(String transitionLabel) {
            this.transitionLabel = Objects.requireNonNull(transitionLabel, "transitionLabel");
            return this;
        }

        public final Builder packageResolver(PackageResolver packageResolver) {
            this.packageResolver = Objects.requireNonNull(packageResolver, "packageResolver");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder distribution(StateID<Distribution> distribution) {
            this.distribution = Objects.requireNonNull(distribution, "distribution");
            return this;
        }

        public final Builder destination(StateID<Package> destination) {
            this.destination = Objects.requireNonNull(destination, "destination");
            return this;
        }

        public ImmutablePackageOfDistribution build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePackageOfDistribution(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("packageResolver");
            }
            return "Cannot build PackageOfDistribution, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="PackageOfDistribution", generator="Immutables")
    private final class InitShim {
        private byte transitionLabelBuildStage = 0;
        private String transitionLabel;
        private byte distributionBuildStage = 0;
        private StateID<Distribution> distribution;
        private byte destinationBuildStage = 0;
        private StateID<Package> destination;

        private InitShim() {
        }

        String transitionLabel() {
            if (this.transitionLabelBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.transitionLabelBuildStage == 0) {
                this.transitionLabelBuildStage = (byte)-1;
                this.transitionLabel = Objects.requireNonNull(ImmutablePackageOfDistribution.super.transitionLabel(), "transitionLabel");
                this.transitionLabelBuildStage = 1;
            }
            return this.transitionLabel;
        }

        void transitionLabel(String transitionLabel) {
            this.transitionLabel = transitionLabel;
            this.transitionLabelBuildStage = 1;
        }

        StateID<Distribution> distribution() {
            if (this.distributionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.distributionBuildStage == 0) {
                this.distributionBuildStage = (byte)-1;
                this.distribution = Objects.requireNonNull(ImmutablePackageOfDistribution.super.distribution(), "distribution");
                this.distributionBuildStage = 1;
            }
            return this.distribution;
        }

        void distribution(StateID<Distribution> distribution) {
            this.distribution = distribution;
            this.distributionBuildStage = 1;
        }

        StateID<Package> destination() {
            if (this.destinationBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.destinationBuildStage == 0) {
                this.destinationBuildStage = (byte)-1;
                this.destination = Objects.requireNonNull(ImmutablePackageOfDistribution.super.destination(), "destination");
                this.destinationBuildStage = 1;
            }
            return this.destination;
        }

        void destination(StateID<Package> destination) {
            this.destination = destination;
            this.destinationBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.transitionLabelBuildStage == -1) {
                attributes.add("transitionLabel");
            }
            if (this.distributionBuildStage == -1) {
                attributes.add("distribution");
            }
            if (this.destinationBuildStage == -1) {
                attributes.add("destination");
            }
            return "Cannot build PackageOfDistribution, attribute initializers form cycle " + attributes;
        }
    }
}

