/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.hash;

import de.flapdoodle.types.Try;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;

public class Hasher {
    private final MessageDigest digest;

    private Hasher(MessageDigest digest) {
        this.digest = digest;
    }

    public Hasher update(String content, Charset charset) {
        this.digest.update(content.getBytes(charset));
        return this;
    }

    public Hasher update(String content) {
        return this.update(content, StandardCharsets.UTF_8);
    }

    public Hasher update(byte[] content) {
        this.digest.update(content);
        return this;
    }

    public Hasher update(ByteBuffer content) {
        this.digest.update(content);
        return this;
    }

    public String hashAsString() {
        return Hasher.byteArrayToHex(this.digest.digest());
    }

    public static Hasher instance() {
        return new Hasher((MessageDigest)Try.get(() -> MessageDigest.getInstance("SHA-256")));
    }

    public static Hasher md5Instance() {
        return new Hasher((MessageDigest)Try.get(() -> MessageDigest.getInstance("MD5")));
    }

    private static String byteArrayToHex(byte[] a) {
        StringBuilder sb = new StringBuilder(a.length * 2);
        for (byte b : a) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }
}

