/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.io;

import de.flapdoodle.embed.process.io.StreamProcessor;
import java.util.function.Consumer;

public class ListeningStreamProcessor
implements StreamProcessor {
    private final StreamProcessor delegate;
    private final Consumer<String> lineListener;
    private final StringBuilder buffer = new StringBuilder();

    public ListeningStreamProcessor(StreamProcessor delegate, Consumer<String> lineListener) {
        this.delegate = delegate;
        this.lineListener = lineListener;
    }

    @Override
    public void process(String block) {
        this.buffer.append(block);
        this.parseLines();
        this.delegate.process(block);
    }

    private void parseLines() {
        int newLine;
        do {
            String content;
            if ((newLine = (content = this.buffer.toString()).indexOf(10)) == -1) continue;
            String line = content.substring(0, newLine);
            this.lineListener.accept(line);
            this.buffer.delete(0, newLine + 1);
        } while (newLine != -1);
    }

    @Override
    public void onProcessed() {
        this.lineListener.accept(this.buffer.toString());
        this.buffer.setLength(0);
        this.delegate.onProcessed();
    }
}

