package de.flapdoodle.embed.process.config.io;

import de.flapdoodle.embed.process.io.StreamProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ProcessOutput}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableProcessOutput.builder()}.
 */
@Generated(from = "ProcessOutput", generator = "Immutables")
@SuppressWarnings({"all"})
public final class ImmutableProcessOutput implements ProcessOutput {
  private final StreamProcessor output;
  private final StreamProcessor error;
  private final StreamProcessor commands;

  private ImmutableProcessOutput(
      StreamProcessor output,
      StreamProcessor error,
      StreamProcessor commands) {
    this.output = output;
    this.error = error;
    this.commands = commands;
  }

  /**
   * @return The value of the {@code output} attribute
   */
  @Override
  public StreamProcessor output() {
    return output;
  }

  /**
   * @return The value of the {@code error} attribute
   */
  @Override
  public StreamProcessor error() {
    return error;
  }

  /**
   * @return The value of the {@code commands} attribute
   */
  @Override
  public StreamProcessor commands() {
    return commands;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessOutput#output() output} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for output
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessOutput withOutput(StreamProcessor value) {
    if (this.output == value) return this;
    StreamProcessor newValue = Objects.requireNonNull(value, "output");
    return new ImmutableProcessOutput(newValue, this.error, this.commands);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessOutput#error() error} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for error
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessOutput withError(StreamProcessor value) {
    if (this.error == value) return this;
    StreamProcessor newValue = Objects.requireNonNull(value, "error");
    return new ImmutableProcessOutput(this.output, newValue, this.commands);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessOutput#commands() commands} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commands
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessOutput withCommands(StreamProcessor value) {
    if (this.commands == value) return this;
    StreamProcessor newValue = Objects.requireNonNull(value, "commands");
    return new ImmutableProcessOutput(this.output, this.error, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableProcessOutput} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableProcessOutput
        && equalTo((ImmutableProcessOutput) another);
  }

  private boolean equalTo(ImmutableProcessOutput another) {
    return output.equals(another.output)
        && error.equals(another.error)
        && commands.equals(another.commands);
  }

  /**
   * Computes a hash code from attributes: {@code output}, {@code error}, {@code commands}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + output.hashCode();
    h += (h << 5) + error.hashCode();
    h += (h << 5) + commands.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ProcessOutput} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ProcessOutput{"
        + "output=" + output
        + ", error=" + error
        + ", commands=" + commands
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ProcessOutput} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ProcessOutput instance
   */
  public static ImmutableProcessOutput copyOf(ProcessOutput instance) {
    if (instance instanceof ImmutableProcessOutput) {
      return (ImmutableProcessOutput) instance;
    }
    return ImmutableProcessOutput.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableProcessOutput ImmutableProcessOutput}.
   * <pre>
   * ImmutableProcessOutput.builder()
   *    .output(de.flapdoodle.embed.process.io.StreamProcessor) // required {@link ProcessOutput#output() output}
   *    .error(de.flapdoodle.embed.process.io.StreamProcessor) // required {@link ProcessOutput#error() error}
   *    .commands(de.flapdoodle.embed.process.io.StreamProcessor) // required {@link ProcessOutput#commands() commands}
   *    .build();
   * </pre>
   * @return A new ImmutableProcessOutput builder
   */
  public static ImmutableProcessOutput.Builder builder() {
    return new ImmutableProcessOutput.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableProcessOutput ImmutableProcessOutput}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ProcessOutput", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_OUTPUT = 0x1L;
    private static final long INIT_BIT_ERROR = 0x2L;
    private static final long INIT_BIT_COMMANDS = 0x4L;
    private long initBits = 0x7L;

    private StreamProcessor output;
    private StreamProcessor error;
    private StreamProcessor commands;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ProcessOutput} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessOutput instance) {
      Objects.requireNonNull(instance, "instance");
      output(instance.output());
      error(instance.error());
      commands(instance.commands());
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessOutput#output() output} attribute.
     * @param output The value for output 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder output(StreamProcessor output) {
      this.output = Objects.requireNonNull(output, "output");
      initBits &= ~INIT_BIT_OUTPUT;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessOutput#error() error} attribute.
     * @param error The value for error 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder error(StreamProcessor error) {
      this.error = Objects.requireNonNull(error, "error");
      initBits &= ~INIT_BIT_ERROR;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessOutput#commands() commands} attribute.
     * @param commands The value for commands 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder commands(StreamProcessor commands) {
      this.commands = Objects.requireNonNull(commands, "commands");
      initBits &= ~INIT_BIT_COMMANDS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableProcessOutput ImmutableProcessOutput}.
     * @return An immutable instance of ProcessOutput
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableProcessOutput build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableProcessOutput(output, error, commands);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_OUTPUT) != 0) attributes.add("output");
      if ((initBits & INIT_BIT_ERROR) != 0) attributes.add("error");
      if ((initBits & INIT_BIT_COMMANDS) != 0) attributes.add("commands");
      return "Cannot build ProcessOutput, some of required attributes are not set " + attributes;
    }
  }
}
