/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.config;

import de.flapdoodle.embed.mongo.config.Storage;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="Storage", generator="Immutables")
public final class ImmutableStorage
extends Storage {
    private final int oplogSize;
    private final String replSetName;

    private ImmutableStorage(Builder builder) {
        this.replSetName = builder.replSetName;
        this.oplogSize = builder.oplogSizeIsSet() ? builder.oplogSize : super.getOplogSize();
    }

    private ImmutableStorage(int oplogSize, String replSetName) {
        this.oplogSize = oplogSize;
        this.replSetName = replSetName;
    }

    @Override
    public int getOplogSize() {
        return this.oplogSize;
    }

    @Override
    public String getReplSetName() {
        return this.replSetName;
    }

    public final ImmutableStorage withOplogSize(int value) {
        if (this.oplogSize == value) {
            return this;
        }
        return new ImmutableStorage(value, this.replSetName);
    }

    public final ImmutableStorage withReplSetName(String value) {
        String newValue = Objects.requireNonNull(value, "replSetName");
        if (this.replSetName.equals(newValue)) {
            return this;
        }
        return new ImmutableStorage(this.oplogSize, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStorage && this.equalTo(0, (ImmutableStorage)another);
    }

    private boolean equalTo(int synthetic, ImmutableStorage another) {
        return this.oplogSize == another.oplogSize && this.replSetName.equals(another.replSetName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.oplogSize;
        h += (h << 5) + this.replSetName.hashCode();
        return h;
    }

    public String toString() {
        return "Storage{oplogSize=" + this.oplogSize + ", replSetName=" + this.replSetName + "}";
    }

    public static ImmutableStorage copyOf(Storage instance) {
        if (instance instanceof ImmutableStorage) {
            return (ImmutableStorage)instance;
        }
        return ImmutableStorage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Storage", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_REPL_SET_NAME = 1L;
        private static final long OPT_BIT_OPLOG_SIZE = 1L;
        private long initBits = 1L;
        private long optBits;
        private int oplogSize;
        private String replSetName;

        private Builder() {
        }

        public final Builder from(Storage instance) {
            Objects.requireNonNull(instance, "instance");
            this.oplogSize(instance.getOplogSize());
            this.replSetName(instance.getReplSetName());
            return this;
        }

        public final Builder oplogSize(int oplogSize) {
            this.oplogSize = oplogSize;
            this.optBits |= 1L;
            return this;
        }

        public final Builder replSetName(String replSetName) {
            this.replSetName = Objects.requireNonNull(replSetName, "replSetName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableStorage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStorage(this);
        }

        private boolean oplogSizeIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("replSetName");
            }
            return "Cannot build Storage, some of required attributes are not set " + attributes;
        }
    }
}

