/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.config;

import de.codecentric.boot.admin.config.AdminClientProperties;
import de.codecentric.boot.admin.config.AdminProperties;
import de.codecentric.boot.admin.services.ApplicationRegistrator;
import de.codecentric.boot.admin.services.RegistrationApplicationListener;
import de.codecentric.boot.admin.web.BasicAuthHttpRequestInterceptor;
import java.util.Arrays;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableConfigurationProperties(value={AdminProperties.class, AdminClientProperties.class})
@ConditionalOnProperty(value={"spring.boot.admin.url"})
public class SpringBootAdminClientAutoConfiguration {
    @Autowired
    private AdminClientProperties client;
    @Autowired
    private AdminProperties admin;

    @Bean
    @ConditionalOnMissingBean
    public ApplicationRegistrator registrator() {
        return new ApplicationRegistrator(this.createRestTemplate(this.admin), this.admin, this.client);
    }

    protected RestTemplate createRestTemplate(AdminProperties admin) {
        RestTemplate template = new RestTemplate();
        template.getMessageConverters().add(new MappingJackson2HttpMessageConverter());
        if (admin.getUsername() != null) {
            template.setInterceptors(Arrays.asList(new BasicAuthHttpRequestInterceptor(admin.getUsername(), admin.getPassword())));
        }
        return template;
    }

    @Bean
    public ScheduledTaskRegistrar taskRegistrar() {
        ScheduledTaskRegistrar registrar = new ScheduledTaskRegistrar();
        Runnable registratorTask = new Runnable(){

            @Override
            public void run() {
                if (SpringBootAdminClientAutoConfiguration.this.client.isReady()) {
                    SpringBootAdminClientAutoConfiguration.this.registrator().register();
                }
            }
        };
        registrar.addFixedRateTask(registratorTask, (long)this.admin.getPeriod());
        return registrar;
    }

    @Bean
    public RegistrationApplicationListener registrationListener() {
        RegistrationApplicationListener listener = new RegistrationApplicationListener(this.registrator());
        listener.setAutoDeregister(this.admin.isAutoDeregistration());
        return listener;
    }
}

