/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.notify;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.entities.InstanceRepository;
import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.domain.events.InstanceStatusChangedEvent;
import de.codecentric.boot.admin.server.notify.AbstractStatusChangeNotifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class LoggingNotifier
extends AbstractStatusChangeNotifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingNotifier.class);

    public LoggingNotifier(InstanceRepository repository) {
        super(repository);
    }

    @Override
    protected Mono<Void> doNotify(InstanceEvent event, Instance instance) {
        return Mono.fromRunnable(() -> {
            if (event instanceof InstanceStatusChangedEvent) {
                InstanceStatusChangedEvent statusChangedEvent = (InstanceStatusChangedEvent)event;
                LOGGER.info("Instance {} ({}) is {}", new Object[]{instance.getRegistration().getName(), event.getInstance(), statusChangedEvent.getStatusInfo().getStatus()});
            } else {
                LOGGER.info("Instance {} ({}) {}", new Object[]{instance.getRegistration().getName(), event.getInstance(), event.getType()});
            }
        });
    }
}

