/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.config;

import de.codecentric.boot.admin.server.web.PathUtils;
import de.codecentric.boot.admin.server.web.client.BasicAuthHttpHeaderProvider;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DurationUnit;

@ConfigurationProperties(value="spring.boot.admin")
public class AdminServerProperties {
    private String contextPath = "";
    private ServerProperties server = new ServerProperties();
    private MonitorProperties monitor = new MonitorProperties();
    private InstanceAuthProperties instanceAuth = new InstanceAuthProperties();
    private InstanceProxyProperties instanceProxy = new InstanceProxyProperties();
    private String[] metadataKeysToSanitize = new String[]{".*password$", ".*secret$", ".*key$", ".*token$", ".*credentials.*", ".*vcap_services$"};
    private String[] probedEndpoints = new String[]{"health", "env", "metrics", "httptrace:trace", "httptrace", "threaddump:dump", "threaddump", "jolokia", "info", "logfile", "refresh", "flyway", "liquibase", "heapdump", "loggers", "auditevents", "mappings", "scheduledtasks", "configprops", "caches", "beans"};

    public void setContextPath(String contextPath) {
        this.contextPath = PathUtils.normalizePath(contextPath);
    }

    public String path(String path) {
        return this.contextPath + path;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public ServerProperties getServer() {
        return this.server;
    }

    public MonitorProperties getMonitor() {
        return this.monitor;
    }

    public InstanceAuthProperties getInstanceAuth() {
        return this.instanceAuth;
    }

    public InstanceProxyProperties getInstanceProxy() {
        return this.instanceProxy;
    }

    public String[] getMetadataKeysToSanitize() {
        return this.metadataKeysToSanitize;
    }

    public String[] getProbedEndpoints() {
        return this.probedEndpoints;
    }

    public void setServer(ServerProperties server) {
        this.server = server;
    }

    public void setMonitor(MonitorProperties monitor) {
        this.monitor = monitor;
    }

    public void setInstanceAuth(InstanceAuthProperties instanceAuth) {
        this.instanceAuth = instanceAuth;
    }

    public void setInstanceProxy(InstanceProxyProperties instanceProxy) {
        this.instanceProxy = instanceProxy;
    }

    public void setMetadataKeysToSanitize(String[] metadataKeysToSanitize) {
        this.metadataKeysToSanitize = metadataKeysToSanitize;
    }

    public void setProbedEndpoints(String[] probedEndpoints) {
        this.probedEndpoints = probedEndpoints;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdminServerProperties)) {
            return false;
        }
        AdminServerProperties other = (AdminServerProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$contextPath = this.getContextPath();
        String other$contextPath = other.getContextPath();
        if (this$contextPath == null ? other$contextPath != null : !this$contextPath.equals(other$contextPath)) {
            return false;
        }
        ServerProperties this$server = this.getServer();
        ServerProperties other$server = other.getServer();
        if (this$server == null ? other$server != null : !((Object)this$server).equals(other$server)) {
            return false;
        }
        MonitorProperties this$monitor = this.getMonitor();
        MonitorProperties other$monitor = other.getMonitor();
        if (this$monitor == null ? other$monitor != null : !((Object)this$monitor).equals(other$monitor)) {
            return false;
        }
        InstanceAuthProperties this$instanceAuth = this.getInstanceAuth();
        InstanceAuthProperties other$instanceAuth = other.getInstanceAuth();
        if (this$instanceAuth == null ? other$instanceAuth != null : !((Object)this$instanceAuth).equals(other$instanceAuth)) {
            return false;
        }
        InstanceProxyProperties this$instanceProxy = this.getInstanceProxy();
        InstanceProxyProperties other$instanceProxy = other.getInstanceProxy();
        if (this$instanceProxy == null ? other$instanceProxy != null : !((Object)this$instanceProxy).equals(other$instanceProxy)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getMetadataKeysToSanitize(), other.getMetadataKeysToSanitize())) {
            return false;
        }
        return Arrays.deepEquals(this.getProbedEndpoints(), other.getProbedEndpoints());
    }

    protected boolean canEqual(Object other) {
        return other instanceof AdminServerProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $contextPath = this.getContextPath();
        result = result * 59 + ($contextPath == null ? 43 : $contextPath.hashCode());
        ServerProperties $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : ((Object)$server).hashCode());
        MonitorProperties $monitor = this.getMonitor();
        result = result * 59 + ($monitor == null ? 43 : ((Object)$monitor).hashCode());
        InstanceAuthProperties $instanceAuth = this.getInstanceAuth();
        result = result * 59 + ($instanceAuth == null ? 43 : ((Object)$instanceAuth).hashCode());
        InstanceProxyProperties $instanceProxy = this.getInstanceProxy();
        result = result * 59 + ($instanceProxy == null ? 43 : ((Object)$instanceProxy).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getMetadataKeysToSanitize());
        result = result * 59 + Arrays.deepHashCode(this.getProbedEndpoints());
        return result;
    }

    public String toString() {
        return "AdminServerProperties(contextPath=" + this.getContextPath() + ", server=" + this.getServer() + ", monitor=" + this.getMonitor() + ", instanceAuth=" + this.getInstanceAuth() + ", instanceProxy=" + this.getInstanceProxy() + ", metadataKeysToSanitize=" + Arrays.deepToString(this.getMetadataKeysToSanitize()) + ", probedEndpoints=" + Arrays.deepToString(this.getProbedEndpoints()) + ")";
    }

    public static class ServerProperties {
        private boolean enabled = true;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ServerProperties)) {
                return false;
            }
            ServerProperties other = (ServerProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.isEnabled() == other.isEnabled();
        }

        protected boolean canEqual(Object other) {
            return other instanceof ServerProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "AdminServerProperties.ServerProperties(enabled=" + this.isEnabled() + ")";
        }
    }

    public static class MonitorProperties {
        @DurationUnit(value=ChronoUnit.MILLIS)
        private Duration statusInterval = Duration.ofMillis(10000L);
        @DurationUnit(value=ChronoUnit.MILLIS)
        private Duration statusLifetime = Duration.ofMillis(10000L);
        @DurationUnit(value=ChronoUnit.MILLIS)
        private Duration statusMaxBackoff = Duration.ofMillis(60000L);
        @DurationUnit(value=ChronoUnit.MILLIS)
        private Duration infoInterval = Duration.ofMinutes(1L);
        @DurationUnit(value=ChronoUnit.MILLIS)
        private Duration infoMaxBackoff = Duration.ofMinutes(10L);
        @DurationUnit(value=ChronoUnit.MILLIS)
        private Duration infoLifetime = Duration.ofMinutes(1L);
        private int defaultRetries = 0;
        private Map<String, Integer> retries = new HashMap<String, Integer>();
        @DurationUnit(value=ChronoUnit.MILLIS)
        private Duration defaultTimeout = Duration.ofMillis(10000L);
        @DurationUnit(value=ChronoUnit.MILLIS)
        private Map<String, Duration> timeout = new HashMap<String, Duration>();

        public Duration getStatusInterval() {
            return this.statusInterval;
        }

        public Duration getStatusLifetime() {
            return this.statusLifetime;
        }

        public Duration getStatusMaxBackoff() {
            return this.statusMaxBackoff;
        }

        public Duration getInfoInterval() {
            return this.infoInterval;
        }

        public Duration getInfoMaxBackoff() {
            return this.infoMaxBackoff;
        }

        public Duration getInfoLifetime() {
            return this.infoLifetime;
        }

        public int getDefaultRetries() {
            return this.defaultRetries;
        }

        public Map<String, Integer> getRetries() {
            return this.retries;
        }

        public Duration getDefaultTimeout() {
            return this.defaultTimeout;
        }

        public Map<String, Duration> getTimeout() {
            return this.timeout;
        }

        public void setStatusInterval(Duration statusInterval) {
            this.statusInterval = statusInterval;
        }

        public void setStatusLifetime(Duration statusLifetime) {
            this.statusLifetime = statusLifetime;
        }

        public void setStatusMaxBackoff(Duration statusMaxBackoff) {
            this.statusMaxBackoff = statusMaxBackoff;
        }

        public void setInfoInterval(Duration infoInterval) {
            this.infoInterval = infoInterval;
        }

        public void setInfoMaxBackoff(Duration infoMaxBackoff) {
            this.infoMaxBackoff = infoMaxBackoff;
        }

        public void setInfoLifetime(Duration infoLifetime) {
            this.infoLifetime = infoLifetime;
        }

        public void setDefaultRetries(int defaultRetries) {
            this.defaultRetries = defaultRetries;
        }

        public void setRetries(Map<String, Integer> retries) {
            this.retries = retries;
        }

        public void setDefaultTimeout(Duration defaultTimeout) {
            this.defaultTimeout = defaultTimeout;
        }

        public void setTimeout(Map<String, Duration> timeout) {
            this.timeout = timeout;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MonitorProperties)) {
                return false;
            }
            MonitorProperties other = (MonitorProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getDefaultRetries() != other.getDefaultRetries()) {
                return false;
            }
            Duration this$statusInterval = this.getStatusInterval();
            Duration other$statusInterval = other.getStatusInterval();
            if (this$statusInterval == null ? other$statusInterval != null : !((Object)this$statusInterval).equals(other$statusInterval)) {
                return false;
            }
            Duration this$statusLifetime = this.getStatusLifetime();
            Duration other$statusLifetime = other.getStatusLifetime();
            if (this$statusLifetime == null ? other$statusLifetime != null : !((Object)this$statusLifetime).equals(other$statusLifetime)) {
                return false;
            }
            Duration this$statusMaxBackoff = this.getStatusMaxBackoff();
            Duration other$statusMaxBackoff = other.getStatusMaxBackoff();
            if (this$statusMaxBackoff == null ? other$statusMaxBackoff != null : !((Object)this$statusMaxBackoff).equals(other$statusMaxBackoff)) {
                return false;
            }
            Duration this$infoInterval = this.getInfoInterval();
            Duration other$infoInterval = other.getInfoInterval();
            if (this$infoInterval == null ? other$infoInterval != null : !((Object)this$infoInterval).equals(other$infoInterval)) {
                return false;
            }
            Duration this$infoMaxBackoff = this.getInfoMaxBackoff();
            Duration other$infoMaxBackoff = other.getInfoMaxBackoff();
            if (this$infoMaxBackoff == null ? other$infoMaxBackoff != null : !((Object)this$infoMaxBackoff).equals(other$infoMaxBackoff)) {
                return false;
            }
            Duration this$infoLifetime = this.getInfoLifetime();
            Duration other$infoLifetime = other.getInfoLifetime();
            if (this$infoLifetime == null ? other$infoLifetime != null : !((Object)this$infoLifetime).equals(other$infoLifetime)) {
                return false;
            }
            Map<String, Integer> this$retries = this.getRetries();
            Map<String, Integer> other$retries = other.getRetries();
            if (this$retries == null ? other$retries != null : !((Object)this$retries).equals(other$retries)) {
                return false;
            }
            Duration this$defaultTimeout = this.getDefaultTimeout();
            Duration other$defaultTimeout = other.getDefaultTimeout();
            if (this$defaultTimeout == null ? other$defaultTimeout != null : !((Object)this$defaultTimeout).equals(other$defaultTimeout)) {
                return false;
            }
            Map<String, Duration> this$timeout = this.getTimeout();
            Map<String, Duration> other$timeout = other.getTimeout();
            return !(this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MonitorProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getDefaultRetries();
            Duration $statusInterval = this.getStatusInterval();
            result = result * 59 + ($statusInterval == null ? 43 : ((Object)$statusInterval).hashCode());
            Duration $statusLifetime = this.getStatusLifetime();
            result = result * 59 + ($statusLifetime == null ? 43 : ((Object)$statusLifetime).hashCode());
            Duration $statusMaxBackoff = this.getStatusMaxBackoff();
            result = result * 59 + ($statusMaxBackoff == null ? 43 : ((Object)$statusMaxBackoff).hashCode());
            Duration $infoInterval = this.getInfoInterval();
            result = result * 59 + ($infoInterval == null ? 43 : ((Object)$infoInterval).hashCode());
            Duration $infoMaxBackoff = this.getInfoMaxBackoff();
            result = result * 59 + ($infoMaxBackoff == null ? 43 : ((Object)$infoMaxBackoff).hashCode());
            Duration $infoLifetime = this.getInfoLifetime();
            result = result * 59 + ($infoLifetime == null ? 43 : ((Object)$infoLifetime).hashCode());
            Map<String, Integer> $retries = this.getRetries();
            result = result * 59 + ($retries == null ? 43 : ((Object)$retries).hashCode());
            Duration $defaultTimeout = this.getDefaultTimeout();
            result = result * 59 + ($defaultTimeout == null ? 43 : ((Object)$defaultTimeout).hashCode());
            Map<String, Duration> $timeout = this.getTimeout();
            result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
            return result;
        }

        public String toString() {
            return "AdminServerProperties.MonitorProperties(statusInterval=" + this.getStatusInterval() + ", statusLifetime=" + this.getStatusLifetime() + ", statusMaxBackoff=" + this.getStatusMaxBackoff() + ", infoInterval=" + this.getInfoInterval() + ", infoMaxBackoff=" + this.getInfoMaxBackoff() + ", infoLifetime=" + this.getInfoLifetime() + ", defaultRetries=" + this.getDefaultRetries() + ", retries=" + this.getRetries() + ", defaultTimeout=" + this.getDefaultTimeout() + ", timeout=" + this.getTimeout() + ")";
        }
    }

    public static class InstanceAuthProperties {
        private boolean enabled = true;
        private String defaultUserName = null;
        private String defaultPassword = null;
        private Map<String, BasicAuthHttpHeaderProvider.InstanceCredentials> serviceMap = new HashMap<String, BasicAuthHttpHeaderProvider.InstanceCredentials>();

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getDefaultUserName() {
            return this.defaultUserName;
        }

        public String getDefaultPassword() {
            return this.defaultPassword;
        }

        public Map<String, BasicAuthHttpHeaderProvider.InstanceCredentials> getServiceMap() {
            return this.serviceMap;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setDefaultUserName(String defaultUserName) {
            this.defaultUserName = defaultUserName;
        }

        public void setDefaultPassword(String defaultPassword) {
            this.defaultPassword = defaultPassword;
        }

        public void setServiceMap(Map<String, BasicAuthHttpHeaderProvider.InstanceCredentials> serviceMap) {
            this.serviceMap = serviceMap;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InstanceAuthProperties)) {
                return false;
            }
            InstanceAuthProperties other = (InstanceAuthProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            String this$defaultUserName = this.getDefaultUserName();
            String other$defaultUserName = other.getDefaultUserName();
            if (this$defaultUserName == null ? other$defaultUserName != null : !this$defaultUserName.equals(other$defaultUserName)) {
                return false;
            }
            String this$defaultPassword = this.getDefaultPassword();
            String other$defaultPassword = other.getDefaultPassword();
            if (this$defaultPassword == null ? other$defaultPassword != null : !this$defaultPassword.equals(other$defaultPassword)) {
                return false;
            }
            Map<String, BasicAuthHttpHeaderProvider.InstanceCredentials> this$serviceMap = this.getServiceMap();
            Map<String, BasicAuthHttpHeaderProvider.InstanceCredentials> other$serviceMap = other.getServiceMap();
            return !(this$serviceMap == null ? other$serviceMap != null : !((Object)this$serviceMap).equals(other$serviceMap));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InstanceAuthProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            String $defaultUserName = this.getDefaultUserName();
            result = result * 59 + ($defaultUserName == null ? 43 : $defaultUserName.hashCode());
            String $defaultPassword = this.getDefaultPassword();
            result = result * 59 + ($defaultPassword == null ? 43 : $defaultPassword.hashCode());
            Map<String, BasicAuthHttpHeaderProvider.InstanceCredentials> $serviceMap = this.getServiceMap();
            result = result * 59 + ($serviceMap == null ? 43 : ((Object)$serviceMap).hashCode());
            return result;
        }

        public String toString() {
            return "AdminServerProperties.InstanceAuthProperties(enabled=" + this.isEnabled() + ", defaultUserName=" + this.getDefaultUserName() + ", defaultPassword=" + this.getDefaultPassword() + ", serviceMap=" + this.getServiceMap() + ")";
        }
    }

    public static class InstanceProxyProperties {
        private Set<String> ignoredHeaders = new HashSet<String>(Arrays.asList("Cookie", "Set-Cookie", "Authorization"));

        public Set<String> getIgnoredHeaders() {
            return this.ignoredHeaders;
        }

        public void setIgnoredHeaders(Set<String> ignoredHeaders) {
            this.ignoredHeaders = ignoredHeaders;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InstanceProxyProperties)) {
                return false;
            }
            InstanceProxyProperties other = (InstanceProxyProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Set<String> this$ignoredHeaders = this.getIgnoredHeaders();
            Set<String> other$ignoredHeaders = other.getIgnoredHeaders();
            return !(this$ignoredHeaders == null ? other$ignoredHeaders != null : !((Object)this$ignoredHeaders).equals(other$ignoredHeaders));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InstanceProxyProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<String> $ignoredHeaders = this.getIgnoredHeaders();
            result = result * 59 + ($ignoredHeaders == null ? 43 : ((Object)$ignoredHeaders).hashCode());
            return result;
        }

        public String toString() {
            return "AdminServerProperties.InstanceProxyProperties(ignoredHeaders=" + this.getIgnoredHeaders() + ")";
        }
    }
}

