/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.domain.entities;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.entities.InstanceRepository;
import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.domain.values.InstanceId;
import de.codecentric.boot.admin.server.eventstore.InstanceEventStore;
import de.codecentric.boot.admin.server.eventstore.OptimisticLockingException;
import java.util.Collection;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

public class EventsourcingInstanceRepository
implements InstanceRepository {
    private static final Logger log = LoggerFactory.getLogger(EventsourcingInstanceRepository.class);
    private final InstanceEventStore eventStore;
    private final Retry retryOptimisticLockException = Retry.max((long)10L).doBeforeRetry(s -> log.debug("Retrying after OptimisticLockingException", s.failure())).filter(OptimisticLockingException.class::isInstance);

    public EventsourcingInstanceRepository(InstanceEventStore eventStore) {
        this.eventStore = eventStore;
    }

    @Override
    public Mono<Instance> save(Instance instance) {
        return this.eventStore.append(instance.getUnsavedEvents()).then(Mono.just((Object)instance.clearUnsavedEvents()));
    }

    @Override
    public Flux<Instance> findAll() {
        return this.eventStore.findAll().groupBy(InstanceEvent::getInstance).flatMap(f -> f.reduce((Object)Instance.create((InstanceId)f.key()), Instance::apply));
    }

    @Override
    public Mono<Instance> find(InstanceId id) {
        return this.eventStore.find(id).collectList().filter(e -> !e.isEmpty()).map(e -> Instance.create(id).apply((Collection<InstanceEvent>)e));
    }

    @Override
    public Flux<Instance> findByName(String name) {
        return this.findAll().filter(a -> a.isRegistered() && name.equals(a.getRegistration().getName()));
    }

    @Override
    public Mono<Instance> compute(InstanceId id, BiFunction<InstanceId, Instance, Mono<Instance>> remappingFunction) {
        return this.find(id).flatMap(application -> (Mono)remappingFunction.apply(id, (Instance)application)).switchIfEmpty(Mono.defer(() -> (Mono)remappingFunction.apply(id, null))).flatMap(this::save).retryWhen(this.retryOptimisticLockException);
    }

    @Override
    public Mono<Instance> computeIfPresent(InstanceId id, BiFunction<InstanceId, Instance, Mono<Instance>> remappingFunction) {
        return this.find(id).flatMap(application -> (Mono)remappingFunction.apply(id, (Instance)application)).flatMap(this::save).retryWhen(this.retryOptimisticLockException);
    }
}

