/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.domain.values;

import java.io.Serializable;
import java.util.Map;
import java.util.Scanner;
import javax.annotation.Nullable;
import org.springframework.util.Assert;

public final class BuildVersion
implements Serializable,
Comparable<BuildVersion> {
    private final String value;

    private BuildVersion(String value) {
        Assert.hasText((String)value, (String)"'value' must not be empty");
        this.value = value;
    }

    public static BuildVersion valueOf(String s) {
        return new BuildVersion(s);
    }

    @Nullable
    public static BuildVersion from(Map<String, ?> map) {
        Object version;
        if (map.isEmpty()) {
            return null;
        }
        Object build = map.get("build");
        if (build instanceof Map && (version = ((Map)build).get("version")) instanceof String) {
            return BuildVersion.valueOf((String)version);
        }
        version = map.get("build.version");
        if (version instanceof String) {
            return BuildVersion.valueOf((String)version);
        }
        version = map.get("version");
        if (version instanceof String) {
            return BuildVersion.valueOf((String)version);
        }
        return null;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    @Override
    public int compareTo(BuildVersion other) {
        try (Scanner s1 = new Scanner(this.value);
             Scanner s2 = new Scanner(other.value);){
            int n;
            s1.useDelimiter("[.\\-+]");
            s2.useDelimiter("[.\\-+]");
            while (s1.hasNext() && s2.hasNext()) {
                int c = s1.hasNextInt() && s2.hasNextInt() ? Integer.compare(s1.nextInt(), s2.nextInt()) : s1.next().compareTo(s2.next());
                if (c == 0) continue;
                int n2 = c;
                return n2;
            }
            if (s1.hasNext()) {
                n = 1;
                return n;
            }
            if (s2.hasNext()) {
                n = -1;
                return n;
            }
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildVersion)) {
            return false;
        }
        BuildVersion other = (BuildVersion)o;
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

