/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.web.client;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.values.Endpoint;
import de.codecentric.boot.admin.server.web.client.HttpHeadersProvider;
import de.codecentric.boot.admin.server.web.client.InstanceExchangeFilterFunction;
import de.codecentric.boot.admin.server.web.client.LegacyEndpointConverter;
import de.codecentric.boot.admin.server.web.client.exception.ResolveEndpointException;
import de.codecentric.boot.admin.server.web.client.exception.ResolveInstanceException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class InstanceExchangeFilterFunctions {
    private static final Logger log = LoggerFactory.getLogger(InstanceExchangeFilterFunctions.class);
    public static final String ATTRIBUTE_INSTANCE = "instance";
    public static final String ATTRIBUTE_ENDPOINT = "endpointId";
    private static final List<MediaType> DEFAULT_ACCEPT_MEDIATYPES = Arrays.asList(MediaType.parseMediaType((String)"application/vnd.spring-boot.actuator.v2+json"), MediaType.parseMediaType((String)"application/vnd.spring-boot.actuator.v1+json"), MediaType.APPLICATION_JSON);
    private static final List<MediaType> DEFAULT_LOGFILE_ACCEPT_MEDIATYPES = Arrays.asList(MediaType.TEXT_PLAIN, MediaType.ALL);

    private InstanceExchangeFilterFunctions() {
    }

    public static ExchangeFilterFunction setInstance(Instance instance) {
        return InstanceExchangeFilterFunctions.setInstance((Mono<Instance>)Mono.just((Object)instance));
    }

    public static ExchangeFilterFunction setInstance(Mono<Instance> instance) {
        return (request, next) -> instance.map(i -> ClientRequest.from((ClientRequest)request).attribute(ATTRIBUTE_INSTANCE, i).build()).switchIfEmpty(request.url().isAbsolute() ? Mono.just((Object)request) : Mono.error((Throwable)new ResolveInstanceException("Could not resolve Instance"))).flatMap(arg_0 -> ((ExchangeFunction)next).exchange(arg_0));
    }

    public static ExchangeFilterFunction addHeaders(HttpHeadersProvider httpHeadersProvider) {
        return InstanceExchangeFilterFunctions.toExchangeFilterFunction((instance, request, next) -> {
            ClientRequest newRequest = ClientRequest.from((ClientRequest)request).headers(headers -> headers.addAll((MultiValueMap)httpHeadersProvider.getHeaders(instance))).build();
            return next.exchange(newRequest);
        });
    }

    public static ExchangeFilterFunction toExchangeFilterFunction(InstanceExchangeFilterFunction delegate) {
        return (request, next) -> {
            Optional instance = request.attribute(ATTRIBUTE_INSTANCE);
            if (instance.isPresent() && instance.get() instanceof Instance) {
                return delegate.exchange((Instance)instance.get(), request, next);
            }
            return next.exchange(request);
        };
    }

    public static ExchangeFilterFunction rewriteEndpointUrl() {
        return InstanceExchangeFilterFunctions.toExchangeFilterFunction((instance, request, next) -> {
            if (request.url().isAbsolute()) {
                log.trace("Absolute URL '{}' for instance {} not rewritten", (Object)request.url(), (Object)instance.getId());
                if (request.url().toString().equals(instance.getRegistration().getManagementUrl())) {
                    return next.exchange(ClientRequest.from((ClientRequest)request).attribute(ATTRIBUTE_ENDPOINT, (Object)"actuator-index").build());
                }
                return next.exchange(request);
            }
            UriComponents oldUrl = UriComponentsBuilder.fromUri((URI)request.url()).build();
            if (oldUrl.getPathSegments().isEmpty()) {
                return Mono.error((Throwable)new ResolveEndpointException("No endpoint specified"));
            }
            String endpointId = (String)oldUrl.getPathSegments().get(0);
            Optional<Endpoint> endpoint = instance.getEndpoints().get(endpointId);
            if (!endpoint.isPresent()) {
                return Mono.error((Throwable)new ResolveEndpointException("Endpoint '" + endpointId + "' not found"));
            }
            URI newUrl = InstanceExchangeFilterFunctions.rewriteUrl(oldUrl, endpoint.get().getUrl());
            log.trace("URL '{}' for Endpoint {} of instance {} rewritten to {}", new Object[]{oldUrl, endpoint.get().getId(), instance.getId(), newUrl});
            ClientRequest newRequest = ClientRequest.from((ClientRequest)request).attribute(ATTRIBUTE_ENDPOINT, (Object)endpoint.get().getId()).url(newUrl).build();
            return next.exchange(newRequest);
        });
    }

    private static URI rewriteUrl(UriComponents oldUrl, String targetUrl) {
        String[] newPathSegments = oldUrl.getPathSegments().subList(1, oldUrl.getPathSegments().size()).toArray(new String[0]);
        return UriComponentsBuilder.fromUriString((String)targetUrl).pathSegment(newPathSegments).query(oldUrl.getQuery()).build(true).toUri();
    }

    public static ExchangeFilterFunction convertLegacyEndpoint(LegacyEndpointConverter converter) {
        return (request, next) -> {
            Mono clientResponse = next.exchange(request);
            if (request.attribute(ATTRIBUTE_ENDPOINT).map(converter::canConvert).orElse(false).booleanValue()) {
                return clientResponse.flatMap(response -> {
                    if (response.headers().contentType().map(t -> de.codecentric.boot.admin.server.utils.MediaType.ACTUATOR_V1_MEDIATYPE.isCompatibleWith(t) || MediaType.APPLICATION_JSON.isCompatibleWith(t)).orElse(false).booleanValue()) {
                        return InstanceExchangeFilterFunctions.convertClientResponse(converter::convert, de.codecentric.boot.admin.server.utils.MediaType.ACTUATOR_V2_MEDIATYPE).apply((ClientResponse)response);
                    }
                    return Mono.just((Object)response);
                });
            }
            return clientResponse;
        };
    }

    private static Function<ClientResponse, Mono<ClientResponse>> convertClientResponse(Function<Flux<DataBuffer>, Flux<DataBuffer>> bodConverter, MediaType contentType) {
        return response -> {
            ClientResponse convertedResponse = ClientResponse.from((ClientResponse)response).headers(headers -> {
                headers.replace((Object)"Content-Type", Collections.singletonList(contentType.toString()));
                headers.remove((Object)"Content-Length");
            }).body(response.bodyToFlux(DataBuffer.class).transform(bodConverter)).build();
            return Mono.just((Object)convertedResponse);
        };
    }

    public static ExchangeFilterFunction setDefaultAcceptHeader() {
        return (request, next) -> {
            if (request.headers().getAccept().isEmpty()) {
                Boolean isRequestForLogfile = request.attribute(ATTRIBUTE_ENDPOINT).map("logfile"::equals).orElse(false);
                List<MediaType> acceptedHeaders = isRequestForLogfile != false ? DEFAULT_LOGFILE_ACCEPT_MEDIATYPES : DEFAULT_ACCEPT_MEDIATYPES;
                return next.exchange(ClientRequest.from((ClientRequest)request).headers(headers -> headers.setAccept(acceptedHeaders)).build());
            }
            return next.exchange(request);
        };
    }

    public static ExchangeFilterFunction retry(int defaultRetries, Map<String, Integer> retriesPerEndpoint) {
        return (request, next) -> {
            int retries = 0;
            if (!(request.method().equals((Object)HttpMethod.DELETE) || request.method().equals((Object)HttpMethod.PATCH) || request.method().equals((Object)HttpMethod.POST) || request.method().equals((Object)HttpMethod.PUT))) {
                retries = request.attribute(ATTRIBUTE_ENDPOINT).map(retriesPerEndpoint::get).orElse(defaultRetries);
            }
            return next.exchange(request).retry((long)retries);
        };
    }
}

