/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.web.servlet.resource;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.servlet.resource.AbstractResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolverChain;

public class ResourcePatternResolvingResourceResolver
extends AbstractResourceResolver {
    private final ResourcePatternResolver resourcePatternResolver;
    private final String pattern;

    public ResourcePatternResolvingResourceResolver(ResourcePatternResolver resourcePatternResolver, String pattern) {
        this.resourcePatternResolver = resourcePatternResolver;
        this.pattern = pattern;
    }

    protected Resource resolveResourceInternal(HttpServletRequest request, String requestPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        try {
            Object[] resources = this.resourcePatternResolver.getResources(this.pattern);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Resolved Resources for '" + this.pattern + "': " + Arrays.toString(resources)));
            }
            return chain.resolveResource(request, requestPath, Arrays.asList(resources));
        }
        catch (IOException ex) {
            throw new ResourceAccessException("Couldn't resolve resources for \"" + this.pattern + "\"", ex);
        }
    }

    protected String resolveUrlPathInternal(String resourceUrlPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        return chain.resolveUrlPath(resourceUrlPath, locations);
    }
}

