/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.notify;

import de.codecentric.boot.admin.event.ClientApplicationEvent;
import de.codecentric.boot.admin.event.ClientApplicationStatusChangedEvent;
import de.codecentric.boot.admin.notify.AbstractStatusChangeNotifier;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.web.client.RestTemplate;

public class PagerdutyNotifier
extends AbstractStatusChangeNotifier {
    public static final URI DEFAULT_URI = URI.create("https://events.pagerduty.com/generic/2010-04-15/create_event.json");
    private static final String DEFAULT_DESCRIPTION = "#{application.name}/#{application.id} is #{to.status}";
    private final SpelExpressionParser parser = new SpelExpressionParser();
    private RestTemplate restTemplate = new RestTemplate();
    private URI url = DEFAULT_URI;
    private String serviceKey;
    private String client;
    private URI clientUrl;
    private Expression description = this.parser.parseExpression("#{application.name}/#{application.id} is #{to.status}", ParserContext.TEMPLATE_EXPRESSION);

    @Override
    protected void doNotify(ClientApplicationEvent event) throws Exception {
        this.restTemplate.postForEntity(this.url, this.createPagerdutyEvent(event), Void.class);
    }

    protected Map<String, Object> createPagerdutyEvent(ClientApplicationEvent event) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("service_key", this.serviceKey);
        result.put("incident_key", event.getApplication().getName() + "/" + event.getApplication().getId());
        result.put("description", this.getDescription(event));
        Map<String, Object> details = this.getDetails(event);
        result.put("details", details);
        if (event instanceof ClientApplicationStatusChangedEvent) {
            if ("UP".equals(((ClientApplicationStatusChangedEvent)event).getTo().getStatus())) {
                result.put("event_type", "resolve");
            } else {
                result.put("event_type", "trigger");
                if (this.client != null) {
                    result.put("client", this.client);
                }
                if (this.clientUrl != null) {
                    result.put("client_url", this.clientUrl);
                }
                HashMap<String, String> context = new HashMap<String, String>();
                context.put("type", "link");
                context.put("href", event.getApplication().getHealthUrl());
                context.put("text", "Application health-endpoint");
                result.put("contexts", Collections.singletonList(context));
            }
        }
        return result;
    }

    protected String getDescription(ClientApplicationEvent event) {
        return (String)this.description.getValue((Object)event, String.class);
    }

    protected Map<String, Object> getDetails(ClientApplicationEvent event) {
        HashMap<String, Object> details = new HashMap<String, Object>();
        if (event instanceof ClientApplicationStatusChangedEvent) {
            details.put("from", ((ClientApplicationStatusChangedEvent)event).getFrom());
            details.put("to", ((ClientApplicationStatusChangedEvent)event).getTo());
        }
        return details;
    }

    public void setUrl(URI url) {
        this.url = url;
    }

    public URI getUrl() {
        return this.url;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public String getClient() {
        return this.client;
    }

    public void setClientUrl(URI clientUrl) {
        this.clientUrl = clientUrl;
    }

    public URI getClientUrl() {
        return this.clientUrl;
    }

    public void setServiceKey(String serviceKey) {
        this.serviceKey = serviceKey;
    }

    public String getServiceKey() {
        return this.serviceKey;
    }

    public void setDescription(String description) {
        this.description = this.parser.parseExpression(description, ParserContext.TEMPLATE_EXPRESSION);
    }

    public String getDescription() {
        return this.description.getExpressionString();
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }
}

