/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.web;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class PrefixHandlerMapping
extends RequestMappingHandlerMapping {
    private String prefix = "";
    private final Object[] handlers;

    public PrefixHandlerMapping(Object ... handlers) {
        this.handlers = (Object[])handlers.clone();
        this.setOrder(-50);
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        for (Object handler : this.handlers) {
            this.detectHandlerMethods(handler);
        }
    }

    protected boolean isHandler(Class<?> beanType) {
        return false;
    }

    protected void registerHandlerMethod(Object handler, Method method, RequestMappingInfo mapping) {
        if (mapping == null) {
            return;
        }
        super.registerHandlerMethod(handler, method, (Object)this.withPrefix(mapping));
    }

    private RequestMappingInfo withPrefix(RequestMappingInfo mapping) {
        List<String> newPatterns = this.getPatterns(mapping);
        PatternsRequestCondition patterns = new PatternsRequestCondition(newPatterns.toArray(new String[newPatterns.size()]));
        return new RequestMappingInfo(patterns, mapping.getMethodsCondition(), mapping.getParamsCondition(), mapping.getHeadersCondition(), mapping.getConsumesCondition(), mapping.getProducesCondition(), mapping.getCustomCondition());
    }

    private List<String> getPatterns(RequestMappingInfo mapping) {
        ArrayList<String> newPatterns = new ArrayList<String>(mapping.getPatternsCondition().getPatterns().size());
        for (String pattern : mapping.getPatternsCondition().getPatterns()) {
            newPatterns.add(this.prefix + pattern);
        }
        return newPatterns;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }
}

