/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.ui.extensions;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.StringUtils;

public class UiRoutesScanner {
    private static final Logger log = LoggerFactory.getLogger(UiRoutesScanner.class);
    private final ResourcePatternResolver resolver;

    public UiRoutesScanner(ResourcePatternResolver resolver) {
        this.resolver = resolver;
    }

    public List<String> scan(String ... locations) throws IOException {
        ArrayList<String> routes = new ArrayList<String>();
        for (String location : locations) {
            for (Resource resource : this.resolver.getResources(this.toPattern(location) + "**/routes.txt")) {
                if (!resource.isReadable()) continue;
                routes.addAll(this.readLines(resource.getInputStream()));
            }
        }
        return routes;
    }

    private List<String> readLines(InputStream input) {
        List<String> list;
        BufferedReader buffer = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
        try {
            list = buffer.lines().map(String::trim).filter(StringUtils::hasText).toList();
        }
        catch (Throwable throwable) {
            try {
                try {
                    buffer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                log.warn("Couldn't read routes from", (Throwable)ex);
                return Collections.emptyList();
            }
        }
        buffer.close();
        return list;
    }

    private String toPattern(String location) {
        return location.replace("classpath:", "classpath*:");
    }
}

