/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.client.registration;

import de.codecentric.boot.admin.client.config.InstanceProperties;
import de.codecentric.boot.admin.client.registration.DefaultApplicationFactory;
import de.codecentric.boot.admin.client.registration.metadata.MetadataContributor;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.actuate.endpoint.web.PathMappedEndpoints;
import org.springframework.boot.web.server.Ssl;
import org.springframework.boot.web.server.autoconfigure.ServerProperties;
import org.springframework.boot.webflux.autoconfigure.WebFluxProperties;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class ReactiveApplicationFactory
extends DefaultApplicationFactory {
    private final ManagementServerProperties management;
    private final ServerProperties server;
    private final WebFluxProperties webflux;
    private final InstanceProperties instance;

    public ReactiveApplicationFactory(InstanceProperties instance, ManagementServerProperties management, ServerProperties server, PathMappedEndpoints pathMappedEndpoints, WebEndpointProperties webEndpoint, MetadataContributor metadataContributor, WebFluxProperties webFluxProperties) {
        super(instance, management, server, pathMappedEndpoints, webEndpoint, metadataContributor);
        this.management = management;
        this.server = server;
        this.webflux = webFluxProperties;
        this.instance = instance;
    }

    @Override
    protected String getServiceUrl() {
        if (this.instance.getServiceUrl() != null) {
            return this.instance.getServiceUrl();
        }
        return UriComponentsBuilder.fromUriString((String)this.getServiceBaseUrl()).path(this.getServicePath()).path(this.getWebfluxBasePath()).toUriString();
    }

    @Override
    protected String getManagementBaseUrl() {
        String baseUrl = this.instance.getManagementBaseUrl();
        if (StringUtils.hasText((String)baseUrl)) {
            return baseUrl;
        }
        if (this.isManagementPortEqual()) {
            return this.getServiceUrl();
        }
        Ssl ssl = this.management.getSsl() != null ? this.management.getSsl() : this.server.getSsl();
        return UriComponentsBuilder.newInstance().scheme(this.getScheme(ssl)).host(this.getManagementHost()).port(this.getLocalManagementPort().intValue()).path(this.getManagementContextPath()).toUriString();
    }

    protected String getManagementContextPath() {
        return this.management.getBasePath();
    }

    protected String getWebfluxBasePath() {
        return this.webflux.getBasePath();
    }
}

